/*
 * Decompiled with CFR 0.152.
 */
package cn.dolphin.core.jdbc.query;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

public abstract class Builder {
    private StringBuilder query = new StringBuilder();
    private List<Object> params = new ArrayList<Object>();

    public Builder(String base) {
        this.query.append(base);
    }

    public Builder where(String field, String condition, Object param) {
        String template = " %s %s ?";
        String where = String.format(template, field, condition);
        if (this.hasWhere()) {
            this.query.append(" and").append(where);
        } else {
            this.query.append(" where").append(where);
        }
        this.params.add(param);
        return this;
    }

    public Builder append(String q) {
        this.query.append(" ").append(q);
        return this;
    }

    public Builder eq(String field, Object param) {
        return this.where(field, "=", param);
    }

    public Builder like(String field, Object param) {
        return this.where(field, "like", param);
    }

    public Builder notEq(String field, Object param) {
        return this.where(field, "<>", param);
    }

    public Builder gt(String field, Object param) {
        return this.where(field, ">", param);
    }

    public Builder lt(String field, Object param) {
        return this.where(field, "<", param);
    }

    public Builder ge(String field, Object param) {
        return this.where(field, ">=", param);
    }

    public Builder le(String field, Object param) {
        return this.where(field, "<=", param);
    }

    public Builder in(String field, Object param) {
        return this.where(field, "in", param);
    }

    public Builder in(String field, Collection params) {
        if (params.size() > 0) {
            if (params.size() == 1) {
                this.in(field, params.iterator().next());
            } else {
                String template = " %s in (%s)";
                StringBuilder sb = new StringBuilder();
                for (int i = 0; i < params.size(); ++i) {
                    sb.append(",?");
                }
                String where = String.format(template, field, sb.substring(1));
                if (this.hasWhere()) {
                    this.query.append(" and").append(where);
                } else {
                    this.query.append(" where").append(where);
                }
                this.params.addAll(params);
            }
        }
        return this;
    }

    public Builder in(String field, Object[] params) {
        return this.in(field, Arrays.asList(params));
    }

    public Builder order(String field, String sort) {
        this.query.append(" order by ").append(field).append(" ").append(sort);
        return this;
    }

    public Builder asc(String field) {
        return this.order(field, "asc");
    }

    public Builder desc(String field) {
        return this.order(field, "desc");
    }

    public Builder group(String field) {
        this.query.append(" group by ").append(field);
        return this;
    }

    public Builder having(String field) {
        this.query.append(" having ").append(field);
        return this;
    }

    private boolean hasWhere() {
        return this.query.toString().toLowerCase().indexOf("where") > 0;
    }

    protected StringBuilder getQuery() {
        return this.query;
    }

    public Object[] getParams() {
        return this.params.toArray();
    }

    public Builder reset() {
        this.query = new StringBuilder();
        this.params.clear();
        return this;
    }
}

