/*
 * Decompiled with CFR 0.152.
 */
package cn.dolphin.core.jdbc.mapper;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Map;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.support.JdbcUtils;
import org.springframework.util.LinkedCaseInsensitiveMap;

public class JavaColumnMapRowMapper
implements RowMapper<Map<String, Object>> {
    public Map<String, Object> mapRow(ResultSet rs, int rowNum) throws SQLException {
        ResultSetMetaData rsmd = rs.getMetaData();
        int columnCount = rsmd.getColumnCount();
        Map<String, Object> mapOfColValues = this.createColumnMap(columnCount);
        for (int i = 1; i <= columnCount; ++i) {
            String key = this.getColumnKey(JdbcUtils.lookupColumnName((ResultSetMetaData)rsmd, (int)i));
            Object obj = this.toJavaObj(this.getColumnValue(rs, i));
            mapOfColValues.put(key, obj);
        }
        return mapOfColValues;
    }

    private Object toJavaObj(Object resultSetValue) {
        if (resultSetValue == null) {
            return null;
        }
        if (resultSetValue instanceof Timestamp) {
            return new Date(((Timestamp)resultSetValue).getTime());
        }
        if (resultSetValue instanceof java.sql.Date) {
            return new Date(((java.sql.Date)resultSetValue).getTime());
        }
        if (resultSetValue instanceof byte[]) {
            return new String((byte[])resultSetValue);
        }
        return resultSetValue;
    }

    protected Map<String, Object> createColumnMap(int columnCount) {
        return new LinkedCaseInsensitiveMap(columnCount);
    }

    protected String getColumnKey(String columnName) {
        return columnName;
    }

    protected Object getColumnValue(ResultSet rs, int index) throws SQLException {
        return JdbcUtils.getResultSetValue((ResultSet)rs, (int)index);
    }
}

