/*
 * Decompiled with CFR 0.152.
 */
package cn.dolphin.core.jdbc.framework;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.springframework.jdbc.core.PreparedStatementCreator;

public class PreparedStatementCreatorImpl
implements PreparedStatementCreator {
    private String sql;
    private Object[] values;
    private int[] types;
    private String pkName;

    public PreparedStatementCreatorImpl(String sql, Object[] values, int[] types) {
        this.sql = sql;
        this.values = values;
        this.types = types;
    }

    public PreparedStatementCreatorImpl(String sql, Object[] values, int[] types, String pkName) {
        this(sql, values, types);
        this.pkName = pkName;
    }

    public PreparedStatement createPreparedStatement(Connection conn) throws SQLException {
        PreparedStatement ps = this.pkName == null ? conn.prepareStatement(this.sql) : conn.prepareStatement(this.sql, new String[]{this.pkName});
        PreparedStatementCreatorImpl.setValues(ps, this.values, this.types);
        return ps;
    }

    public static void setValues(PreparedStatement ps, Object[] values, int[] types) throws SQLException {
        if (types == null) {
            for (int i = 0; i < values.length; ++i) {
                if (values[i] == null) {
                    ps.setObject(i + 1, null);
                    continue;
                }
                if (values[i] instanceof Date) {
                    ps.setDate(i + 1, new java.sql.Date(((Date)values[i]).getTime()));
                    continue;
                }
                ps.setObject(i + 1, values[i]);
            }
        } else {
            block12: for (int i = 0; i < values.length; ++i) {
                if (values[i] == null) {
                    ps.setNull(i + 1, types[i]);
                    continue;
                }
                switch (types[i]) {
                    case 12: {
                        ps.setString(i + 1, values[i].toString());
                        continue block12;
                    }
                    case 4: {
                        ps.setInt(i + 1, Integer.valueOf(values[i].toString()));
                        continue block12;
                    }
                    case -5: {
                        ps.setLong(i + 1, Long.valueOf(values[i].toString()));
                        continue block12;
                    }
                    case 6: {
                        ps.setFloat(i + 1, Float.valueOf(values[i].toString()).floatValue());
                        continue block12;
                    }
                    case 93: {
                        ps.setTimestamp(i + 1, Timestamp.valueOf(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.sss").format(values[i])));
                        continue block12;
                    }
                    case 3: 
                    case 8: {
                        ps.setDouble(i + 1, Double.valueOf(values[i].toString()));
                        continue block12;
                    }
                    case 2004: {
                        ps.setBytes(i + 1, (byte[])values[i]);
                        continue block12;
                    }
                    case 5: {
                        ps.setShort(i + 1, (Short)values[i]);
                        continue block12;
                    }
                    case 91: {
                        ps.setDate(i + 1, java.sql.Date.valueOf(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(values[i])));
                        continue block12;
                    }
                    default: {
                        ps.setObject(i + 1, values[i]);
                    }
                }
            }
        }
    }
}

