/*
 * Decompiled with CFR 0.152.
 */
package cn.dolphin.core.jdbc;

import cn.dolphin.core.date.DateFormatUtil;
import cn.dolphin.core.dialect.Dialect;
import cn.dolphin.core.dialect.util.DialectUtil;
import cn.dolphin.core.exception.DaoRuntimException;
import cn.dolphin.core.jdbc.annotation.Field;
import cn.dolphin.core.jdbc.enums.FieldType;
import cn.dolphin.core.jdbc.framework.FrameworkNamedParameterJdbcTemplate;
import cn.dolphin.core.jdbc.framework.PreparedStatementCreatorImpl;
import cn.dolphin.core.jdbc.model.SaveOrUpdateModel;
import cn.dolphin.core.jdbc.support.ColumnMap;
import cn.dolphin.core.jdbc.util.JdbcUtil;
import cn.dolphin.core.reflect.BeanField;
import cn.dolphin.core.reflect.ReflectUtil;
import cn.dolphin.core.util.ArrayUtil;
import cn.dolphin.core.util.CamelCaseUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.JSONObject;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.sql.CallableStatement;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.dao.IncorrectResultSizeDataAccessException;
import org.springframework.jdbc.core.BatchPreparedStatementSetter;
import org.springframework.jdbc.core.JdbcOperations;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.ResultSetExtractor;
import org.springframework.jdbc.core.RowCallbackHandler;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.RowMapperResultSetExtractor;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.support.GeneratedKeyHolder;
import org.springframework.jdbc.support.KeyHolder;

public class JdbcTemplatePlus
extends JdbcTemplate {
    protected static Logger log = LoggerFactory.getLogger(JdbcTemplatePlus.class);
    private String dbType;
    private NamedParameterJdbcTemplate namedParameterJdbcTemplate;

    public String getDbType() {
        return this.dbType;
    }

    public void setDbType(String dbType) {
        this.dbType = dbType;
    }

    public JdbcTemplatePlus(DataSource dataSource) {
        super(dataSource);
    }

    public JdbcTemplatePlus(DataSource dataSource, boolean lazyInit) {
        super(dataSource, lazyInit);
    }

    public DataSource getDataSource() {
        return super.getDataSource();
    }

    public NamedParameterJdbcTemplate getNamedParamJdbcTemplate() {
        if (null == this.namedParameterJdbcTemplate) {
            this.namedParameterJdbcTemplate = new FrameworkNamedParameterJdbcTemplate((JdbcOperations)this);
        }
        return this.namedParameterJdbcTemplate;
    }

    public <T> T queryForObject(String sql, Class<T> requiredType) throws DataAccessException {
        return this.queryForObject(sql, this.getSingleColumnRowMapper(requiredType));
    }

    public <T> T queryForObject(String sql, Object[] args, RowMapper<T> rowMapper) throws DataAccessException {
        List results = (List)this.query(sql, args, (ResultSetExtractor)new RowMapperResultSetExtractor(rowMapper, 1));
        return JdbcTemplatePlus.requiredSingleResult(results);
    }

    public <T> T queryForObject(String sql, RowMapper<T> rowMapper) throws DataAccessException {
        List results = this.query(sql, rowMapper);
        return JdbcTemplatePlus.requiredSingleResult(results);
    }

    public <T> T queryForObject(String sql, RowMapper<T> rowMapper, Object ... args) throws DataAccessException {
        List results = (List)this.query(sql, args, (ResultSetExtractor)new RowMapperResultSetExtractor(rowMapper, 1));
        return JdbcTemplatePlus.requiredSingleResult(results);
    }

    public Map<String, Object> queryForMap(String sql, Object ... args) throws DataAccessException {
        try {
            return super.queryForMap(sql, args);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static <T> T requiredSingleResult(Collection<T> results) throws IncorrectResultSizeDataAccessException {
        int size;
        int n = size = results != null ? results.size() : 0;
        if (size == 0) {
            return null;
        }
        if (results.size() > 1) {
            throw new IncorrectResultSizeDataAccessException(1, size);
        }
        return results.iterator().next();
    }

    protected RowMapper<Map<String, Object>> getOverrideColumnMapRowMapper() {
        return new ColumnMap();
    }

    public List<Map<String, Object>> queryForMapList(String sql) throws DataAccessException {
        return this.query(sql, this.getOverrideColumnMapRowMapper());
    }

    public int queryForInt(String wsql, Object[] values, int[] types) {
        String logstr = null;
        if (log.isDebugEnabled()) {
            logstr = "queryForInt: sql=" + wsql + "; parameters=" + JdbcTemplatePlus.arrayToString(values);
            log.debug(logstr);
        }
        Integer result = 0;
        try {
            result = values == null || values.length == 0 ? this.queryForObject(wsql, Integer.class) : (types == null || types.length == 0 ? (Integer)this.queryForObject(wsql, values, Integer.class) : (Integer)this.queryForObject(wsql, values, types, Integer.class));
        }
        catch (EmptyResultDataAccessException emptyResultDataAccessException) {
            // empty catch block
        }
        if (log.isInfoEnabled()) {
            if (logstr == null) {
                logstr = "queryForInt: sql=" + wsql + "; parameters=" + JdbcTemplatePlus.arrayToString(values);
            }
            log.info(logstr + "; result=" + result);
        }
        return result == null ? 0 : result;
    }

    public long queryForLong(String wsql, Object[] values, int[] types) {
        String logstr = null;
        if (log.isDebugEnabled()) {
            logstr = "queryForLong: sql=" + wsql + "; parameters=" + JdbcTemplatePlus.arrayToString(values);
            log.debug(logstr);
        }
        Long result = 0L;
        try {
            result = values == null || values.length == 0 ? this.queryForObject(wsql, Long.class) : (types == null || types.length == 0 ? (Long)this.queryForObject(wsql, values, Long.class) : (Long)this.queryForObject(wsql, values, types, Long.class));
        }
        catch (EmptyResultDataAccessException emptyResultDataAccessException) {
            // empty catch block
        }
        if (log.isInfoEnabled()) {
            if (logstr == null) {
                logstr = "queryForLong: sql=" + wsql + "; parameters=" + JdbcTemplatePlus.arrayToString(values);
            }
            log.info(logstr + "; result=" + result);
        }
        return result == null ? 0L : result;
    }

    public String queryForString(String wsql, Object[] values, int[] types) {
        String logstr = null;
        if (log.isDebugEnabled()) {
            logstr = "queryForString: sql=" + wsql + "; parameters=" + JdbcTemplatePlus.arrayToString(values);
            log.debug(logstr);
        }
        String rows = null;
        try {
            rows = values == null || values.length == 0 ? this.queryForObject(wsql, String.class) : (types == null || types.length == 0 ? (String)this.queryForObject(wsql, values, String.class) : (String)this.queryForObject(wsql, values, types, String.class));
        }
        catch (EmptyResultDataAccessException emptyResultDataAccessException) {
            // empty catch block
        }
        if (log.isInfoEnabled()) {
            if (logstr == null) {
                logstr = "queryForString: sql=" + wsql + "; parameters=" + JdbcTemplatePlus.arrayToString(values);
            }
            log.info(logstr + "; result=" + rows);
        }
        return rows;
    }

    public <T> T queryForObject(Class<T> clazz, String wsql, Object[] values, int[] types) {
        ResultSetExtractor rse = rs -> {
            if (rs.next()) {
                return JdbcTemplatePlus.convert2Object(rs, clazz);
            }
            return null;
        };
        if (wsql == null || (wsql = wsql.trim()).isEmpty()) {
            wsql = "SELECT * FROM " + JdbcUtil.getTableName(clazz);
            wsql = "oracle".equals(this.getDbType().toLowerCase()) ? wsql + " WHERE ROWNUM<=1" : wsql + " LIMIT 1";
        } else if (!wsql.startsWith("SELECT ") && !wsql.startsWith("select ")) {
            wsql = "SELECT * FROM " + JdbcUtil.getTableName(clazz) + " WHERE " + wsql;
        }
        String logstr = null;
        if (log.isDebugEnabled()) {
            logstr = "queryForObject: sql=" + wsql + "; parameters=" + JdbcTemplatePlus.arrayToString(values);
            log.debug(logstr);
        }
        Object t = null;
        t = values == null || values.length == 0 ? this.query(wsql, rse) : (types == null || types.length == 0 ? this.query(wsql, values, rse) : this.query(wsql, values, types, rse));
        if (log.isInfoEnabled()) {
            if (logstr == null) {
                logstr = "queryForObject: sql=" + wsql + "; parameters=" + JdbcTemplatePlus.arrayToString(values);
            }
            log.info(logstr + "; result=" + t);
        }
        return (T)t;
    }

    public Map<String, Object> queryForMap(String wsql, Object[] values, int[] types) {
        ResultSetExtractor rse = rs -> {
            if (!rs.next()) {
                return null;
            }
            ResultSetMetaData meta = rs.getMetaData();
            int colCount = meta.getColumnCount();
            ArrayList<Object[]> columns = new ArrayList<Object[]>();
            for (int i = 1; i <= colCount; ++i) {
                columns.add(new Object[]{meta.getColumnName(i), meta.getColumnType(i)});
            }
            return JdbcTemplatePlus.convert2Map(rs, columns);
        };
        String logstr = null;
        if (log.isDebugEnabled()) {
            logstr = "queryForMap: sql=" + wsql + "; parameters=" + JdbcTemplatePlus.arrayToString(values);
            log.debug(logstr);
        }
        Map map = null;
        map = values == null || values.length == 0 ? (Map)this.query(wsql, rse) : (types == null || types.length == 0 ? (Map)this.query(wsql, values, rse) : (Map)this.query(wsql, values, types, rse));
        if (log.isInfoEnabled()) {
            if (logstr == null) {
                logstr = "queryForMap: sql=" + wsql + "; parameters=" + JdbcTemplatePlus.arrayToString(values);
            }
            log.info(logstr + "; result=" + map);
        }
        return map;
    }

    public <T> List<T> queryForList(Class<T> clazz, String wsql, Object[] values, String orderBy) {
        ResultSetExtractorImpl<T> rse = new ResultSetExtractorImpl<T>(clazz);
        if (wsql == null || (wsql = wsql.trim()).isEmpty()) {
            wsql = "SELECT * FROM " + JdbcUtil.getTableName(clazz) + "";
        } else if (!wsql.startsWith("SELECT ") && !wsql.startsWith("select ")) {
            wsql = "SELECT * FROM " + JdbcUtil.getTableName(clazz) + " WHERE " + wsql;
        }
        if (orderBy != null && !orderBy.isEmpty()) {
            wsql = wsql + " ORDER BY " + orderBy;
        }
        String logstr = null;
        if (log.isDebugEnabled()) {
            logstr = "queryForList: sql=" + wsql + "; parameters=" + JdbcTemplatePlus.arrayToString(values);
            log.debug(logstr);
        }
        List list = null;
        list = values == null || values.length == 0 ? (List)this.query(wsql, rse) : (List)this.query(wsql, values, rse);
        if (log.isInfoEnabled()) {
            if (logstr == null) {
                logstr = "queryForList: sql=" + wsql + "; parameters=" + JdbcTemplatePlus.arrayToString(values);
            }
            log.info(logstr + "; size=" + (list == null ? 0 : list.size()));
        }
        return list;
    }

    public List<Map<String, Object>> queryForMapList(String sql, Object[] values, int[] types) {
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        ArrayList columns = new ArrayList();
        RowCallbackHandler hander = rs -> {
            if (columns.isEmpty()) {
                ResultSetMetaData meta = rs.getMetaData();
                int colCount = meta.getColumnCount();
                for (int i = 1; i <= colCount; ++i) {
                    columns.add(new Object[]{meta.getColumnName(i), meta.getColumnType(i)});
                }
            }
            list.add(JdbcTemplatePlus.convert2Map(rs, columns));
        };
        String logstr = null;
        if (log.isDebugEnabled()) {
            logstr = "queryForList<Map>: sql=" + sql + "; parameters=" + JdbcTemplatePlus.arrayToString(values);
            log.debug(logstr);
        }
        if (values == null || values.length == 0) {
            this.query(sql, hander);
        } else if (types == null || types.length == 0) {
            this.query(sql, values, hander);
        } else {
            this.query(sql, values, types, hander);
        }
        if (log.isInfoEnabled()) {
            if (logstr == null) {
                logstr = "queryForList<Map>: sql=" + sql + "; parameters=" + JdbcTemplatePlus.arrayToString(values);
            }
            log.info(logstr + "; size=" + (list == null ? 0 : list.size()));
        }
        return list;
    }

    public List<Integer> queryForIntegerList(String sql, Object[] values, boolean unique) {
        ArrayList<Integer> list = new ArrayList<Integer>();
        RowCallbackHandler hander = rs -> {
            int colCount;
            ResultSetMetaData meta = rs.getMetaData();
            if (meta != null && (colCount = meta.getColumnCount()) >= 1) {
                int i = rs.getInt(1);
                if (unique && list.contains(i)) {
                    return;
                }
                list.add(i);
            }
        };
        String logstr = null;
        if (log.isDebugEnabled()) {
            logstr = "queryForList<Integer>: sql=" + sql + "; parameters=" + JdbcTemplatePlus.arrayToString(values);
            log.debug(logstr);
        }
        if (values == null || values.length == 0) {
            this.query(sql, hander);
        } else {
            this.query(sql, values, hander);
        }
        if (log.isInfoEnabled()) {
            if (logstr == null) {
                logstr = "queryForList<Integer>: sql=" + sql + "; parameters=" + JdbcTemplatePlus.arrayToString(values);
            }
            log.info(logstr + "; size=" + (list == null ? 0 : list.size()));
        }
        return list;
    }

    public List<Long> queryForLongList(String sql, Object[] values, boolean unique) {
        ArrayList<Long> list = new ArrayList<Long>();
        RowCallbackHandler hander = rs -> {
            int colCount;
            ResultSetMetaData meta = rs.getMetaData();
            if (meta != null && (colCount = meta.getColumnCount()) >= 1) {
                long i = rs.getLong(1);
                if (unique && list.contains(i)) {
                    return;
                }
                list.add(i);
            }
            meta = null;
        };
        String logstr = null;
        if (log.isDebugEnabled()) {
            logstr = "queryForList<Long>: sql=" + sql + "; parameters=" + JdbcTemplatePlus.arrayToString(values);
            log.debug(logstr);
        }
        if (values == null || values.length == 0) {
            this.query(sql, hander);
        } else {
            this.query(sql, values, hander);
        }
        if (log.isInfoEnabled()) {
            if (logstr == null) {
                logstr = "queryForList<Long>: sql=" + sql + "; parameters=" + JdbcTemplatePlus.arrayToString(values);
            }
            log.info(logstr + "; size=" + (list == null ? 0 : list.size()));
        }
        return list;
    }

    public List<String> queryForStringList(String sql, Object[] values, boolean unique) {
        ArrayList<String> list = new ArrayList<String>();
        RowCallbackHandler hander = rs -> {
            int colCount;
            ResultSetMetaData meta = rs.getMetaData();
            if (meta != null && (colCount = meta.getColumnCount()) >= 1) {
                String i = rs.getString(1);
                if (unique && list.contains(i)) {
                    return;
                }
                list.add(i);
            }
            meta = null;
        };
        String logstr = null;
        if (log.isDebugEnabled()) {
            logstr = "queryForList<String>: sql=" + sql + "; parameters=" + JdbcTemplatePlus.arrayToString(values);
            log.debug(logstr);
        }
        if (values == null || values.length == 0) {
            this.query(sql, hander);
        } else {
            this.query(sql, values, hander);
        }
        if (log.isInfoEnabled()) {
            if (logstr == null) {
                logstr = "queryForList<String>: sql=" + sql + "; parameters=" + JdbcTemplatePlus.arrayToString(values);
            }
            log.info(logstr + "; size=" + (list == null ? 0 : list.size()));
        }
        return list;
    }

    public void execute(String callString) {
        if (log.isDebugEnabled()) {
            log.debug("execute: sql=" + callString);
        }
        this.execute(callString);
    }

    public void execute(String callString, Object[] args) {
        if (args == null || args.length == 0) {
            this.execute(callString);
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug("execute: sql=" + callString + "; parameters=" + JdbcTemplatePlus.arrayToString(args));
        }
        this.execute(connection -> {
            CallableStatement cs = connection.prepareCall(callString);
            int len = args.length;
            for (int i = 1; i <= len; ++i) {
                cs.setObject(i, args[i - 1]);
            }
            return cs;
        }, callableStatement -> {
            callableStatement.execute();
            return null;
        });
    }

    public String executeForString(String callString) {
        return this.executeForString(callString, null);
    }

    public String executeForString(String callString, Object[] args) {
        if (log.isDebugEnabled()) {
            log.debug("executeForString: sql=" + callString + "; parameters=" + JdbcTemplatePlus.arrayToString(args));
        }
        int len = args == null ? 0 : args.length;
        return (String)this.execute(connection -> {
            CallableStatement cs = connection.prepareCall(callString);
            for (int i = 1; i <= len; ++i) {
                cs.setObject(i, args[i - 1]);
            }
            cs.registerOutParameter(len + 1, 12);
            return cs;
        }, callableStatement -> {
            callableStatement.execute();
            return callableStatement.getString(len + 1);
        });
    }

    public int executeForInt(String callString) {
        return this.executeForInt(callString, null);
    }

    public int executeForInt(String callString, Object[] args) {
        if (log.isDebugEnabled()) {
            log.debug("executeForInt: sql=" + callString + "; parameters=" + JdbcTemplatePlus.arrayToString(args));
        }
        int len = args == null ? 0 : args.length;
        return (Integer)this.execute(connection -> {
            String storedProc = callString;
            CallableStatement cs = connection.prepareCall(storedProc);
            for (int i = 1; i <= len; ++i) {
                cs.setObject(i, args[i - 1]);
            }
            cs.registerOutParameter(len + 1, -5);
            return cs;
        }, callableStatement -> {
            callableStatement.execute();
            return callableStatement.getInt(len + 1);
        });
    }

    public List<Map<String, Object>> executeForList(String callString) {
        return this.executeForList(callString, null);
    }

    public List<Map<String, Object>> executeForList(String callString, Object[] args) {
        if (log.isDebugEnabled()) {
            log.debug("executeForList: sql=" + callString + "; parameters=" + JdbcTemplatePlus.arrayToString(args));
        }
        int len = args == null ? 0 : args.length;
        return (List)this.execute(connection -> {
            String storedProc = callString;
            CallableStatement cs = connection.prepareCall(storedProc);
            for (int i = 1; i <= len; ++i) {
                cs.setObject(i, args[i - 1]);
            }
            cs.registerOutParameter(len + 1, 2006);
            return cs;
        }, callableStatement -> {
            callableStatement.execute();
            ResultSet rs = callableStatement.getObject(len + 1, ResultSet.class);
            if (!rs.next()) {
                return null;
            }
            ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
            ResultSetMetaData meta = rs.getMetaData();
            int colCount = meta.getColumnCount();
            ArrayList<Object[]> columns = new ArrayList<Object[]>();
            for (int i = 1; i <= colCount; ++i) {
                columns.add(new Object[]{meta.getColumnName(i), meta.getColumnType(i)});
            }
            meta = null;
            do {
                list.add(JdbcTemplatePlus.convert2Map(rs, columns));
            } while (rs.next());
            rs.close();
            return list;
        });
    }

    public Map<String, Object> executeForMap(String callString) {
        return this.executeForMap(callString, null);
    }

    public Map<String, Object> executeForMap(String callString, Object[] args) {
        if (log.isDebugEnabled()) {
            log.debug("executeForMap: sql=" + callString + "; parameters=" + JdbcTemplatePlus.arrayToString(args));
        }
        int len = args == null ? 0 : args.length;
        return (Map)this.execute(connection -> {
            String storedProc = callString;
            CallableStatement cs = connection.prepareCall(storedProc);
            for (int i = 1; i <= len; ++i) {
                cs.setObject(i, args[i]);
            }
            cs.registerOutParameter(len + 1, 2006);
            return cs;
        }, callableStatement -> {
            callableStatement.execute();
            ResultSet rs = callableStatement.getObject(len + 1, ResultSet.class);
            if (!rs.next()) {
                return null;
            }
            ResultSetMetaData meta = rs.getMetaData();
            int colCount = meta.getColumnCount();
            ArrayList<Object[]> columns = new ArrayList<Object[]>();
            for (int i = 1; i <= colCount; ++i) {
                columns.add(new Object[]{meta.getColumnName(i), meta.getColumnType(i)});
            }
            meta = null;
            Map<String, Object> m = JdbcTemplatePlus.convert2Map(rs, columns);
            rs.close();
            return m;
        });
    }

    public <T> long save(String sql, Object[] values, int[] types, String pkName) {
        String logstr = null;
        if (log.isDebugEnabled()) {
            logstr = "save: sql=" + sql + "; parameters=" + JdbcTemplatePlus.arrayToString(values);
            log.debug(logstr);
        }
        if (pkName == null || pkName.isEmpty()) {
            int row = this.update(new PreparedStatementCreatorImpl(sql, values, types));
            if (log.isInfoEnabled()) {
                if (logstr == null) {
                    logstr = "save: sql=" + sql + "; parameters=" + JdbcTemplatePlus.arrayToString(values);
                }
                log.info(logstr + "; row=" + row);
            }
            return row;
        }
        GeneratedKeyHolder keyHolder = new GeneratedKeyHolder();
        this.update(new PreparedStatementCreatorImpl(sql, values, types, pkName), (KeyHolder)keyHolder);
        Number n = keyHolder.getKey();
        if (n == null) {
            return 0L;
        }
        long id = n.longValue();
        if (log.isInfoEnabled()) {
            if (logstr == null) {
                logstr = "save: sql=" + sql + "; parameters=" + JdbcTemplatePlus.arrayToString(values);
            }
            log.info(logstr + "; pk=" + id);
        }
        return id;
    }

    public long save(String sql, Object[] values, String pkName) {
        return this.save(sql, values, null, pkName);
    }

    public <T> boolean insert(String sql, Object[] values, int[] types) {
        String logstr = null;
        if (log.isDebugEnabled()) {
            logstr = "insert: sql=" + sql + "; parameters=" + JdbcTemplatePlus.arrayToString(values);
            log.debug(logstr);
        }
        int row = 0;
        row = types == null ? this.update(sql, values) : this.update(new PreparedStatementCreatorImpl(sql, values, types));
        if (log.isInfoEnabled()) {
            if (logstr == null) {
                logstr = "insert: sql=" + sql + "; parameters=" + JdbcTemplatePlus.arrayToString(values);
            }
            log.info(logstr + "; rows=" + row);
        }
        return row > 0;
    }

    public int update(String wsql, Object[] args, int[] types) {
        String logstr = null;
        if (log.isDebugEnabled()) {
            logstr = "update: sql=" + wsql + "; parameters=" + JdbcTemplatePlus.arrayToString(args);
            log.debug(logstr);
        }
        int rows = 0;
        rows = types == null ? this.update(wsql, args) : this.update(wsql, args, types);
        if (log.isInfoEnabled()) {
            if (logstr == null) {
                logstr = "update: sql=" + wsql + "; parameters=" + JdbcTemplatePlus.arrayToString(args);
            }
            log.info(logstr + "; rows=" + rows);
        }
        return rows;
    }

    public <T> boolean saveOrUpdate(T t) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException, SecurityException {
        String s;
        Dialect dialect = DialectUtil.getDialect(this);
        SaveOrUpdateModel model = JdbcUtil.buildSaveOrUpdateModel(t);
        boolean isNew = true;
        if (model.pkValue != null && !"".equals(model.pkValue + "") && !"0".equals(model.pkValue + "") && this.queryForObject(s = "SELECT COUNT(1) FROM " + model.table + " WHERE " + dialect.getMark() + model.pkName + dialect.getMark() + "=?", new Object[]{model.pkValue}, String.class) != null) {
            isNew = false;
        }
        if (!isNew) {
            StringBuilder sql_set = new StringBuilder();
            int size = model.columns.size();
            int[] types = new int[size];
            Object[] values = new Object[size];
            int j = 0;
            for (int i = 0; i < size; ++i) {
                String column = model.columns.get(i);
                if (column.equalsIgnoreCase(model.pkName)) {
                    values[size - 1] = model.values.get(i);
                    types[size - 1] = model.types.get(i);
                    continue;
                }
                Object val = model.values.get(i);
                if (String.valueOf(val).toUpperCase().endsWith(".NEXTVAL")) {
                    sql_set.append(",").append(dialect.getMark()).append(column).append(dialect.getMark()).append("=").append(val);
                    continue;
                }
                sql_set.append(",").append(dialect.getMark()).append(column).append(dialect.getMark()).append("=?");
                values[j] = val;
                types[j] = model.types.get(i);
                ++j;
            }
            if (j != size - 1) {
                values[j + 1] = values[size - 1];
                types[j + 1] = types[size - 1];
                values = ArrayUtil.subArray(values, j + 1);
                types = ArrayUtil.subArray(types, j + 1);
            }
            StringBuilder sql = new StringBuilder("UPDATE ");
            sql.append(" ").append(model.table);
            sql.append(" SET ").append(sql_set.substring(1));
            sql.append(" WHERE ").append(dialect.getMark()).append(model.pkName).append(dialect.getMark()).append("=?");
            return this.update(sql.toString(), values, types) >= 0;
        }
        StringBuilder sql_fields = new StringBuilder();
        StringBuilder sql_values = new StringBuilder();
        int size = model.columns.size();
        int[] types = new int[size];
        Object[] values = new Object[size];
        int j = 0;
        for (int i = 0; i < size; ++i) {
            sql_fields.append(",").append(dialect.getMark()).append(model.columns.get(i)).append(dialect.getMark());
            Object val = model.values.get(i);
            if (String.valueOf(val).endsWith(".NEXTVAL")) {
                sql_values.append(",").append(val);
                continue;
            }
            sql_values.append(",?");
            values[j] = val;
            types[j] = model.types.get(i);
            ++j;
        }
        if (j != size) {
            values = ArrayUtil.subArray(values, j);
            types = ArrayUtil.subArray(types, j);
        }
        StringBuilder sql = new StringBuilder("INSERT INTO");
        sql.append(" ").append(model.table);
        sql.append(" (").append(sql_fields.substring(1)).append(")");
        sql.append(" VALUES (").append(sql_values.substring(1)).append(")");
        return this.save(sql.toString(), values, types, model.pkName) > 0L;
    }

    public int batchUpdateNew(String sql, final List<Object[]> valueList, final int[] types) {
        BatchPreparedStatementSetter setter = new BatchPreparedStatementSetter(){

            public void setValues(PreparedStatement ps, int index) throws SQLException {
                Object[] values = (Object[])valueList.get(index);
                PreparedStatementCreatorImpl.setValues(ps, values, types);
            }

            public int getBatchSize() {
                return valueList.size();
            }
        };
        String logstr = null;
        if (log.isDebugEnabled()) {
            logstr = "batchUpdate: sql=" + sql + "; parameters=" + JdbcTemplatePlus.arrayListToString(valueList);
            log.debug(logstr);
        }
        int[] rows = null;
        rows = types == null ? this.batchUpdate(sql, valueList) : this.batchUpdate(sql, setter);
        int total = 0;
        for (int r : rows) {
            if (r == -2) {
                ++total;
                continue;
            }
            if (r <= 0) continue;
            total += r;
        }
        if (log.isInfoEnabled()) {
            if (logstr == null) {
                logstr = "batchUpdate: sql=" + sql + "; parameters=" + JdbcTemplatePlus.arrayListToString(valueList);
            }
            log.info(logstr + "; rows=" + total);
        }
        return total;
    }

    protected static String arrayToString(Object[] objs) {
        if (objs == null) {
            return "[]";
        }
        StringBuffer buf = new StringBuffer();
        buf.append("[");
        for (int j = 0; j < objs.length; ++j) {
            if (j > 0) {
                buf.append(", ");
            }
            buf.append(String.valueOf(objs[j]));
        }
        buf.append("]");
        return buf.toString();
    }

    protected static String arrayListToString(List<Object[]> list) {
        if (list == null || list.isEmpty()) {
            return "[]";
        }
        StringBuffer buf = new StringBuffer();
        for (Object[] obj : list) {
            buf.append(", ").append(JdbcTemplatePlus.arrayToString(obj));
        }
        return "[" + buf.substring(2) + "]";
    }

    private static final void invoke(ResultSet rs, Object object, Method method, Class fieldType, String columnName, Field annotation) throws SQLException {
        try {
            if (fieldType == String.class) {
                if (annotation != null && annotation.format() != null && !annotation.format().isEmpty()) {
                    method.invoke(object, DateFormatUtil.formatDate(rs.getString(columnName), annotation.format()));
                } else {
                    method.invoke(object, rs.getString(columnName));
                }
            } else if (fieldType == Integer.class || fieldType == Integer.TYPE) {
                method.invoke(object, rs.getInt(columnName));
            } else if (fieldType == Long.class || fieldType == Long.TYPE) {
                method.invoke(object, rs.getLong(columnName));
            } else if (fieldType == Float.class || fieldType == Float.TYPE) {
                if (annotation != null && annotation.scale() > 0) {
                    method.invoke(object, Float.valueOf(JdbcTemplatePlus.formatFloat(rs.getFloat(columnName), annotation.scale())));
                } else {
                    method.invoke(object, Float.valueOf(rs.getFloat(columnName)));
                }
            } else if (fieldType == Double.class || fieldType == Double.TYPE) {
                if (annotation != null && annotation.scale() > 0) {
                    method.invoke(object, JdbcTemplatePlus.formatDouble(rs.getDouble(columnName), annotation.scale()));
                } else {
                    method.invoke(object, rs.getDouble(columnName));
                }
            } else if (fieldType == java.util.Date.class || fieldType == Timestamp.class) {
                method.invoke(object, rs.getTimestamp(columnName));
            } else if (fieldType == Date.class) {
                method.invoke(object, rs.getDate(columnName));
            } else if (fieldType == byte[].class) {
                method.invoke(object, new Object[]{rs.getBytes(columnName)});
            } else if (fieldType == Short.class || fieldType == Short.TYPE) {
                method.invoke(object, rs.getShort(columnName));
            }
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            log.error("method=" + method.getName() + ", column=" + columnName + ", error=" + e.toString(), (Throwable)e);
        }
    }

    protected static double formatDouble(double d, int scale) {
        if (d == 0.0) {
            return d;
        }
        try {
            return new BigDecimal(d).setScale(scale, 4).doubleValue();
        }
        catch (Exception e) {
            e.getMessage();
            return d;
        }
    }

    protected static float formatFloat(float f, int scale) {
        if (f == 0.0f) {
            return f;
        }
        try {
            return new BigDecimal(f).setScale(scale, 4).floatValue();
        }
        catch (Exception e) {
            e.getMessage();
            return f;
        }
    }

    private static final String getColumnName(Field annotation, java.lang.reflect.Field field) {
        if (annotation == null) {
            return CamelCaseUtil.toUnderlineName(field.getName());
        }
        if (!annotation.isColumn()) {
            return null;
        }
        if (annotation.value() != null && !annotation.value().isEmpty()) {
            return annotation.value();
        }
        return CamelCaseUtil.toUnderlineName(field.getName());
    }

    protected static <T> T convert2Object(ResultSet rs, Class<T> clazz) throws SQLException, DataAccessException {
        ResultSetMetaData meta = rs.getMetaData();
        int colCount = meta.getColumnCount();
        ArrayList<String[]> columns = new ArrayList<String[]>();
        for (int i = 1; i <= colCount; ++i) {
            columns.add(new String[]{meta.getColumnName(i), meta.getColumnName(i)});
        }
        return (T)JdbcTemplatePlus.convert2Object(rs, clazz, columns);
    }

    private static Object convert2Object(ResultSet rs, Class<?> clazz, List<String[]> columns) throws SQLException, DataAccessException {
        Object object = null;
        List<BeanField> fields = ReflectUtil.getBeanFields(clazz);
        try {
            object = clazz.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            e.printStackTrace();
            return null;
        }
        Field annotation = null;
        for (BeanField field : fields) {
            Object val;
            String column;
            Method method = field.getSetterMethod();
            if (method == null || (column = JdbcTemplatePlus.getColumnName(annotation = field.getAnnotation(Field.class), field.field)) == null) continue;
            ArrayList<String[]> subColumns = null;
            for (int i = 0; i < columns.size(); ++i) {
                String subObjName;
                String[] columnName = columns.get(i);
                if (column.equalsIgnoreCase(columnName[1]) || field.getName().equalsIgnoreCase(columnName[1])) {
                    block13: {
                        Class<List> fieldType = method.getParameterTypes()[0];
                        if (annotation != null && annotation.isJson()) {
                            String json = rs.getString(columnName[0]);
                            try {
                                if (json == null || (json = json.trim()).isEmpty()) break block13;
                                if (fieldType.isAssignableFrom(List.class)) {
                                    Class genericClazz = ReflectUtil.getGenericType(field.field);
                                    method.invoke(object, JSONArray.parseArray((String)json, (Class)genericClazz));
                                    break block13;
                                }
                                method.invoke(object, JSONObject.parseObject((String)json, fieldType));
                            }
                            catch (JSONException | IllegalAccessException | InvocationTargetException e) {
                                log.error("field=" + field.getName() + ", method=" + method.getName() + ", column=" + columnName[0] + ", json=" + json + ", error=" + e.toString(), e);
                            }
                        } else {
                            JdbcTemplatePlus.invoke(rs, object, method, fieldType, columnName[0], annotation);
                        }
                    }
                    columns.remove(i);
                    break;
                }
                int ii = columnName[1].indexOf(".");
                if (ii <= 0 || !column.equalsIgnoreCase(subObjName = columnName[1].substring(0, ii)) && !field.getName().equalsIgnoreCase(subObjName)) continue;
                if (subColumns == null) {
                    subColumns = new ArrayList<String[]>();
                }
                subColumns.add(new String[]{columnName[0], columnName[1].substring(ii + 1)});
                columns.remove(i);
                --i;
            }
            if (subColumns == null || (val = JdbcTemplatePlus.convert2Object(rs, method.getParameterTypes()[0], subColumns)) == null) continue;
            try {
                method.invoke(object, val);
            }
            catch (Exception e) {
                throw new DaoRuntimException(e);
            }
        }
        return object;
    }

    protected static Object convert2Entity(ResultSet rs, Class<?> clazz, List<EntityField> fields) throws SQLException, DataAccessException {
        Object object = null;
        try {
            object = clazz.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            e.printStackTrace();
            return null;
        }
        String columnName = null;
        Object obj = null;
        for (EntityField entityfield : fields) {
            String json;
            Method method = entityfield.setter;
            Class<?> fieldType = method.getParameterTypes()[0];
            columnName = entityfield.columnName;
            if (entityfield.type == FieldType.ENTITY) {
                obj = JdbcTemplatePlus.convert2Entity(rs, fieldType, entityfield.entityFields);
                if (obj == null) continue;
                try {
                    method.invoke(object, obj);
                }
                catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                    log.error("method=" + method + ", fieldType=" + fieldType + ", error=" + e.toString(), (Throwable)e);
                }
                continue;
            }
            if (entityfield.type == FieldType.JSON_ARRAY) {
                json = rs.getString(entityfield.columnName);
                if (json == null || (json = json.trim()).isEmpty()) continue;
                try {
                    method.invoke(object, JSONArray.parseArray((String)json, entityfield.genericClazz));
                }
                catch (JSONException e) {
                    log.error("method=" + method + ", column=" + columnName + ", json=" + json + ", error=" + e.toString(), (Throwable)e);
                }
                catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                    log.error("method=" + method + ", column=" + columnName + ", error=" + e.toString(), (Throwable)e);
                }
                continue;
            }
            if (entityfield.type == FieldType.JSON_OBJECT) {
                json = rs.getString(entityfield.columnName);
                try {
                    method.invoke(object, JSONObject.parseObject((String)json, fieldType));
                }
                catch (JSONException e) {
                    log.error("method=" + method + ", column=" + columnName + ", json=" + json + ", error=" + e.toString(), (Throwable)e);
                }
                catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                    log.error("method=" + method + ", column=" + columnName + ", error=" + e.toString(), (Throwable)e);
                }
                continue;
            }
            JdbcTemplatePlus.invoke(rs, object, method, fieldType, columnName, entityfield.annotation);
        }
        return object;
    }

    protected static Map<String, Object> convert2Map(ResultSet rs, List<Object[]> columns) throws SQLException {
        HashMap<String, Object> m = new HashMap<String, Object>();
        for (Object[] col : columns) {
            Object fieldValue;
            String fieldName;
            block25: {
                fieldName = (String)col[0];
                int type = (Integer)col[1];
                fieldValue = null;
                if (type == 12) {
                    fieldValue = rs.getString(fieldName);
                } else if (type == 4) {
                    fieldValue = rs.getInt(fieldName);
                } else if (type == -5) {
                    fieldValue = rs.getLong(fieldName);
                } else if (type == 91) {
                    fieldValue = DateFormatUtil.format(rs.getTimestamp(fieldName));
                } else if (type == 2004) {
                    fieldValue = rs.getBytes(fieldName);
                } else if (type == 2005) {
                    fieldValue = rs.getString(fieldName);
                } else if (type == 93) {
                    Timestamp tt = rs.getTimestamp(fieldName);
                    if (tt != null) {
                        fieldValue = tt.getTime();
                    }
                } else if (type == 5) {
                    fieldValue = rs.getShort(fieldName);
                } else if (type == -1) {
                    String value = rs.getString(fieldName);
                    if (value != null && !value.isEmpty()) {
                        try {
                            if (value.matches("\\{.*\\}")) {
                                fieldValue = JSONObject.parseObject((String)value, Map.class);
                                break block25;
                            }
                            if (value.matches("\\[.*\\]")) {
                                fieldValue = JSONArray.parseArray((String)value, Map.class);
                                break block25;
                            }
                            fieldValue = value;
                        }
                        catch (Exception e) {
                            log.warn(e.getMessage(), (Throwable)e);
                            fieldValue = value;
                        }
                    }
                } else {
                    fieldValue = rs.getObject(fieldName);
                }
            }
            m.put(fieldName, fieldValue);
        }
        return m;
    }

    protected static List<EntityField> buildEntityModel(Class<?> clazz, List<String[]> columns) {
        List<BeanField> fields = ReflectUtil.getBeanFields(clazz);
        Field annotation = null;
        ArrayList<EntityField> entityFields = new ArrayList<EntityField>();
        for (BeanField field : fields) {
            List<EntityField> lst;
            String column;
            Method method = field.getSetterMethod();
            if (method == null || (column = JdbcTemplatePlus.getColumnName(annotation = field.getAnnotation(Field.class), field.field)) == null) continue;
            ArrayList<String[]> subColumns = null;
            for (int i = 0; i < columns.size(); ++i) {
                String subObjName;
                String[] columnName = columns.get(i);
                if (column.equalsIgnoreCase(columnName[1]) || field.getName().equalsIgnoreCase(columnName[1])) {
                    Class<List> fieldType = method.getParameterTypes()[0];
                    if (annotation != null && annotation.isJson()) {
                        if (fieldType.isAssignableFrom(List.class)) {
                            EntityField entityField = new EntityField(annotation, method, columnName[0], FieldType.JSON_ARRAY);
                            entityField.genericClazz = ReflectUtil.getGenericType(field.field);
                            entityFields.add(entityField);
                        } else {
                            entityFields.add(new EntityField(annotation, method, columnName[0], FieldType.JSON_OBJECT));
                        }
                    } else {
                        entityFields.add(new EntityField(annotation, method, columnName[0], FieldType.JAVA));
                    }
                    columns.remove(i);
                    break;
                }
                int ii = columnName[1].indexOf(".");
                if (ii <= 0 || !column.equalsIgnoreCase(subObjName = columnName[1].substring(0, ii)) && !field.getName().equalsIgnoreCase(subObjName)) continue;
                if (subColumns == null) {
                    subColumns = new ArrayList<String[]>();
                }
                subColumns.add(new String[]{columnName[0], columnName[1].substring(ii + 1)});
                columns.remove(i);
                --i;
            }
            if (subColumns == null || (lst = JdbcTemplatePlus.buildEntityModel(method.getParameterTypes()[0], subColumns)) == null) continue;
            entityFields.add(new EntityField(lst, method, FieldType.ENTITY));
        }
        if (entityFields.isEmpty()) {
            return null;
        }
        return entityFields;
    }

    protected static class EntityField {
        public Field annotation;
        public String columnName;
        public FieldType type;
        public Class<?> genericClazz;
        public List<EntityField> entityFields;
        public Method setter;

        public EntityField(Field annotation, Method setter, String columnName, FieldType type) {
            this.annotation = annotation;
            this.setter = setter;
            this.columnName = columnName;
            this.type = type;
        }

        public EntityField(List<EntityField> entityFields, Method setter, FieldType type) {
            this.entityFields = entityFields;
            this.setter = setter;
            this.type = type;
        }
    }

    protected static class ResultSetExtractorImpl<T>
    implements ResultSetExtractor<List<T>> {
        private Class<T> clazz;

        public ResultSetExtractorImpl(Class<T> clazz) {
            this.clazz = clazz;
        }

        public List<T> extractData(ResultSet rs) throws SQLException, DataAccessException {
            if (!rs.next()) {
                return null;
            }
            ResultSetMetaData meta = rs.getMetaData();
            int colCount = meta.getColumnCount();
            ArrayList<String[]> columns = new ArrayList<String[]>();
            for (int i = 1; i <= colCount; ++i) {
                columns.add(new String[]{meta.getColumnName(i), meta.getColumnName(i)});
            }
            List<EntityField> fields = JdbcTemplatePlus.buildEntityModel(this.clazz, columns);
            if (fields == null) {
                return null;
            }
            ArrayList<Object> list = new ArrayList<Object>();
            do {
                list.add(JdbcTemplatePlus.convert2Entity(rs, this.clazz, fields));
            } while (rs.next());
            return list;
        }
    }
}

