/*
 * Decompiled with CFR 0.152.
 */
package cn.dolphin.core.jdbc;

import cn.dolphin.core.dialect.Dialect;
import cn.dolphin.core.dialect.util.DialectUtil;
import cn.dolphin.core.exception.DaoRuntimException;
import cn.dolphin.core.jdbc.JdbcTemplatePlus;
import cn.dolphin.core.jdbc.RollbackJdbcTemplate;
import cn.dolphin.core.jdbc.enums.SqlMethod;
import cn.dolphin.core.jdbc.model.BatchModel;
import cn.dolphin.core.jdbc.model.SqlModel;
import cn.dolphin.core.jdbc.support.AbstractJdbcDao;
import cn.dolphin.core.jdbc.support.IRollBack;
import cn.dolphin.core.jdbc.util.FrameworkDataAccessUtil;
import cn.dolphin.core.jdbc.util.JdbcUtil;
import cn.dolphin.core.jdbc.util.QueryAndNamedParams;
import cn.dolphin.core.jdbc.util.QueryAndParams;
import cn.dolphin.core.page.PageBean;
import cn.dolphin.core.page.PageList;
import cn.dolphin.core.spring.SpringContextUtil;
import cn.dolphin.core.util.CamelCaseUtil;
import cn.dolphin.core.util.CollectionUtil;
import com.alibaba.fastjson.JSONObject;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.ResultSetExtractor;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.RowMapperResultSetExtractor;
import org.springframework.jdbc.core.SingleColumnRowMapper;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.jdbc.core.namedparam.SqlParameterSourceUtils;
import org.springframework.jdbc.support.JdbcUtils;
import org.springframework.stereotype.Component;

@Component
public abstract class JdbcDao<T, ID extends Serializable>
extends AbstractJdbcDao<T, ID> {
    public JdbcDao() {
        try {
            Type type = ((Object)((Object)this)).getClass().getGenericSuperclass();
            this.entityClass = type instanceof ParameterizedType ? (Class)((ParameterizedType)type).getActualTypeArguments()[0] : (Class)type;
            this.tableName = JdbcUtil.getTableName(this.entityClass);
            this.primaryKey = JdbcUtil.getPk(this.entityClass);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public long saveJdbc(T object) throws Exception {
        SqlModel sqlModel;
        try {
            sqlModel = JdbcUtil.buildSaveModel(object, DialectUtil.getDialect(this.getJdbcTemplate().getDbType()).getMark());
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new DaoRuntimException(e);
        }
        return this.getJdbcTemplate().save(sqlModel.sql, sqlModel.values, sqlModel.types, sqlModel.pk);
    }

    public int batchSaveJdbc(List<T> list) throws Exception {
        BatchModel model;
        try {
            model = JdbcUtil.buildBatchSaveModel(list, DialectUtil.getDialect(this.getJdbcTemplate().getDbType()).getMark());
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new DaoRuntimException(e);
        }
        return this.getJdbcTemplate().batchUpdateNew(model.sql, model.valueList, model.types);
    }

    public boolean saveOrUpdateJdbc(T object) throws Exception {
        try {
            return this.getJdbcTemplate().saveOrUpdate(object);
        }
        catch (IllegalAccessException | IllegalArgumentException | SecurityException | InvocationTargetException e) {
            throw new DaoRuntimException(e);
        }
    }

    public int updateJdbc(T object) throws Exception {
        return this.updateJdbc(object, null, false);
    }

    public int updateJdbc(String wsql) throws Exception {
        return this.updateJdbc(wsql, (Object[])null);
    }

    public int updateJdbc(String sql, Object mapORpojo) throws Exception {
        int i = this.getJdbcTemplate().getNamedParamJdbcTemplate().update(sql, this.transToSource(mapORpojo));
        return i;
    }

    public int updateJdbc(String wsql, Object[] args) throws Exception {
        if (!wsql.matches("^ *(?i)(INSERT|MERGE|DELETE|UPDATE) .*")) {
            wsql = "UPDATE " + this.tableName + " SET " + wsql;
        }
        return this.getJdbcTemplate().update(wsql, args, null);
    }

    public int updateJdbc(T object, String[] columns) throws Exception {
        return this.updateJdbc(object, columns, false);
    }

    public int updateJdbc(T object, String[] columns, boolean ignore) throws Exception {
        SqlModel sqlModel;
        try {
            sqlModel = JdbcUtil.buildUpdateModel(object, columns, ignore, DialectUtil.getDialect(this.getJdbcTemplate().getDbType()).getMark());
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new DaoRuntimException(e);
        }
        return this.getJdbcTemplate().update(sqlModel.sql, sqlModel.values, sqlModel.types);
    }

    public int batchUpdateJdbc(List<T> list) throws Exception {
        return this.batchUpdateJdbc(list, null);
    }

    public int batchUpdateJdbc(List<T> list, String[] columns) throws Exception {
        BatchModel model;
        try {
            model = JdbcUtil.buildBatchUpdateModel(list, columns, false, DialectUtil.getDialect(this.getJdbcTemplate().getDbType()).getMark());
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new DaoRuntimException(e);
        }
        return this.getJdbcTemplate().batchUpdateNew(model.sql, model.valueList, model.types);
    }

    public <ID extends Serializable> int deleteByIdJdbc(ID id) throws Exception {
        String deleteByIdSql = String.format(SqlMethod.DELETE_BY_ID.getSql(), this.tableName, this.primaryKey, CamelCaseUtil.toCamelCase(this.primaryKey));
        Map<String, ID> paramMap = Collections.singletonMap(CamelCaseUtil.toCamelCase(this.primaryKey), id);
        return this.getJdbcTemplate().getNamedParamJdbcTemplate().update(deleteByIdSql, paramMap);
    }

    public int deleteJdbc(String wsql) throws Exception {
        return this.deleteJdbc(wsql, null);
    }

    public int deleteJdbc(String sql, Object mapORpojo) {
        int i = this.getJdbcTemplate().getNamedParamJdbcTemplate().update(sql, this.transToSource(mapORpojo));
        return i;
    }

    public int deleteJdbc(String wsql, Object[] whereArgs) throws Exception {
        if (wsql == null || (wsql = wsql.trim()).isEmpty()) {
            wsql = "DELETE FROM " + this.tableName;
        } else if (!wsql.matches("^ *(?i)DELETE .*")) {
            wsql = "DELETE FROM " + this.tableName + " WHERE " + wsql;
        }
        String logstr = null;
        if (log.isDebugEnabled()) {
            StringBuilder stringBuilder = new StringBuilder().append("delete: sql=").append(wsql).append("; parameters=");
            this.getJdbcTemplate();
            logstr = stringBuilder.append(JdbcTemplatePlus.arrayToString(whereArgs)).toString();
            log.debug(logstr);
        }
        int rows = 0;
        rows = whereArgs != null && whereArgs.length > 0 ? this.getJdbcTemplate().update(wsql, whereArgs) : this.getJdbcTemplate().update(wsql);
        if (log.isInfoEnabled()) {
            if (logstr == null) {
                StringBuilder stringBuilder = new StringBuilder().append("delete: sql=").append(wsql).append("; parameters=");
                this.getJdbcTemplate();
                logstr = stringBuilder.append(JdbcTemplatePlus.arrayToString(whereArgs)).toString();
            }
            log.info(logstr + "; rows=" + rows);
        }
        return rows;
    }

    public <T> void batchExecuteJdbc(String sql, Collection<T> parameter) throws Exception {
        if (parameter == null) {
            throw new RuntimeException("parameter can not be null.");
        }
        this.getJdbcTemplate().getNamedParamJdbcTemplate().batchUpdate(sql, SqlParameterSourceUtils.createBatch((Object[])parameter.toArray()));
    }

    public <ID extends Serializable> T queryForByIdJdbc(ID id) throws Exception {
        String sql = "SELECT * FROM " + this.tableName + " WHERE " + this.primaryKey + "=?";
        BeanPropertyRowMapper rowMapper = BeanPropertyRowMapper.newInstance((Class)this.entityClass);
        List list = this.getJdbcTemplate().query(sql, (RowMapper)rowMapper, new Object[]{id});
        return CollectionUtil.isEmpty(list) ? null : (T)list.get(0);
    }

    public Object queryForObjectJdbc(String sql, Object[] objects, Class bean) throws Exception {
        List list = null;
        try {
            list = this.getJdbcTemplate().query(sql, objects, (RowMapper)new BeanPropertyRowMapper(bean));
        }
        catch (Exception e) {
            list = new ArrayList();
        }
        return list.get(0);
    }

    public <T> T queryForObjectJdbc(String sql, RowMapper<T> rowMapper) throws Exception {
        List results = this.getJdbcTemplate().query(sql, rowMapper);
        return FrameworkDataAccessUtil.requiredSingleResult(results);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T queryForObjectJdbc(String sql, Object mapORpojo, Class<T> beanClazz) {
        Object object;
        if (this.isBaseType(beanClazz).booleanValue()) {
            throw new RuntimeException("beanClazz\u662f\u4e00\u4e2a\u57fa\u7840\u7c7b\u578b\uff01");
        }
        SqlParameterSource source = this.transToSource(mapORpojo);
        try {
            Object t;
            object = t = this.getJdbcTemplate().getNamedParamJdbcTemplate().queryForObject(sql, source, (RowMapper)new BeanPropertyRowMapper(beanClazz));
        }
        catch (EmptyResultDataAccessException e) {
            T t = null;
            return t;
        }
        return (T)object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T queryForSingleValueJdbc(String sql, Object mapORpojo, Class<T> baseClazz) {
        Object object;
        if (!this.isBaseType(baseClazz).booleanValue()) {
            throw new RuntimeException("baseClazz\u4e0d\u662f\u4e00\u4e2a\u57fa\u7840\u7c7b\u578b\uff01");
        }
        SqlParameterSource source = this.transToSource(mapORpojo);
        try {
            Object t;
            object = t = this.getJdbcTemplate().getNamedParamJdbcTemplate().queryForObject(sql, source, baseClazz);
        }
        catch (EmptyResultDataAccessException e) {
            T t = null;
            return t;
        }
        return (T)object;
    }

    public JSONObject queryForJSONJdbc(String sql, Object[] args) {
        try {
            return this.getJdbcTemplate().queryForObject(sql, args, new RowMapper<JSONObject>(){

                public JSONObject mapRow(ResultSet rs, int columnIndex) throws SQLException {
                    JSONObject jsonObject = new JSONObject();
                    ResultSetMetaData rsmd = rs.getMetaData();
                    int columnCount = rsmd.getColumnCount();
                    for (int index = 1; index <= columnCount; ++index) {
                        String column = JdbcUtils.lookupColumnName((ResultSetMetaData)rsmd, (int)index);
                        jsonObject.put(column, (Object)rs.getString(index));
                    }
                    return jsonObject;
                }
            });
        }
        catch (EmptyResultDataAccessException e) {
            return null;
        }
    }

    public <T> T queryForObjectJdbc(String sql, Object[] args, int[] argTypes, RowMapper<T> rowMapper) throws Exception {
        List results = (List)this.getJdbcTemplate().query(sql, args, argTypes, (ResultSetExtractor)new RowMapperResultSetExtractor(rowMapper, 1));
        return FrameworkDataAccessUtil.requiredSingleResult(results);
    }

    public <T> T queryForObjectJdbc(String sql, Object[] args, RowMapper<T> rowMapper) throws Exception {
        List results = (List)this.getJdbcTemplate().query(sql, args, (ResultSetExtractor)new RowMapperResultSetExtractor(rowMapper, 1));
        return FrameworkDataAccessUtil.requiredSingleResult(results);
    }

    public <T> T queryForObjectJdbc(String sql, RowMapper<T> rowMapper, Object ... args) throws Exception {
        List results = (List)this.getJdbcTemplate().query(sql, args, (ResultSetExtractor)new RowMapperResultSetExtractor(rowMapper, 1));
        return FrameworkDataAccessUtil.requiredSingleResult(results);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Object> queryForMapJdbc(String sql, Object mapORpojo) {
        SqlParameterSource source = this.transToSource(mapORpojo);
        try {
            Map map;
            Map map2 = map = this.getJdbcTemplate().getNamedParamJdbcTemplate().queryForMap(sql, source);
            return map2;
        }
        catch (EmptyResultDataAccessException e) {
            Map<String, Object> map = null;
            return map;
        }
    }

    public List queryForListJdbc(String sql, Map parameter, RowMapper rowMap) {
        return this.getJdbcTemplate().getNamedParamJdbcTemplate().query(sql, parameter, rowMap);
    }

    public List queryForListJdbc(String sql, Map parameter) {
        return this.getJdbcTemplate().getNamedParamJdbcTemplate().queryForList(sql, parameter);
    }

    public List<JSONObject> queryForListJSONJdbc(String sql, Object[] args) {
        try {
            return this.getJdbcTemplate().query(sql, args, (RowMapper)new RowMapper<JSONObject>(){

                public JSONObject mapRow(ResultSet rs, int columnIndex) throws SQLException {
                    JSONObject jsonObject = new JSONObject();
                    ResultSetMetaData rsmd = rs.getMetaData();
                    int columnCount = rsmd.getColumnCount();
                    for (int index = 1; index <= columnCount; ++index) {
                        String column = JdbcUtils.lookupColumnName((ResultSetMetaData)rsmd, (int)index);
                        jsonObject.put(column, (Object)rs.getString(index));
                    }
                    return jsonObject;
                }
            });
        }
        catch (EmptyResultDataAccessException e) {
            return null;
        }
    }

    public <T> List<T> queryForBeanListJdbc(String sql, Object mapORpojo, Class<T> beanClazz) {
        if (this.isBaseType(beanClazz).booleanValue()) {
            throw new RuntimeException("beanClazz\u662f\u4e00\u4e2a\u57fa\u7840\u7c7b\u578b\uff01");
        }
        SqlParameterSource source = this.transToSource(mapORpojo);
        List list = this.getJdbcTemplate().getNamedParamJdbcTemplate().query(sql, source, (RowMapper)new BeanPropertyRowMapper(beanClazz));
        return list;
    }

    public <T> List<T> queryForSingleValueListJdbc(String sql, Object mapORpojo, Class<T> baseClazz) {
        if (!this.isBaseType(baseClazz).booleanValue()) {
            throw new RuntimeException("baseClazz\u4e0d\u662f\u4e00\u4e2a\u57fa\u7840\u7c7b\u578b\uff01");
        }
        SqlParameterSource source = this.transToSource(mapORpojo);
        List list = this.getJdbcTemplate().getNamedParamJdbcTemplate().query(sql, source, (RowMapper)new SingleColumnRowMapper(baseClazz));
        return list;
    }

    public List<Map<String, Object>> queryForMapListJdbc(String sql, Object mapORpojo) {
        SqlParameterSource source = this.transToSource(mapORpojo);
        List list = this.getJdbcTemplate().getNamedParamJdbcTemplate().queryForList(sql, source);
        return list;
    }

    public Integer queryForIntJdbc(String sql, Object mapORpojo) {
        SqlParameterSource source = this.transToSource(mapORpojo);
        Integer i = (Integer)this.getJdbcTemplate().getNamedParamJdbcTemplate().queryForObject(sql, source, Integer.class);
        return i;
    }

    public PageList queryPageJdbc(PageBean pageBean, String sql, RowMapper rowMap) {
        int pageSize = pageBean.getPageSize();
        int offset = pageBean.getFirst();
        HashMap map = new HashMap();
        Dialect dialect = null;
        try {
            dialect = DialectUtil.getDialect(this.getJdbcTemplate().getDbType());
        }
        catch (Exception e) {
            return null;
        }
        String pageSql = dialect.getLimitString(sql, offset, pageSize);
        String totalSql = dialect.getCountSql(sql, this.primaryKey);
        List list = this.getJdbcTemplate().getNamedParamJdbcTemplate().query(pageSql, map, rowMap);
        int total = (Integer)this.getJdbcTemplate().getNamedParamJdbcTemplate().queryForObject(totalSql, map, Integer.class);
        pageBean.setTotalCount(total);
        PageList pageList = new PageList();
        pageList.setPageBean(pageBean);
        pageList.addAll(list);
        return pageList;
    }

    public <T> T queryPageJdbc(PageBean pageBean, String sql, ResultSetExtractor<T> rse, Map<String, Object> params) {
        Object result = null;
        if (pageBean != null) {
            int pageSize = pageBean.getPageSize();
            int offset = pageBean.getFirst();
            Dialect dialect = null;
            try {
                dialect = DialectUtil.getDialect(this.getJdbcTemplate().getDbType());
            }
            catch (Exception e) {
                return null;
            }
            String pageSql = dialect.getLimitString(sql, offset, pageSize);
            String totalSql = dialect.getCountSql(sql, this.primaryKey);
            result = this.getJdbcTemplate().getNamedParamJdbcTemplate().query(pageSql, params, rse);
            int total = (Integer)this.getJdbcTemplate().getNamedParamJdbcTemplate().queryForObject(totalSql, params, Integer.class);
            pageBean.setTotalCount(total);
        } else {
            result = this.getJdbcTemplate().getNamedParamJdbcTemplate().query(sql, params, rse);
        }
        return (T)result;
    }

    public PageList queryPageJdbc(int currentPage, int pageSize, String sql, Map paraMap) {
        int offset = (currentPage - 1) * pageSize;
        Dialect dialect = null;
        try {
            dialect = DialectUtil.getDialect(this.getJdbcTemplate().getDbType());
        }
        catch (Exception e) {
            return null;
        }
        String pageSql = dialect.getLimitString(sql, offset, pageSize);
        String totalSql = dialect.getCountSql(sql, this.primaryKey);
        List list = this.getJdbcTemplate().getNamedParamJdbcTemplate().queryForList(pageSql, paraMap);
        int total = (Integer)this.getJdbcTemplate().getNamedParamJdbcTemplate().queryForObject(totalSql, paraMap, Integer.class);
        PageBean pageBean = new PageBean(currentPage, pageSize);
        pageBean.setTotalCount(total);
        PageList pageList = new PageList();
        pageList.addAll(list);
        pageList.setPageBean(pageBean);
        return pageList;
    }

    public List queryPageJdbc(PageBean pageBean, String sql, Map<?, ?> paraMap) {
        int currentPage = pageBean.getCurrentPage();
        int pageSize = pageBean.getPageSize();
        return this.queryPageJdbc(currentPage, pageSize, sql, paraMap);
    }

    public int executeJdbc(String sql, Object ... args) throws Exception {
        return this.getJdbcTemplate().update(sql, args);
    }

    public int executeJdbc(String sql, Map<String, Object> params) throws Exception {
        QueryAndParams qap = QueryAndParams.createFromQueryAndNamedParams(new QueryAndNamedParams(sql, params));
        return this.executeJdbc(qap.getQuery(), qap.getParams());
    }

    public Boolean executeJdbc(String sql, boolean rollback) {
        RollbackJdbcTemplate rollbackJdbcTemplate = (RollbackJdbcTemplate)SpringContextUtil.getBean("rollbackJdbcTemplate");
        if (!rollback) {
            this.getJdbcTemplate().execute(sql);
            return true;
        }
        HashMap<String, Object> param = new HashMap<String, Object>();
        Boolean b = (Boolean)rollbackJdbcTemplate.executeRollBack(new IRollBack(){

            @Override
            public Object execute(String script, Map<String, Object> map) {
                try {
                    JdbcDao.this.getJdbcTemplate().execute(script);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return false;
                }
                return true;
            }
        }, sql, param);
        return b;
    }

    public void executeBatchJdbc(String sql, Collection<Map<String, Object>> parameter) {
        if (parameter == null) {
            throw new RuntimeException("parameter can not be null.");
        }
        Map[] paramArray = new Map[parameter.size()];
        int index = 0;
        for (Map<String, Object> paramMap : parameter) {
            paramArray[index++] = paramMap;
        }
        this.getJdbcTemplate().getNamedParamJdbcTemplate().batchUpdate(sql, paramArray);
    }

    public boolean existsJdbc(String wsql) throws Exception {
        return this.existsJdbc(wsql, null);
    }

    public boolean existsJdbc(String wsql, Object[] values) throws Exception {
        if (wsql == null || (wsql = wsql.trim()).isEmpty()) {
            wsql = "SELECT COUNT(1) FROM " + this.tableName + "";
        } else if (!wsql.matches("^ *(?i)SELECT .*")) {
            wsql = "SELECT COUNT(1) FROM " + this.tableName + " WHERE " + wsql;
        }
        boolean flag = false;
        try {
            Integer r = (Integer)this.getJdbcTemplate().queryForObject(wsql, values, Integer.class);
            if (r != null && r > 0) {
                flag = true;
            }
        }
        catch (EmptyResultDataAccessException emptyResultDataAccessException) {
            // empty catch block
        }
        if (log.isInfoEnabled()) {
            StringBuilder stringBuilder = new StringBuilder().append("exists: sql=").append(wsql).append("; parameters=");
            this.getJdbcTemplate();
            log.info(stringBuilder.append(JdbcTemplatePlus.arrayToString(values)).append("; result=").append(flag).toString());
        }
        return flag;
    }
}

