/*
 * Decompiled with CFR 0.152.
 */
package cn.dolphin.core.ip;

import cn.dolphin.core.util.ExceptionUtil;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Enumeration;
import javax.servlet.http.HttpServletRequest;

public class IPUtil {
    private static final String UNKNOWN = "unknown";
    private static final String LOCAL = "127.0.0.1";
    private static final String[] HEADERS = new String[]{"X-Forwarded-For", "Proxy-Client-IP", "WL-Proxy-Client-IP", "HTTP_X_FORWARDED_FOR", "HTTP_X_FORWARDED", "HTTP_X_CLUSTER_CLIENT_IP", "HTTP_CLIENT_IP", "HTTP_FORWARDED_FOR", "HTTP_FORWARDED", "HTTP_VIA", "REMOTE_ADDR", "X-Real-IP"};

    public static boolean isEmptyIp(String ip) {
        return ip == null || ip.length() == 0 || ip.trim().equals("") || UNKNOWN.equalsIgnoreCase(ip);
    }

    public static boolean isNotEmptyIp(String ip) {
        return !IPUtil.isEmptyIp(ip);
    }

    public static String getIpAddress(HttpServletRequest request) {
        String header;
        if (request == null) {
            return UNKNOWN;
        }
        String ip = "";
        String[] stringArray = HEADERS;
        int n = stringArray.length;
        for (int i = 0; i < n && !IPUtil.isNotEmptyIp(ip = request.getHeader(header = stringArray[i])); ++i) {
        }
        if (IPUtil.isEmptyIp(ip)) {
            ip = request.getRemoteAddr();
        }
        if (IPUtil.isNotEmptyIp(ip) && ip.contains(",")) {
            ip = ip.split(",")[0];
        }
        if ("0:0:0:0:0:0:0:1".equals(ip)) {
            ip = LOCAL;
        }
        return ip;
    }

    public String getLocalHostIP() throws Exception {
        Enumeration<NetworkInterface> allNetInterfaces = NetworkInterface.getNetworkInterfaces();
        String localHostAddress = "";
        while (allNetInterfaces.hasMoreElements()) {
            NetworkInterface networkInterface = allNetInterfaces.nextElement();
            Enumeration<InetAddress> address = networkInterface.getInetAddresses();
            while (address.hasMoreElements()) {
                InetAddress inetAddress = address.nextElement();
                if (inetAddress == null || !(inetAddress instanceof Inet4Address)) continue;
                localHostAddress = inetAddress.getHostAddress();
            }
        }
        return localHostAddress;
    }

    @Deprecated
    public static String local() {
        try {
            InetAddress addr = InetAddress.getLocalHost();
            return addr.getHostAddress();
        }
        catch (UnknownHostException e) {
            ExceptionUtil.printStackTrace(e);
            return LOCAL;
        }
    }

    public static String getRealIp() {
        try {
            String localip = null;
            String netip = null;
            Enumeration<NetworkInterface> netInterfaces = NetworkInterface.getNetworkInterfaces();
            InetAddress ip = null;
            boolean finded = false;
            block2: while (netInterfaces.hasMoreElements() && !finded) {
                NetworkInterface ni = netInterfaces.nextElement();
                Enumeration<InetAddress> address = ni.getInetAddresses();
                while (address.hasMoreElements()) {
                    ip = address.nextElement();
                    if (!ip.isSiteLocalAddress() && !ip.isLoopbackAddress() && ip.getHostAddress().indexOf(":") == -1) {
                        netip = ip.getHostAddress();
                        finded = true;
                        continue block2;
                    }
                    if (!ip.isSiteLocalAddress() || ip.isLoopbackAddress() || ip.getHostAddress().indexOf(":") != -1) continue;
                    localip = ip.getHostAddress();
                }
            }
            if (netip != null && !"".equals(netip)) {
                return netip;
            }
            return localip;
        }
        catch (SocketException e) {
            ExceptionUtil.printStackTrace(e);
            return LOCAL;
        }
    }

    public static void main(String[] args) {
        System.out.println(IPUtil.getRealIp());
    }

    private IPUtil() {
    }
}

