/*
 * Decompiled with CFR 0.152.
 */
package cn.dolphin.core.io;

import cn.dolphin.core.check.CheckAssert;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.URLConnection;
import java.nio.charset.Charset;
import org.springframework.util.StreamUtils;

public class IOUtil
extends StreamUtils {
    private static final int DEFAULT_BUFFER_SIZE = 4096;
    public static final int EOF = -1;

    public static String toString(InputStream in) throws IOException {
        return IOUtil.toString(in, Charset.defaultCharset().name());
    }

    public static String toString(InputStream in, String encoding) throws IOException {
        return IOUtil.toString(in, encoding, true);
    }

    public static String toString(InputStream in, boolean isClosed) throws IOException {
        return IOUtil.toString(in, Charset.defaultCharset().name(), isClosed);
    }

    public static String toString(InputStream in, String encoding, boolean isClosed) throws IOException {
        return ((ByteArrayOutputStream)IOUtil.toOutputStream(in, isClosed)).toString(encoding);
    }

    public static byte[] toByteArray(InputStream input) throws IOException {
        return IOUtil.toByteArray(input, true);
    }

    public static OutputStream toOutputStream(InputStream input) throws IOException {
        return IOUtil.toOutputStream(input, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static OutputStream toOutputStream(InputStream input, boolean isClosed) throws IOException {
        try {
            int length;
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            byte[] buffer = new byte[1024];
            while ((length = input.read(buffer)) != -1) {
                baos.write(buffer, 0, length);
            }
            baos.flush();
            ByteArrayOutputStream byteArrayOutputStream = baos;
            return byteArrayOutputStream;
        }
        finally {
            if (isClosed) {
                IOUtil.close(input);
            }
        }
    }

    public static byte[] toByteArray(InputStream input, boolean isClosed) throws IOException {
        return ((ByteArrayOutputStream)IOUtil.toOutputStream(input, isClosed)).toByteArray();
    }

    public static int copy(InputStream input, OutputStream output) throws IOException {
        long count = IOUtil.copyLarge(input, output);
        if (count > Integer.MAX_VALUE) {
            return -1;
        }
        return (int)count;
    }

    public static long copyLarge(InputStream input, OutputStream output) throws IOException {
        return IOUtil.copy(input, output, 4096);
    }

    public static long copy(InputStream input, OutputStream output, int bufferSize) throws IOException {
        return IOUtil.copyLarge(input, output, new byte[bufferSize]);
    }

    public static long copyLarge(InputStream input, OutputStream output, byte[] buffer) throws IOException {
        int n;
        long count = 0L;
        while (-1 != (n = input.read(buffer))) {
            output.write(buffer, 0, n);
            count += (long)n;
        }
        return count;
    }

    public static void close(URLConnection conn) {
        if (conn instanceof HttpURLConnection) {
            ((HttpURLConnection)conn).disconnect();
        }
    }

    public static void close(Reader input) {
        IOUtil.close((Closeable)input);
    }

    public static void close(Writer output) {
        IOUtil.close((Closeable)output);
    }

    public static void close(InputStream input) {
        IOUtil.close((Closeable)input);
    }

    public static void close(OutputStream output) {
        IOUtil.close((Closeable)output);
    }

    public static void close(Closeable closeable) {
        try {
            if (closeable != null) {
                closeable.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void close(Closeable ... closeables) {
        if (closeables == null) {
            return;
        }
        for (Closeable closeable : closeables) {
            IOUtil.close(closeable);
        }
    }

    public static void write(String data, OutputStream output, Charset encoding) throws IOException {
        CheckAssert.check(data, (Object)"data is null");
        IOUtil.write(data.getBytes(encoding), output);
    }

    public static void write(String data, OutputStream output) throws IOException {
        IOUtil.write(data, output, Charset.defaultCharset());
    }

    public static void write(byte[] data, OutputStream output) throws IOException {
        CheckAssert.check(output, (Object)"outstream is null");
        CheckAssert.check(data, (Object)"data is null");
        output.write(data);
    }
}

