/*
 * Decompiled with CFR 0.152.
 */
package cn.dolphin.core.image;

import cn.dolphin.core.util.StrUtil;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.font.FontRenderContext;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;

public class ImageWatermarkUtil {
    public static void pressImage(String targetImg, String waterImg, int x, int y, float alpha, Integer degree, String suffix) {
        ImageWatermarkUtil.pressImage(targetImg, waterImg, null, x, y, alpha, null, suffix);
    }

    public static void pressImage(String targetImg, String waterImg, String outImg, int x, int y, float alpha, Integer degree, String suffix) {
        try {
            File file = new File(targetImg);
            File outFile = StrUtil.isEmpty((CharSequence)outImg) ? file : new File(outImg);
            BufferedImage image = null;
            try {
                image = ImageIO.read(file);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            int width = ((Image)image).getWidth(null);
            int height = ((Image)image).getHeight(null);
            BufferedImage bufferedImage = new BufferedImage(width, height, 1);
            Graphics2D g = bufferedImage.createGraphics();
            g.drawImage(image, 0, 0, width, height, null);
            if (null != degree) {
                g.rotate(Math.toRadians(degree.intValue()), (double)bufferedImage.getWidth() / 2.0, (double)bufferedImage.getHeight() / 2.0);
            }
            BufferedImage waterImage = ImageIO.read(new File(waterImg));
            int width_1 = ((Image)waterImage).getWidth(null);
            int height_1 = ((Image)waterImage).getHeight(null);
            g.setComposite(AlphaComposite.getInstance(10, alpha));
            int widthDiff = width - width_1;
            int heightDiff = height - height_1;
            if (x < 0) {
                x = widthDiff / 2;
            } else if (x > widthDiff) {
                x = widthDiff;
            }
            if (y < 0) {
                y = heightDiff / 2;
            } else if (y > heightDiff) {
                y = heightDiff;
            }
            g.drawImage(waterImage, x, y, width_1, height_1, null);
            g.dispose();
            ImageIO.write((RenderedImage)bufferedImage, ImageWatermarkUtil.issuffix(suffix) ? suffix.substring(1) : suffix, outFile);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void pressText(String targetImg, String pressText, String fontName, int fontStyle, int fontSize, Color color, int x, int y, float alpha) {
        ImageWatermarkUtil.pressText(targetImg, pressText, null, fontName, fontStyle, fontSize, color, x, y, alpha, null);
    }

    public static void pressText(String targetImg, String pressText, String outImg, String fontName, int fontStyle, int fontSize, Color color, int positionX, int positionY, float alpha, Integer degree) {
        try {
            File file = new File(targetImg);
            File outFile = StrUtil.isEmpty((CharSequence)outImg) ? file : new File(outImg);
            BufferedImage image = ImageIO.read(file);
            int width = ((Image)image).getWidth(null);
            int height = ((Image)image).getHeight(null);
            BufferedImage bufferedImage = new BufferedImage(width, height, 1);
            Font font = new Font(fontName, fontStyle, fontSize);
            Graphics2D g = bufferedImage.createGraphics();
            g.drawImage(image, 0, 0, width, height, null);
            g.setFont(font);
            g.setColor(color);
            g.setComposite(AlphaComposite.getInstance(10, alpha));
            if (null != degree) {
                g.rotate(Math.toRadians(degree.intValue()), (double)bufferedImage.getWidth() / 2.0, (double)bufferedImage.getHeight() / 2.0);
            }
            FontRenderContext context = g.getFontRenderContext();
            Rectangle2D stringBounds = font.getStringBounds(pressText, context);
            int textWidth = (int)stringBounds.getWidth();
            int textHeight = (int)stringBounds.getHeight();
            int widthDiff = width - textWidth;
            int heightDiff = height - textHeight;
            if (positionX < 0) {
                positionX = widthDiff / 2;
            } else if (positionX > widthDiff) {
                positionX = widthDiff;
            }
            if (positionY < 0) {
                positionY = heightDiff / 2;
            } else if (positionY > heightDiff) {
                positionY = heightDiff;
            }
            g.drawString(pressText, positionX, positionY + textHeight);
            g.dispose();
            ImageIO.write((RenderedImage)bufferedImage, "JPEG", outFile);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void pressTextToRightBottom(String targetImg, String pressText, String fontName, int fontStyle, int fontSize, Color color, float alpha) {
        ImageWatermarkUtil.pressTextToRightBottom(targetImg, pressText, null, fontName, fontStyle, fontSize, color, alpha, null);
    }

    public static void pressTextToRightBottom(String targetImg, String pressText, String outImg, String fontName, int fontStyle, int fontSize, Color color, float alpha, Integer degree) {
        try {
            File file = new File(targetImg);
            File outFile = StrUtil.isEmpty((CharSequence)outImg) ? file : new File(outImg);
            BufferedImage image = ImageIO.read(file);
            int width = ((Image)image).getWidth(null);
            int height = ((Image)image).getHeight(null);
            BufferedImage bufferedImage = new BufferedImage(width, height, 1);
            Font font = new Font(fontName, fontStyle, fontSize);
            Graphics2D g = bufferedImage.createGraphics();
            g.drawImage(image, 0, 0, width, height, null);
            g.setFont(font);
            g.setColor(color);
            g.setComposite(AlphaComposite.getInstance(10, alpha));
            if (null != degree) {
                g.rotate(Math.toRadians(degree.intValue()), (double)bufferedImage.getWidth() / 2.0, (double)bufferedImage.getHeight() / 2.0);
            }
            FontRenderContext context = g.getFontRenderContext();
            Rectangle2D stringBounds = font.getStringBounds(pressText, context);
            int textWidth = (int)stringBounds.getWidth();
            int textHight = (int)stringBounds.getHeight();
            g.drawString(pressText, width - textWidth, height - textHight);
            g.dispose();
            ImageIO.write((RenderedImage)bufferedImage, "JPEG", outFile);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static boolean issuffix(String suffix) {
        boolean starts = suffix.startsWith(".");
        return starts;
    }

    public static void main(String[] args) {
        ImageWatermarkUtil.pressText("/Users/cloud/develop/img/1.jpg", "\u5927\u718a\u732b", "\u5b8b\u4f53", 1, 20, Color.BLACK, 120, 120, 1.0f);
    }
}

