/*
 * Decompiled with CFR 0.152.
 */
package cn.dolphin.core.image;

import cn.dolphin.core.file.FileUtil;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.color.ColorSpace;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.ColorConvertOp;
import java.awt.image.CropImageFilter;
import java.awt.image.FilteredImageSource;
import java.awt.image.RenderedImage;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import net.coobird.thumbnailator.Thumbnails;
import org.apache.commons.io.IOUtils;
import org.springframework.web.multipart.MultipartFile;

public class ImageUtil {
    public static final float DEFAULT_QUALITY = 0.2125f;

    public static String getType(byte[] data) {
        String type = "JPG";
        if (data[1] == 80 && data[2] == 78 && data[3] == 71) {
            type = "PNG";
            return type;
        }
        if (data[0] == 71 && data[1] == 73 && data[2] == 70) {
            type = "GIF";
            return type;
        }
        if (data[6] == 74 && data[7] == 70 && data[8] == 73 && data[9] == 70) {
            type = "JPG";
            return type;
        }
        return type;
    }

    public static void addWaterMark(String imgPath, String markPath, int x, int y, float alpha, String destPath) throws Exception {
        try {
            BufferedImage bufferedImage = ImageUtil.addWaterMark(imgPath, markPath, x, y, alpha);
            ImageIO.write((RenderedImage)bufferedImage, ImageUtil.imageFormat(imgPath), new File(destPath));
        }
        catch (Exception e) {
            throw new RuntimeException("\u6dfb\u52a0\u56fe\u7247\u6c34\u5370\u5f02\u5e38");
        }
    }

    public static void addWaterMark(String imgPath, String markPath, int x, int y, float alpha, String format, String destPath) throws Exception {
        try {
            BufferedImage bufferedImage = ImageUtil.addWaterMark(imgPath, markPath, x, y, alpha);
            ImageIO.write((RenderedImage)bufferedImage, format, new File(destPath));
        }
        catch (Exception e) {
            throw new RuntimeException("\u6dfb\u52a0\u56fe\u7247\u6c34\u5370\u5f02\u5e38");
        }
    }

    public static BufferedImage addWaterMark(String imgPath, String markPath, int x, int y, float alpha) throws Exception {
        BufferedImage targetImage = null;
        try {
            BufferedImage img = ImageIO.read(new File(imgPath));
            targetImage = new BufferedImage(((Image)img).getWidth(null), ((Image)img).getHeight(null), 1);
            Graphics2D g = targetImage.createGraphics();
            g.drawImage((Image)img, 0, 0, null);
            BufferedImage markImg = ImageIO.read(new File(markPath));
            g.setComposite(AlphaComposite.getInstance(10, alpha));
            g.drawImage((Image)markImg, x, y, null);
            g.dispose();
        }
        catch (Exception e) {
            throw new RuntimeException("\u6dfb\u52a0\u56fe\u7247\u6c34\u5370\u64cd\u4f5c\u5f02\u5e38");
        }
        return targetImage;
    }

    public static void addTextMark(String imgPath, String text, Font font, Color color, float x, float y, float alpha, String destPath) throws Exception {
        try {
            BufferedImage bufferedImage = ImageUtil.addTextMark(imgPath, text, font, color, x, y, alpha);
            ImageIO.write((RenderedImage)bufferedImage, ImageUtil.imageFormat(imgPath), new File(destPath));
        }
        catch (Exception e) {
            throw new RuntimeException("\u56fe\u7247\u6dfb\u52a0\u6587\u5b57\u6c34\u5370\u5f02\u5e38");
        }
    }

    public static void addTextMark(String imgPath, String text, Font font, Color color, float x, float y, float alpha, String format, String destPath) throws Exception {
        try {
            BufferedImage bufferedImage = ImageUtil.addTextMark(imgPath, text, font, color, x, y, alpha);
            ImageIO.write((RenderedImage)bufferedImage, format, new File(destPath));
        }
        catch (Exception e) {
            throw new RuntimeException("\u56fe\u7247\u6dfb\u52a0\u6587\u5b57\u6c34\u5370\u5f02\u5e38");
        }
    }

    public static BufferedImage addTextMark(String imgPath, String text, Font font, Color color, float x, float y, float alpha) throws Exception {
        BufferedImage targetImage = null;
        try {
            Font Dfont = font == null ? new Font("\u5b8b\u4f53", 20, 13) : font;
            BufferedImage img = ImageIO.read(new File(imgPath));
            targetImage = new BufferedImage(((Image)img).getWidth(null), ((Image)img).getHeight(null), 1);
            Graphics2D g = targetImage.createGraphics();
            g.drawImage((Image)img, 0, 0, null);
            g.setColor(color);
            g.setFont(Dfont);
            g.setComposite(AlphaComposite.getInstance(10, alpha));
            g.drawString(text, x, y);
            g.dispose();
        }
        catch (Exception e) {
            throw new RuntimeException("\u6dfb\u52a0\u6587\u5b57\u6c34\u5370\u64cd\u4f5c\u5f02\u5e38");
        }
        return targetImage;
    }

    public static void compressImage(String imgPath, float quality, int width, int height, boolean autoSize, String destPath) throws Exception {
        try {
            BufferedImage bufferedImage = ImageUtil.compressImage(imgPath, quality, width, height, autoSize);
            ImageIO.write((RenderedImage)bufferedImage, ImageUtil.imageFormat(imgPath), new File(destPath));
        }
        catch (Exception e) {
            throw new RuntimeException("\u56fe\u7247\u538b\u7f29\u5f02\u5e38");
        }
    }

    public static void compressImage(String imgPath, float quality, int width, int height, boolean autoSize, String format, String destPath) throws Exception {
        try {
            BufferedImage bufferedImage = ImageUtil.compressImage(imgPath, quality, width, height, autoSize);
            ImageIO.write((RenderedImage)bufferedImage, format, new File(destPath));
        }
        catch (Exception e) {
            throw new RuntimeException("\u56fe\u7247\u538b\u7f29\u5f02\u5e38");
        }
    }

    public static BufferedImage compressImage(String imgPath, float quality, int width, int height, boolean autoSize) throws Exception {
        BufferedImage targetImage = null;
        if (quality < 0.0f || quality > 1.0f) {
            quality = 0.2125f;
        }
        try {
            int newheight;
            BufferedImage img = ImageIO.read(new File(imgPath));
            int newwidth = width > 0 ? width : ((Image)img).getWidth(null);
            int n = newheight = height > 0 ? height : ((Image)img).getHeight(null);
            if (autoSize) {
                double heightrate;
                double Widthrate = (double)((Image)img).getWidth(null) / (double)width + 0.1;
                double rate = Widthrate > (heightrate = (double)((Image)img).getHeight(null) / (double)height + 0.1) ? Widthrate : heightrate;
                newwidth = (int)((double)((Image)img).getWidth(null) / rate);
                newheight = (int)((double)((Image)img).getHeight(null) / rate);
            }
            targetImage = new BufferedImage(newwidth, newheight, 1);
            Graphics2D g = targetImage.createGraphics();
            g.drawImage(img, 0, 0, newwidth, newheight, null);
            g.dispose();
        }
        catch (Exception e) {
            throw new RuntimeException("\u56fe\u7247\u538b\u7f29\u64cd\u4f5c\u5f02\u5e38");
        }
        return targetImage;
    }

    public static void imageGray(String imgPath, String destPath) throws Exception {
        ImageUtil.imageGray(imgPath, ImageUtil.imageFormat(imgPath), destPath);
    }

    public static void imageGray(String imgPath, String format, String destPath) throws Exception {
        try {
            BufferedImage bufferedImage = ImageIO.read(new File(imgPath));
            ColorSpace cs = ColorSpace.getInstance(1003);
            ColorConvertOp op = new ColorConvertOp(cs, null);
            bufferedImage = op.filter(bufferedImage, null);
            ImageIO.write((RenderedImage)bufferedImage, format, new File(destPath));
        }
        catch (Exception e) {
            throw new RuntimeException("\u56fe\u7247\u7070\u767d\u5316\u5f02\u5e38");
        }
    }

    public static void imageLucency(String imgPath, String destPath) throws Exception {
        try {
            BufferedImage bufferedImage = ImageUtil.imageLucency(imgPath);
            ImageIO.write((RenderedImage)bufferedImage, ImageUtil.imageFormat(imgPath), new File(destPath));
        }
        catch (Exception e) {
            throw new RuntimeException("\u56fe\u7247\u900f\u660e\u5316\u5f02\u5e38");
        }
    }

    public static void imageLucency(String imgPath, String format, String destPath) throws Exception {
        try {
            BufferedImage bufferedImage = ImageUtil.imageLucency(imgPath);
            ImageIO.write((RenderedImage)bufferedImage, format, new File(destPath));
        }
        catch (Exception e) {
            throw new RuntimeException("\u56fe\u7247\u900f\u660e\u5316\u5f02\u5e38");
        }
    }

    public static BufferedImage imageLucency(String imgPath) throws Exception {
        BufferedImage targetImage = null;
        try {
            BufferedImage img = ImageIO.read(new FileInputStream(imgPath));
            int alpha = 0;
            ImageUtil.executeRGB(img, alpha);
            targetImage = new BufferedImage(img.getWidth(null), img.getHeight(null), 1);
            Graphics2D g = targetImage.createGraphics();
            g.drawImage((Image)img, 0, 0, null);
            g.dispose();
        }
        catch (Exception e) {
            throw new RuntimeException("\u56fe\u7247\u900f\u660e\u5316\u6267\u884c\u5f02\u5e38");
        }
        return targetImage;
    }

    public static void executeRGB(BufferedImage img, int alpha) throws Exception {
        int rgb = 0;
        for (int x = img.getMinX(); x < img.getWidth(); ++x) {
            for (int y = img.getMinY(); y < img.getHeight(); ++y) {
                rgb = img.getRGB(x, y);
                int R = (rgb & 0xFF0000) >> 16;
                int G = (rgb & 0xFF00) >> 8;
                int B = rgb & 0xFF;
                if (255 - R >= 30 || 255 - G >= 30 || 255 - B >= 30) continue;
                rgb = alpha + 1 << 24 | rgb & 0xFFFFFF;
                img.setRGB(x, y, rgb);
            }
        }
    }

    public static void formatConvert(String imgPath, String format, String destPath) throws Exception {
        try {
            BufferedImage bufferedImage = ImageIO.read(new File(imgPath));
            ImageIO.write((RenderedImage)bufferedImage, format, new File(destPath));
        }
        catch (IOException e) {
            throw new RuntimeException("\u6587\u4ef6\u683c\u5f0f\u8f6c\u6362\u51fa\u9519");
        }
    }

    public static void formatConvert(BufferedImage bufferedImag, String format, String destPath) throws Exception {
        try {
            ImageIO.write((RenderedImage)bufferedImag, format, new File(destPath));
        }
        catch (IOException e) {
            throw new RuntimeException("\u6587\u4ef6\u683c\u5f0f\u8f6c\u6362\u51fa\u9519");
        }
    }

    public static String imageFormat(String imgPath) throws Exception {
        String[] filess = imgPath.split("\\\\");
        String[] formats = filess[filess.length - 1].split("\\.");
        return formats[formats.length - 1];
    }

    public static final void scale(File sourceImg, File output, int scale, boolean flag) throws IOException {
        BufferedImage src = ImageIO.read(sourceImg);
        int width = src.getWidth();
        int height = src.getHeight();
        if (flag) {
            width *= scale;
            height *= scale;
        } else {
            width /= scale;
            height /= scale;
        }
        Image image = src.getScaledInstance(width, height, 1);
        BufferedImage tag = new BufferedImage(width, height, 1);
        Graphics g = tag.getGraphics();
        g.drawImage(image, 0, 0, null);
        g.dispose();
        ImageIO.write((RenderedImage)tag, "JPEG", output);
    }

    public static final void scale(File sourceImg, File output, int height, int width, boolean flag) {
        try {
            double ratio = 0.0;
            BufferedImage bi = ImageIO.read(sourceImg);
            Image itemp = bi.getScaledInstance(width, height, 4);
            if (bi.getHeight() > height || bi.getWidth() > width) {
                ratio = bi.getHeight() > bi.getWidth() ? new Integer(height).doubleValue() / (double)bi.getHeight() : new Integer(width).doubleValue() / (double)bi.getWidth();
                AffineTransformOp op = new AffineTransformOp(AffineTransform.getScaleInstance(ratio, ratio), null);
                itemp = op.filter(bi, null);
            }
            if (flag) {
                BufferedImage image = new BufferedImage(width, height, 1);
                Graphics2D g = image.createGraphics();
                g.setColor(Color.white);
                g.fillRect(0, 0, width, height);
                if (width == itemp.getWidth(null)) {
                    g.drawImage(itemp, 0, (height - itemp.getHeight(null)) / 2, itemp.getWidth(null), itemp.getHeight(null), Color.white, null);
                } else {
                    g.drawImage(itemp, (width - itemp.getWidth(null)) / 2, 0, itemp.getWidth(null), itemp.getHeight(null), Color.white, null);
                }
                g.dispose();
                itemp = image;
            }
            ImageIO.write((RenderedImage)((BufferedImage)itemp), "JPEG", output);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static final void scale(InputStream sourceImg, OutputStream output, int height, int width, boolean flag) {
        try {
            double ratio = 0.0;
            BufferedImage bi = ImageIO.read(sourceImg);
            Image itemp = bi.getScaledInstance(width, height, 4);
            if (bi.getHeight() > height || bi.getWidth() > width) {
                ratio = bi.getHeight() > bi.getWidth() ? new Integer(height).doubleValue() / (double)bi.getHeight() : new Integer(width).doubleValue() / (double)bi.getWidth();
                AffineTransformOp op = new AffineTransformOp(AffineTransform.getScaleInstance(ratio, ratio), null);
                itemp = op.filter(bi, null);
            }
            if (flag) {
                BufferedImage image = new BufferedImage(width, height, 1);
                Graphics2D g = image.createGraphics();
                g.setColor(Color.white);
                g.fillRect(0, 0, width, height);
                if (width == itemp.getWidth(null)) {
                    g.drawImage(itemp, 0, (height - itemp.getHeight(null)) / 2, itemp.getWidth(null), itemp.getHeight(null), Color.white, null);
                } else {
                    g.drawImage(itemp, (width - itemp.getWidth(null)) / 2, 0, itemp.getWidth(null), itemp.getHeight(null), Color.white, null);
                }
                g.dispose();
                itemp = image;
            }
            ImageIO.write((RenderedImage)((BufferedImage)itemp), "JPEG", output);
            itemp.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static final void scaleByWidth(File sourceImg, File output, int width) {
        try {
            BufferedImage bi = ImageIO.read(sourceImg);
            int imageWidth = bi.getWidth();
            float sacle = (float)width * 1.0f / ((float)imageWidth * 1.0f);
            int height = (int)((float)bi.getHeight() * sacle);
            Image itemp = bi.getScaledInstance(width, height, 4);
            double widthRatio = new Integer(width).doubleValue() / (double)bi.getWidth();
            double heightRatio = new Integer(height).doubleValue() / (double)bi.getHeight();
            AffineTransformOp op = new AffineTransformOp(AffineTransform.getScaleInstance(widthRatio, heightRatio), null);
            itemp = op.filter(bi, null);
            ImageIO.write((RenderedImage)((BufferedImage)itemp), "JPEG", output);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static final byte[] scale(byte[] img, int height, int width, boolean flag) {
        try {
            double ratio = 0.0;
            ByteArrayInputStream inputStream = new ByteArrayInputStream(img);
            BufferedImage bi = ImageIO.read(inputStream);
            Image itemp = bi.getScaledInstance(width, height, 4);
            if (bi.getHeight() > height || bi.getWidth() > width) {
                ratio = bi.getHeight() > bi.getWidth() ? new Integer(height).doubleValue() / (double)bi.getHeight() : new Integer(width).doubleValue() / (double)bi.getWidth();
                AffineTransformOp op = new AffineTransformOp(AffineTransform.getScaleInstance(ratio, ratio), null);
                itemp = op.filter(bi, null);
            }
            if (flag) {
                BufferedImage image = new BufferedImage(width, height, 1);
                Graphics2D g = image.createGraphics();
                g.setColor(Color.white);
                g.fillRect(0, 0, width, height);
                if (width == itemp.getWidth(null)) {
                    g.drawImage(itemp, 0, (height - itemp.getHeight(null)) / 2, itemp.getWidth(null), itemp.getHeight(null), Color.white, null);
                } else {
                    g.drawImage(itemp, (width - itemp.getWidth(null)) / 2, 0, itemp.getWidth(null), itemp.getHeight(null), Color.white, null);
                }
                g.dispose();
                itemp = image;
            }
            ByteArrayOutputStream outputstream = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)((BufferedImage)itemp), "JPEG", outputstream);
            return outputstream.toByteArray();
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static final void cut(File sourceImg, File output, int x, int y, int width, int height) {
        try {
            BufferedImage bi = ImageIO.read(sourceImg);
            int srcWidth = bi.getHeight();
            int srcHeight = bi.getWidth();
            if (srcWidth > 0 && srcHeight > 0) {
                Image image = bi.getScaledInstance(srcWidth, srcHeight, 1);
                CropImageFilter cropFilter = new CropImageFilter(x, y, width, height);
                Image img = Toolkit.getDefaultToolkit().createImage(new FilteredImageSource(image.getSource(), cropFilter));
                BufferedImage tag = new BufferedImage(width, height, 1);
                Graphics g = tag.getGraphics();
                g.drawImage(img, 0, 0, width, height, null);
                g.dispose();
                ImageIO.write((RenderedImage)tag, "JPEG", output);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static final void cut2(String srcImageFile, String descDir, int rows, int cols) {
        try {
            if (rows <= 0 || rows > 20) {
                rows = 2;
            }
            if (cols <= 0 || cols > 20) {
                cols = 2;
            }
            BufferedImage bi = ImageIO.read(new File(srcImageFile));
            int srcWidth = bi.getHeight();
            int srcHeight = bi.getWidth();
            if (srcWidth > 0 && srcHeight > 0) {
                Image image = bi.getScaledInstance(srcWidth, srcHeight, 1);
                int destWidth = srcWidth;
                int destHeight = srcHeight;
                destWidth = srcWidth % cols == 0 ? srcWidth / cols : (int)Math.floor(srcWidth / cols) + 1;
                destHeight = srcHeight % rows == 0 ? srcHeight / rows : (int)Math.floor(srcWidth / rows) + 1;
                for (int i = 0; i < rows; ++i) {
                    for (int j = 0; j < cols; ++j) {
                        CropImageFilter cropFilter = new CropImageFilter(j * destWidth, i * destHeight, destWidth, destHeight);
                        Image img = Toolkit.getDefaultToolkit().createImage(new FilteredImageSource(image.getSource(), cropFilter));
                        BufferedImage tag = new BufferedImage(destWidth, destHeight, 1);
                        Graphics g = tag.getGraphics();
                        g.drawImage(img, 0, 0, null);
                        g.dispose();
                        ImageIO.write((RenderedImage)tag, "JPEG", new File(descDir + "_r" + i + "_c" + j + ".jpg"));
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static final void cut3(String srcImageFile, String descDir, int destWidth, int destHeight) {
        try {
            if (destWidth <= 0) {
                destWidth = 200;
            }
            if (destHeight <= 0) {
                destHeight = 150;
            }
            BufferedImage bi = ImageIO.read(new File(srcImageFile));
            int srcWidth = bi.getHeight();
            int srcHeight = bi.getWidth();
            if (srcWidth > destWidth && srcHeight > destHeight) {
                Image image = bi.getScaledInstance(srcWidth, srcHeight, 1);
                int cols = 0;
                int rows = 0;
                cols = srcWidth % destWidth == 0 ? srcWidth / destWidth : (int)Math.floor(srcWidth / destWidth) + 1;
                rows = srcHeight % destHeight == 0 ? srcHeight / destHeight : (int)Math.floor(srcHeight / destHeight) + 1;
                for (int i = 0; i < rows; ++i) {
                    for (int j = 0; j < cols; ++j) {
                        CropImageFilter cropFilter = new CropImageFilter(j * destWidth, i * destHeight, destWidth, destHeight);
                        Image img = Toolkit.getDefaultToolkit().createImage(new FilteredImageSource(image.getSource(), cropFilter));
                        BufferedImage tag = new BufferedImage(destWidth, destHeight, 1);
                        Graphics g = tag.getGraphics();
                        g.drawImage(img, 0, 0, null);
                        g.dispose();
                        ImageIO.write((RenderedImage)tag, "JPEG", new File(descDir + "_r" + i + "_c" + j + ".jpg"));
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static final void convert(String srcImageFile, String formatName, String destImageFile) {
        try {
            File f = new File(srcImageFile);
            f.canRead();
            f.canWrite();
            BufferedImage src = ImageIO.read(f);
            ImageIO.write((RenderedImage)src, formatName, new File(destImageFile));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static final void gray(String srcImageFile, String destImageFile) {
        try {
            BufferedImage src = ImageIO.read(new File(srcImageFile));
            ColorSpace cs = ColorSpace.getInstance(1003);
            ColorConvertOp op = new ColorConvertOp(cs, null);
            src = op.filter(src, null);
            ImageIO.write((RenderedImage)src, "JPEG", new File(destImageFile));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static final void pressText(String pressText, String srcImageFile, String destImageFile, String fontName, int fontStyle, Color color, int fontSize, int x, int y, float alpha) {
        try {
            File img = new File(srcImageFile);
            BufferedImage src = ImageIO.read(img);
            int width = ((Image)src).getWidth(null);
            int height = ((Image)src).getHeight(null);
            BufferedImage image = new BufferedImage(width, height, 1);
            Graphics2D g = image.createGraphics();
            g.drawImage(src, 0, 0, width, height, null);
            g.setColor(color);
            g.setFont(new Font(fontName, fontStyle, fontSize));
            g.setComposite(AlphaComposite.getInstance(10, alpha));
            g.drawString(pressText, (width - ImageUtil.getLength(pressText) * fontSize) / 2 + x, (height - fontSize) / 2 + y);
            g.dispose();
            ImageIO.write((RenderedImage)image, "JPEG", new File(destImageFile));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static final void pressText2(String pressText, String srcImageFile, String destImageFile, String fontName, int fontStyle, Color color, int fontSize, int x, int y, float alpha) {
        try {
            File img = new File(srcImageFile);
            BufferedImage src = ImageIO.read(img);
            int width = ((Image)src).getWidth(null);
            int height = ((Image)src).getHeight(null);
            BufferedImage image = new BufferedImage(width, height, 1);
            Graphics2D g = image.createGraphics();
            g.drawImage(src, 0, 0, width, height, null);
            g.setColor(color);
            g.setFont(new Font(fontName, fontStyle, fontSize));
            g.setComposite(AlphaComposite.getInstance(10, alpha));
            g.drawString(pressText, (width - ImageUtil.getLength(pressText) * fontSize) / 2 + x, (height - fontSize) / 2 + y);
            g.dispose();
            ImageIO.write((RenderedImage)image, "JPEG", new File(destImageFile));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static final void pressImage(String pressImg, String srcImageFile, String destImageFile, int x, int y, float alpha) {
        try {
            File img = new File(srcImageFile);
            BufferedImage src = ImageIO.read(img);
            int wideth = ((Image)src).getWidth(null);
            int height = ((Image)src).getHeight(null);
            BufferedImage image = new BufferedImage(wideth, height, 1);
            Graphics2D g = image.createGraphics();
            g.drawImage(src, 0, 0, wideth, height, null);
            BufferedImage src_biao = ImageIO.read(new File(pressImg));
            int wideth_biao = ((Image)src_biao).getWidth(null);
            int height_biao = ((Image)src_biao).getHeight(null);
            g.setComposite(AlphaComposite.getInstance(10, alpha));
            g.drawImage(src_biao, (wideth - wideth_biao) / 2, (height - height_biao) / 2, wideth_biao, height_biao, null);
            g.dispose();
            ImageIO.write((RenderedImage)image, "JPEG", new File(destImageFile));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static final int getLength(String text) {
        int length = 0;
        for (int i = 0; i < text.length(); ++i) {
            if (new String(text.charAt(i) + "").getBytes().length > 1) {
                length += 2;
                continue;
            }
            ++length;
        }
        return length / 2;
    }

    public static final void changeImge(File img, int width, int height) {
        try {
            Thumbnails.of((File[])new File[]{img}).size(width, height).keepAspectRatio(false).toFile(img);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new IllegalStateException("\u56fe\u7247\u8f6c\u6362\u51fa\u9519\uff01", e);
        }
    }

    public static final void scale(BufferedImage orgImg, double scale, String targetFile) throws IOException {
        Thumbnails.of((BufferedImage[])new BufferedImage[]{orgImg}).scale(scale).toFile(targetFile);
    }

    public static final void scale(String orgImgFile, double scale, String targetFile) throws IOException {
        Thumbnails.of((String[])new String[]{orgImgFile}).scale(scale).toFile(targetFile);
    }

    public static final void format(String orgImgFile, int width, int height, String suffixName, String targetFile) throws IOException {
        Thumbnails.of((String[])new String[]{orgImgFile}).size(width, height).outputFormat(suffixName).toFile(targetFile);
    }

    public static final double scaleWidth(BufferedImage orgImg, int targetWidth, String targetFile) throws IOException {
        int orgWidth = orgImg.getWidth();
        double scale = (double)targetWidth * 1.0 / (double)orgWidth;
        ImageUtil.scale(orgImg, scale, targetFile);
        return scale;
    }

    public static final void scaleWidth(String orgImgFile, int targetWidth, String targetFile) throws IOException {
        BufferedImage bufferedImage = ImageIO.read(new File(orgImgFile));
        ImageUtil.scaleWidth(bufferedImage, targetWidth, targetFile);
    }

    public static final double scaleHeight(BufferedImage orgImg, int targetHeight, String targetFile) throws IOException {
        int orgHeight = orgImg.getHeight();
        double scale = (double)targetHeight * 1.0 / (double)orgHeight;
        ImageUtil.scale(orgImg, scale, targetFile);
        return scale;
    }

    public static final void scaleHeight(String orgImgFile, int targetHeight, String targetFile) throws IOException {
        BufferedImage bufferedImage = ImageIO.read(new File(orgImgFile));
        ImageUtil.scaleHeight(bufferedImage, targetHeight, targetFile);
    }

    public static final void scaleWidth(File file, Integer width) throws IOException {
        String fileName = file.getName();
        String filePath = file.getAbsolutePath();
        String postFix = fileName.substring(fileName.lastIndexOf(".")).toLowerCase();
        BufferedImage bufferedImg = ImageIO.read(file);
        String targetFile = filePath + "_s" + postFix;
        ImageUtil.scaleWidth(bufferedImg, (int)width, targetFile);
        String targetFile2 = filePath + "@" + width;
        new File(targetFile).renameTo(new File(targetFile2));
    }

    public static BufferedImage getScaleZoom(BufferedImage img, int targetSize) {
        double rate2;
        double rate1;
        int srcWidth = img.getWidth();
        int srcHeight = img.getHeight();
        int targetWidth = targetSize;
        int targetHeight = targetSize;
        if (targetSize > srcWidth || targetSize > srcHeight) {
            targetWidth = srcWidth;
            targetHeight = srcHeight;
        }
        double rate = (rate1 = (double)srcWidth / (double)targetWidth) > (rate2 = (double)srcHeight / (double)targetHeight) ? rate1 : rate2;
        int newWidth = (int)((double)srcWidth / rate);
        int newHeight = (int)((double)srcHeight / rate);
        int imageType = img.getTransparency() == 1 ? 1 : 2;
        BufferedImage tag = new BufferedImage(newWidth, newHeight, imageType);
        Image scaledImage = img.getScaledInstance(newWidth, newHeight, 8);
        tag.getGraphics().drawImage(scaledImage, 0, 0, null);
        return tag;
    }

    public static BufferedImage getScaleCutscale(BufferedImage img, int targetWidth, int targetHeight) {
        int srcWidth = img.getWidth();
        int srcHeight = img.getHeight();
        while (targetWidth > srcWidth || targetHeight > srcHeight) {
            double rt = targetWidth > srcWidth ? (double)targetWidth / (double)srcWidth : (double)targetHeight / (double)srcHeight;
            targetWidth = (int)((double)targetWidth / rt);
            targetHeight = (int)((double)targetHeight / rt);
        }
        double rate1 = (double)srcWidth / (double)targetWidth;
        double rate2 = (double)srcHeight / (double)targetHeight;
        double rate = rate1 < rate2 ? rate1 : rate2;
        int newWidth = (int)((double)srcWidth / rate);
        int newHeight = (int)((double)srcHeight / rate);
        int x1 = newWidth / 2 - targetWidth / 2;
        int x2 = newWidth / 2 + targetWidth / 2;
        int y1 = newHeight / 2 - targetHeight / 2;
        int y2 = newHeight / 2 + targetHeight / 2;
        int imageType = img.getTransparency() == 1 ? 1 : 2;
        BufferedImage tag = new BufferedImage(targetWidth, targetHeight, imageType);
        Image scaledImage = img.getScaledInstance(newWidth, newHeight, 8);
        tag.getGraphics().drawImage(scaledImage, 0, 0, targetWidth, targetHeight, x1, y1, x2, y2, null);
        return tag;
    }

    public static int[] getSizeInfo(String filePath) {
        File file = new File(filePath);
        return ImageUtil.getSizeInfo(file);
    }

    public static int[] getSizeInfo(URL url) {
        InputStream input = null;
        try {
            input = url.openStream();
            int[] nArray = ImageUtil.getSizeInfo(input);
            return nArray;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            IOUtils.closeQuietly((InputStream)input);
        }
    }

    public static int[] getSizeInfo(File file) {
        int[] nArray;
        if (!file.exists()) {
            throw new RuntimeException("file " + file.getAbsolutePath() + " doesn't exist.");
        }
        BufferedInputStream input = null;
        try {
            input = new BufferedInputStream(new FileInputStream(file));
            nArray = ImageUtil.getSizeInfo(input);
        }
        catch (Exception e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(input);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)input);
        return nArray;
    }

    public static int[] getSizeInfo(InputStream input) {
        try {
            BufferedImage img = ImageIO.read(input);
            int w = img.getWidth(null);
            int h = img.getHeight(null);
            return new int[]{w, h};
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static boolean thumbnailHead(String filePath, String fileName, String fileType, byte[] data, int width, int height) {
        try {
            File dir = new File(filePath);
            if (!dir.exists()) {
                dir.mkdir();
            }
            StringBuilder builder = new StringBuilder();
            builder.append(filePath).append("/").append(fileName).append(".").append(fileType);
            byte[] bytes = ImageUtil.scale(data, height > 70 ? height : height * 2, width > 70 ? width : width * 2, true);
            ByteArrayInputStream is = new ByteArrayInputStream(data);
            Thumbnails.of((InputStream[])new InputStream[]{is}).size(width, height).keepAspectRatio(false).toFile(builder.toString());
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static boolean upload(MultipartFile file, String path, String fileName, Map<String, Object> map) {
        String realPath = path + File.separator + fileName;
        System.out.println("realPath = " + realPath);
        File dest = new File(realPath);
        if (!dest.getParentFile().exists()) {
            dest.getParentFile().mkdir();
        }
        try {
            file.transferTo(dest);
            ImageIcon image = new ImageIcon(dest.getAbsolutePath());
            map.put("height", image.getIconHeight());
            map.put("width", image.getIconWidth());
            String thumbnailImg = path + File.separator + "thumbnail" + File.separator + fileName;
            File thumbNail = new File(thumbnailImg);
            if (!thumbNail.getParentFile().exists()) {
                thumbNail.getParentFile().mkdir();
            }
            Thumbnails.of((String[])new String[]{realPath}).size(200, 200).toFile(thumbnailImg);
            return true;
        }
        catch (IllegalStateException e) {
            return false;
        }
        catch (IOException e) {
            return false;
        }
    }

    public static void main(String[] args) throws Exception {
        File file = new File("/Users/cloud/Desktop/a.png");
        FileUtil.Tobyte(file);
        ImageUtil.thumbnailHead("/Users/cloud/Desktop", "c", "png", FileUtil.Tobyte(file), 390, 225);
        System.out.println(1);
    }
}

