/*
 * Decompiled with CFR 0.152.
 */
package cn.dolphin.core.i18n;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;

public final class Resources {
    private static final Map<String, ResourceBundle> MESSAGES = new HashMap<String, ResourceBundle>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getMessage(String key, Object ... params) {
        Locale locale = Locale.CHINA;
        ResourceBundle message = MESSAGES.get(locale.getLanguage());
        if (message == null) {
            Map<String, ResourceBundle> map = MESSAGES;
            synchronized (map) {
                message = MESSAGES.get(locale.getLanguage());
                if (message == null) {
                    message = ResourceBundle.getBundle("i18n/messages", locale);
                    MESSAGES.put(locale.getLanguage(), message);
                }
            }
        }
        if (params != null && params.length > 0) {
            String formatMessage = String.format(message.getString(key), params);
            return formatMessage;
        }
        return message.getString(key);
    }

    public static void flushMessage() {
        MESSAGES.clear();
    }
}

