/*
 * Decompiled with CFR 0.152.
 */
package cn.dolphin.core.html;

import cn.dolphin.core.util.CollectionUtil;
import cn.dolphin.core.util.StrUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jsoup.Connection;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JsoupUtil {
    private static final Logger logger = LoggerFactory.getLogger(JsoupUtil.class);

    public static final Document getDocumentByHtmlStr(String html) {
        return Jsoup.parse((String)html);
    }

    public static final Document getDocumentByHtmlFile(File html, String charset) throws IOException {
        return Jsoup.parse((File)html, (String)charset);
    }

    public static final Document getDocumentByHtmlFile(File html, String charset, String baseUrl) throws IOException {
        return Jsoup.parse((File)html, (String)charset, (String)baseUrl);
    }

    public static final Document getDocumentByGetUrlAndHeaders(String url, Map<String, String> headers) throws IOException {
        Connection connect = Jsoup.connect((String)url);
        if (CollectionUtil.isNotEmpty(headers)) {
            Set<Map.Entry<String, String>> entrySet = headers.entrySet();
            for (Map.Entry<String, String> entry : entrySet) {
                connect.header(entry.getKey(), entry.getValue());
            }
        }
        return connect.get();
    }

    public static final Document getDocumentByGetUrl(String url, Map<String, String> cookies) throws IOException {
        Connection connect = Jsoup.connect((String)url);
        if (CollectionUtil.isNotEmpty(cookies)) {
            connect.cookies(cookies);
        }
        return connect.get();
    }

    public static final Document getDocumentByGetUrl(String url, Map<String, String> cookies, Map<String, String> headers) throws IOException {
        Connection connect = Jsoup.connect((String)url);
        if (CollectionUtil.isNotEmpty(cookies)) {
            connect.cookies(cookies);
        }
        if (CollectionUtil.isNotEmpty(headers)) {
            Set<Map.Entry<String, String>> entrySet = headers.entrySet();
            for (Map.Entry<String, String> entry : entrySet) {
                connect.header(entry.getKey(), entry.getValue());
            }
        }
        return connect.get();
    }

    public static final Document getDocumentByGetUrl(String url) throws IOException {
        return Jsoup.connect((String)url).get();
    }

    public static final Document getDocumentByPostUrl(String url, Map<String, String> params) throws IOException {
        Connection connect = Jsoup.connect((String)url);
        if (CollectionUtil.isNotEmpty(params)) {
            connect.data(params);
        }
        return connect.post();
    }

    public static final Document getDocumentByPostUrl(String url, Map<String, String> params, Map<String, String> cookies) throws IOException {
        Connection connect = Jsoup.connect((String)url);
        if (CollectionUtil.isNotEmpty(params)) {
            connect.data(params);
        }
        if (CollectionUtil.isNotEmpty(cookies)) {
            connect.cookies(cookies);
        }
        return connect.post();
    }

    public static final Document getDocumentByPostUrl(String url, Map<String, String> params, Map<String, String> cookies, Map<String, String> headers) throws IOException {
        Connection connect = Jsoup.connect((String)url);
        if (CollectionUtil.isNotEmpty(params)) {
            connect.data(params);
        }
        if (CollectionUtil.isNotEmpty(cookies)) {
            connect.cookies(cookies);
        }
        if (CollectionUtil.isNotEmpty(headers)) {
            Set<Map.Entry<String, String>> entrySet = headers.entrySet();
            for (Map.Entry<String, String> entry : entrySet) {
                connect.header(entry.getKey(), entry.getValue());
            }
        }
        return connect.post();
    }

    public static final Element getElementById(Document doc, String id) {
        return doc.getElementById(id);
    }

    public static final Element getElementById(Element ele, String id) {
        return ele.getElementById(id);
    }

    public static final List<Element> getElementByElementsId(List<Element> eles, String id) {
        ArrayList<Element> es = new ArrayList<Element>();
        for (Element e : eles) {
            es.add(JsoupUtil.getElementById(e, id));
        }
        return es;
    }

    public static final List<Element> getElementsByIds(Document doc, List<String> ids) {
        ArrayList<Element> list = new ArrayList<Element>();
        for (String id : ids) {
            CollectionUtil.addNotNullElement(list, doc.getElementById(id));
        }
        return list;
    }

    public static final List<Element> getElementsByIds(Element ele, List<String> ids) {
        ArrayList<Element> list = new ArrayList<Element>();
        for (String id : ids) {
            CollectionUtil.addNotNullElement(list, ele.getElementById(id));
        }
        return list;
    }

    public static final List<Element> getElementByElementsIds(List<Element> eles, List<String> ids) {
        ArrayList<Element> es = new ArrayList<Element>();
        for (Element e : eles) {
            es.addAll(JsoupUtil.getElementsByIds(e, ids));
        }
        return es;
    }

    public static final List<Element> getElementsByTag(Document doc, String tag) {
        ArrayList<Element> list = new ArrayList<Element>();
        CollectionUtil.addNotNullElements(list, doc.getElementsByTag(tag));
        return list;
    }

    public static final List<Element> getElementsByTag(Element ele, String tag) {
        ArrayList<Element> list = new ArrayList<Element>();
        CollectionUtil.addNotNullElements(list, ele.getElementsByTag(tag));
        return list;
    }

    public static final List<Element> getElementByElementsTag(List<Element> eles, String tag) {
        ArrayList<Element> es = new ArrayList<Element>();
        for (Element e : eles) {
            es.addAll(JsoupUtil.getElementsByTag(e, tag));
        }
        return es;
    }

    public static final List<Element> getElementsByTags(Document doc, List<String> tags) {
        ArrayList<Element> list = new ArrayList<Element>();
        for (String tag : tags) {
            CollectionUtil.addNotNullElements(list, JsoupUtil.getElementsByTag(doc, tag));
        }
        return list;
    }

    public static final List<Element> getElementsByTags(Element ele, List<String> tags) {
        ArrayList<Element> list = new ArrayList<Element>();
        for (String tag : tags) {
            CollectionUtil.addNotNullElements(list, JsoupUtil.getElementsByTag(ele, tag));
        }
        return list;
    }

    public static final List<Element> getElementByElementsTags(List<Element> eles, List<String> tags) {
        ArrayList<Element> es = new ArrayList<Element>();
        for (Element e : eles) {
            es.addAll(JsoupUtil.getElementsByTags(e, tags));
        }
        return es;
    }

    public static final List<Element> getElementsByClass(Document doc, String clazz) {
        ArrayList<Element> list = new ArrayList<Element>();
        CollectionUtil.addNotNullElements(list, doc.getElementsByClass(clazz));
        return list;
    }

    public static final List<Element> getElementsByClass(Element ele, String clazz) {
        ArrayList<Element> list = new ArrayList<Element>();
        CollectionUtil.addNotNullElements(list, ele.getElementsByClass(clazz));
        return list;
    }

    public static final List<Element> getElementByElementsClass(List<Element> eles, String clazz) {
        ArrayList<Element> es = new ArrayList<Element>();
        for (Element e : eles) {
            es.addAll(JsoupUtil.getElementsByClass(e, clazz));
        }
        return es;
    }

    public static final List<Element> getElementsByClasses(Document doc, List<String> classes) {
        ArrayList<Element> list = new ArrayList<Element>();
        for (String clazz : classes) {
            CollectionUtil.addNotNullElements(list, JsoupUtil.getElementsByClass(doc, clazz));
        }
        return list;
    }

    public static final List<Element> getElementsByClasses(Element ele, List<String> classes) {
        ArrayList<Element> list = new ArrayList<Element>();
        for (String clazz : classes) {
            CollectionUtil.addNotNullElements(list, JsoupUtil.getElementsByClass(ele, clazz));
        }
        return list;
    }

    public static final List<Element> getElementByElementsClasses(List<Element> eles, List<String> classes) {
        ArrayList<Element> es = new ArrayList<Element>();
        for (Element e : eles) {
            es.addAll(JsoupUtil.getElementsByClasses(e, classes));
        }
        return es;
    }

    public static final List<Element> getElementsByAttr(Document doc, String attr) {
        ArrayList<Element> list = new ArrayList<Element>();
        CollectionUtil.addNotNullElements(list, doc.getElementsByAttribute(attr));
        return list;
    }

    public static final List<Element> getElementsByAttr(Element ele, String attr) {
        ArrayList<Element> list = new ArrayList<Element>();
        CollectionUtil.addNotNullElements(list, ele.getElementsByAttribute(attr));
        return list;
    }

    public static final List<Element> getElementByElementsAttr(List<Element> eles, String attr) {
        ArrayList<Element> es = new ArrayList<Element>();
        for (Element e : eles) {
            es.addAll(JsoupUtil.getElementsByAttr(e, attr));
        }
        return es;
    }

    public static final List<Element> getElementsByAttrs(Document doc, List<String> attrs) {
        ArrayList<Element> list = new ArrayList<Element>();
        for (String attr : attrs) {
            CollectionUtil.addNotNullElements(list, JsoupUtil.getElementsByAttr(doc, attr));
        }
        return list;
    }

    public static final List<Element> getElementsByAttrs(Element ele, List<String> attrs) {
        ArrayList<Element> list = new ArrayList<Element>();
        for (String attr : attrs) {
            CollectionUtil.addNotNullElements(list, JsoupUtil.getElementsByAttr(ele, attr));
        }
        return list;
    }

    public static final List<Element> getElementByElementsAttrs(List<Element> eles, List<String> attrs) {
        ArrayList<Element> es = new ArrayList<Element>();
        for (Element e : eles) {
            es.addAll(JsoupUtil.getElementsByAttrs(e, attrs));
        }
        return es;
    }

    public static final List<Element> getElementsByAttrValue(Document doc, String attr, String value) {
        ArrayList<Element> list = new ArrayList<Element>();
        CollectionUtil.addNotNullElements(list, doc.getElementsByAttributeValue(attr, value));
        return list;
    }

    public static final List<Element> getElementsByAttrValue(Element ele, String attr, String value) {
        ArrayList<Element> list = new ArrayList<Element>();
        CollectionUtil.addNotNullElements(list, ele.getElementsByAttributeValue(attr, value));
        return list;
    }

    public static final List<Element> getElementByElementsAttrValue(List<Element> eles, String attr, String value) {
        ArrayList<Element> es = new ArrayList<Element>();
        for (Element e : eles) {
            es.addAll(JsoupUtil.getElementsByAttrValue(e, attr, value));
        }
        return es;
    }

    public static final List<Element> getElementsByAttrValues(Document doc, Map<String, String> attrValues) {
        ArrayList<Element> list = new ArrayList<Element>();
        Set<String> avs = attrValues.keySet();
        for (String attr : avs) {
            CollectionUtil.addNotNullElements(list, JsoupUtil.getElementsByAttrValue(doc, attr, attrValues.get(attr)));
        }
        return list;
    }

    public static final List<Element> getElementsByAttrValues(Element ele, Map<String, String> attrValues) {
        ArrayList<Element> list = new ArrayList<Element>();
        Set<String> avs = attrValues.keySet();
        for (String attr : avs) {
            CollectionUtil.addNotNullElements(list, JsoupUtil.getElementsByAttrValue(ele, attr, attrValues.get(attr)));
        }
        return list;
    }

    public static final List<Element> getElementByElementsAttrValues(List<Element> eles, Map<String, String> attrValues) {
        ArrayList<Element> es = new ArrayList<Element>();
        for (Element e : eles) {
            es.addAll(JsoupUtil.getElementsByAttrValues(e, attrValues));
        }
        return es;
    }

    public static final List<Element> getElementsByNotAttrValue(Document doc, String attr, String value) {
        ArrayList<Element> list = new ArrayList<Element>();
        CollectionUtil.addNotNullElements(list, doc.getElementsByAttributeValueNot(attr, value));
        return list;
    }

    public static final List<Element> getElementsByNotAttrValue(Element ele, String attr, String value) {
        ArrayList<Element> list = new ArrayList<Element>();
        CollectionUtil.addNotNullElements(list, ele.getElementsByAttributeValueNot(attr, value));
        return list;
    }

    public static final List<Element> getElementByNotElementsAttrValue(List<Element> eles, String attr, String value) {
        ArrayList<Element> es = new ArrayList<Element>();
        for (Element e : eles) {
            es.addAll(JsoupUtil.getElementsByNotAttrValue(e, attr, value));
        }
        return es;
    }

    public static final List<Element> getElementsByNotAttrValues(Document doc, Map<String, String> attrValues) {
        ArrayList<Element> list = new ArrayList<Element>();
        Set<String> avs = attrValues.keySet();
        for (String attr : avs) {
            CollectionUtil.addNotNullElements(list, JsoupUtil.getElementsByNotAttrValue(doc, attr, attrValues.get(attr)));
        }
        return list;
    }

    public static final List<Element> getElementsByNotAttrValues(Element ele, Map<String, String> attrValues) {
        ArrayList<Element> list = new ArrayList<Element>();
        Set<String> avs = attrValues.keySet();
        for (String attr : avs) {
            CollectionUtil.addNotNullElements(list, JsoupUtil.getElementsByNotAttrValue(ele, attr, attrValues.get(attr)));
        }
        return list;
    }

    public static final List<Element> getElementByNotElementsAttrValues(List<Element> eles, Map<String, String> attrValues) {
        ArrayList<Element> es = new ArrayList<Element>();
        for (Element e : eles) {
            es.addAll(JsoupUtil.getElementsByNotAttrValues(e, attrValues));
        }
        return es;
    }

    public static final List<Element> getElementsByRegAttrValue(Document doc, String attr, String valueReg) {
        ArrayList<Element> list = new ArrayList<Element>();
        CollectionUtil.addNotNullElements(list, doc.getElementsByAttributeValueMatching(attr, valueReg));
        return list;
    }

    public static final List<Element> getElementsByRegAttrValue(Element ele, String attr, String valueReg) {
        ArrayList<Element> list = new ArrayList<Element>();
        CollectionUtil.addNotNullElements(list, ele.getElementsByAttributeValueMatching(attr, valueReg));
        return list;
    }

    public static final List<Element> getElementByRegElementsAttrValue(List<Element> eles, String attr, String value) {
        ArrayList<Element> es = new ArrayList<Element>();
        for (Element e : eles) {
            es.addAll(JsoupUtil.getElementsByRegAttrValue(e, attr, value));
        }
        return es;
    }

    public static final List<Element> getElementsByRegAttrValues(Document doc, Map<String, String> attrValueRegs) {
        ArrayList<Element> list = new ArrayList<Element>();
        Set<String> avs = attrValueRegs.keySet();
        for (String attr : avs) {
            CollectionUtil.addNotNullElements(list, JsoupUtil.getElementsByRegAttrValue(doc, attr, attrValueRegs.get(attr)));
        }
        return list;
    }

    public static final List<Element> getElementsByRegAttrValues(Element ele, Map<String, String> attrValueRegs) {
        ArrayList<Element> list = new ArrayList<Element>();
        Set<String> avs = attrValueRegs.keySet();
        for (String attr : avs) {
            CollectionUtil.addNotNullElements(list, JsoupUtil.getElementsByRegAttrValue(ele, attr, attrValueRegs.get(attr)));
        }
        return list;
    }

    public static final List<Element> getElementByRegElementsAttrValues(List<Element> eles, Map<String, String> attrValueRegs) {
        ArrayList<Element> es = new ArrayList<Element>();
        for (Element e : eles) {
            es.addAll(JsoupUtil.getElementsByRegAttrValues(e, attrValueRegs));
        }
        return es;
    }

    public static final List<Element> getElementsByRegText(Document doc, String textReg) {
        ArrayList<Element> list = new ArrayList<Element>();
        CollectionUtil.addNotNullElements(list, doc.getElementsMatchingText(textReg));
        return list;
    }

    public static final List<Element> getElementsByRegText(Element ele, String textReg) {
        ArrayList<Element> list = new ArrayList<Element>();
        CollectionUtil.addNotNullElements(list, ele.getElementsMatchingText(textReg));
        return list;
    }

    public static final List<Element> getElementByRegElementsText(List<Element> eles, String textReg) {
        ArrayList<Element> es = new ArrayList<Element>();
        for (Element e : eles) {
            es.addAll(JsoupUtil.getElementsByRegText(e, textReg));
        }
        return es;
    }

    public static final List<Element> getElementsByRegTexts(Document doc, List<String> textRegs) {
        ArrayList<Element> list = new ArrayList<Element>();
        for (String textReg : textRegs) {
            CollectionUtil.addNotNullElements(list, JsoupUtil.getElementsByRegText(doc, textReg));
        }
        return list;
    }

    public static final List<Element> getElementsByRegTexts(Element ele, List<String> textRegs) {
        ArrayList<Element> list = new ArrayList<Element>();
        for (String textReg : textRegs) {
            CollectionUtil.addNotNullElements(list, JsoupUtil.getElementsByRegText(ele, textReg));
        }
        return list;
    }

    public static final List<Element> getElementByRegElementsText(List<Element> eles, List<String> textRegs) {
        ArrayList<Element> es = new ArrayList<Element>();
        for (Element e : eles) {
            es.addAll(JsoupUtil.getElementsByRegTexts(e, textRegs));
        }
        return es;
    }

    public static final List<Element> getElementsBySelector(Document doc, String selector) {
        ArrayList<Element> list = new ArrayList<Element>();
        CollectionUtil.addNotNullElements(list, doc.select(selector));
        return list;
    }

    public static final List<Element> getElementsBySelector(Element ele, String selector) {
        ArrayList<Element> list = new ArrayList<Element>();
        CollectionUtil.addNotNullElements(list, ele.select(selector));
        return list;
    }

    public static final List<Element> getElementsByElementsSelector(List<Element> eles, String selector) {
        ArrayList<Element> es = new ArrayList<Element>();
        for (Element e : eles) {
            es.addAll(JsoupUtil.getElementsBySelector(e, selector));
        }
        return es;
    }

    public static final List<Element> getUrlElements(Document doc, boolean isSrc, boolean isHref, boolean isLink) {
        ArrayList<Element> list = new ArrayList<Element>();
        Elements links = doc.select("a[href]");
        Elements media = doc.select("[src]");
        Elements imports = doc.select("link[href]");
        list.addAll((Collection<Element>)links);
        list.addAll((Collection<Element>)media);
        list.addAll((Collection<Element>)imports);
        return list;
    }

    public static final List<Element> getUrlElements(Element ele, boolean isSrc, boolean isHref, boolean isLink) {
        ArrayList<Element> list = new ArrayList<Element>();
        if (isSrc) {
            Elements media = ele.select("[src]");
            list.addAll((Collection<Element>)media);
        }
        if (isHref) {
            Elements links = ele.select("a[href]");
            list.addAll((Collection<Element>)links);
        }
        if (isLink) {
            Elements imports = ele.select("link[href]");
            list.addAll((Collection<Element>)imports);
        }
        return list;
    }

    public static final List<Element> getUrlElementsByElementsSelector(List<Element> eles, boolean isSrc, boolean isHref, boolean isLink) {
        ArrayList<Element> es = new ArrayList<Element>();
        for (Element e : eles) {
            es.addAll(JsoupUtil.getUrlElements(e, isSrc, isHref, isLink));
        }
        return es;
    }

    public static final String getAbsUrl(Element urlElement) {
        if (urlElement.hasAttr("src")) {
            return urlElement.attr("abs:src");
        }
        if (urlElement.hasAttr("href")) {
            return urlElement.attr("abs:href");
        }
        if (urlElement.hasAttr("link")) {
            return urlElement.attr("abs:link");
        }
        return "";
    }

    public static Document getHtml(String url) {
        Document doc = null;
        try {
            doc = Jsoup.connect((String)url).timeout(300000).get();
        }
        catch (Exception e) {
            logger.info("\u83b7\u53d6" + url + "\u6570\u636e\uff1a" + e);
        }
        return doc;
    }

    public String removeLable(Element element) {
        if (element == null) {
            return "";
        }
        element.removeAttr("class").removeAttr("id");
        element.select("p").removeAttr("class");
        element.select("script").remove();
        Pattern p = Pattern.compile("\\<!--(.+)--\\>");
        Matcher m = p.matcher(element.toString());
        return m.replaceAll("");
    }

    public static String getPostfix(String filename) {
        filename = StrUtil.substringAfterLast((String)filename, (String)".");
        filename = StrUtil.substringBefore((String)filename, (String)"?");
        filename = StrUtil.substringBefore((String)filename, (String)"/");
        filename = StrUtil.substringBefore((String)filename, (String)"\\");
        filename = StrUtil.substringBefore((String)filename, (String)"&");
        filename = StrUtil.substringBefore((String)filename, (String)"$");
        filename = StrUtil.substringBefore((String)filename, (String)"%");
        filename = StrUtil.substringBefore((String)filename, (String)"#");
        filename = StrUtil.substringBefore((String)filename, (String)"@");
        return filename;
    }

    public static void removeHref(Document doc) {
        doc.select("img").removeAttr("onclick");
        doc.select("input[type=submit]").attr("type", "button");
        doc.select("input[type=button]").removeAttr("onclick");
        doc.select("area").removeAttr("href");
    }
}

