/*
 * Decompiled with CFR 0.152.
 */
package cn.dolphin.core.html;

import cn.dolphin.core.util.StrFormatter;
import cn.dolphin.core.util.StrUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class HtmlUtil {
    private static final char[][] TEXT = new char[64][];
    private static final String regEx_script = "<script[^>]*?>[\\s\\S]*?<\\/script>";
    private static final String regEx_style = "<style[^>]*?>[\\s\\S]*?<\\/style>";
    private static final String regEx_html = "<[^>]+>";

    public static String delHTMLTag(String htmlStr) {
        Pattern p_script = Pattern.compile(regEx_script, 2);
        Matcher m_script = p_script.matcher(htmlStr);
        htmlStr = m_script.replaceAll("");
        Pattern p_style = Pattern.compile(regEx_style, 2);
        Matcher m_style = p_style.matcher(htmlStr);
        htmlStr = m_style.replaceAll("");
        Pattern p_html = Pattern.compile(regEx_html, 2);
        Matcher m_html = p_html.matcher(htmlStr);
        htmlStr = m_html.replaceAll("");
        return htmlStr.trim();
    }

    public static String changeTag(String content) {
        content = content.replaceAll("&", "&amp;");
        content = content.replaceAll("<", "&lt;");
        content = content.replaceAll(">", "&gt;");
        content = content.replaceAll("\"", "&quot;");
        content = content.replaceAll("'", "&#x27;");
        content = content.replaceAll("/", "&#x2f;");
        return content;
    }

    public static String restoreEscaped(String htmlStr) {
        if (StrUtil.isBlank((CharSequence)htmlStr)) {
            return htmlStr;
        }
        return htmlStr.replace("&#39;", "'").replace("&lt;", "<").replace("&gt;", ">").replace("&amp", "&").replace("&quot;", "\"").replace("&nbsp;", " ");
    }

    public static List<String> matchAll(String source, String element, String attr) {
        ArrayList<String> result = new ArrayList<String>();
        String reg = "<" + element + "[^<>]*?\\s" + attr + "=['\"]?(.*?)['\"]?(\\s.*?)?(/)?>";
        Matcher m = Pattern.compile(reg).matcher(source);
        while (m.find()) {
            String r = m.group(1);
            result.add(r);
        }
        return result;
    }

    public static String matchOne(String source, String element, String attr) {
        String reg = "<" + element + "[^<>]*?\\s" + attr + "=['\"]?(.*?)['\"]?(\\s.*?)?(/)?>";
        Matcher m = Pattern.compile(reg).matcher(source);
        if (m.find()) {
            String r = m.group(1);
            return r;
        }
        return null;
    }

    public static String encode(String text) {
        return HtmlUtil.encode(text, TEXT);
    }

    public static String cleanHtmlTag(String content) {
        return content.replaceAll("(<[^<]*?>)|(<[\\s]*?/[^<]*?>)|(<[^<]*?/[\\s]*?>)", "");
    }

    public static String removeHtmlTag(String content, String ... tagNames) {
        return HtmlUtil.removeHtmlTag(content, true, tagNames);
    }

    public static String unwrapHtmlTag(String content, String ... tagNames) {
        return HtmlUtil.removeHtmlTag(content, false, tagNames);
    }

    public static String removeHtmlTag(String content, boolean withTagContent, String ... tagNames) {
        String regex1 = null;
        String regex2 = null;
        for (String tagName : tagNames) {
            if (StrUtil.isBlank((CharSequence)tagName)) continue;
            tagName = tagName.trim();
            regex1 = StrFormatter.format("(?i)<{}\\s?[^>]*?/>", tagName);
            regex2 = withTagContent ? StrFormatter.format("(?i)(?s)<{}\\s*?[^>]*?>.*?</{}>", tagName, tagName) : StrFormatter.format("(?i)<{}\\s*?[^>]*?>|</{}>", tagName, tagName);
            content = content.replaceAll(regex1, "").replaceAll(regex2, "");
        }
        return content;
    }

    public static String removeHtmlAttr(String content, String ... attrs) {
        String regex = null;
        for (String attr : attrs) {
            regex = StrFormatter.format("(?i)\\s*{}=([\"']).*?\\1", attr);
            content = content.replaceAll(regex, "");
        }
        return content;
    }

    public static String removeAllHtmlAttr(String content, String ... tagNames) {
        String regex = null;
        for (String tagName : tagNames) {
            regex = StrFormatter.format("(?i)<{}[^>]*?>", tagName);
            content.replaceAll(regex, StrFormatter.format("<{}>", tagName));
        }
        return content;
    }

    private static String encode(String text, char[][] array) {
        int len;
        if (text == null || (len = text.length()) == 0) {
            return "";
        }
        StringBuilder buffer = new StringBuilder(len + (len >> 2));
        for (int i = 0; i < len; ++i) {
            char c = text.charAt(i);
            if (c < '@') {
                buffer.append(array[c]);
                continue;
            }
            buffer.append(c);
        }
        return buffer.toString();
    }

    public static String getHtmlPic(String content) {
        Matcher m = Pattern.compile(" src=\"http://.*?/[0-9]+(.jpg|.png|.gif|.bmp|.jpeg)", 2).matcher(content);
        if (m.find()) {
            String match = m.group();
            match = match.substring(6, match.length()).replace(" ", "");
            return match;
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getHtmlContent(File html) throws Exception {
        StringBuffer content = new StringBuffer();
        FileInputStream ism = null;
        InputStreamReader isr = null;
        BufferedReader bs = null;
        try {
            ism = new FileInputStream(html);
            isr = new InputStreamReader(ism);
            bs = new BufferedReader(isr);
            String info = bs.readLine();
            while (info != null) {
                content.append(info);
                info = bs.readLine();
            }
        }
        catch (IOException iOException) {
        }
        finally {
            if (ism != null) {
                ism.close();
            }
            if (isr != null) {
                isr.close();
            }
            if (bs != null) {
                bs.close();
            }
        }
        return content.toString();
    }

    static {
        for (int i = 0; i < 64; ++i) {
            HtmlUtil.TEXT[i] = new char[]{(char)i};
        }
        HtmlUtil.TEXT[39] = "&#039;".toCharArray();
        HtmlUtil.TEXT[34] = "&quot;".toCharArray();
        HtmlUtil.TEXT[38] = "&amp".toCharArray();
        HtmlUtil.TEXT[60] = "&lt;".toCharArray();
        HtmlUtil.TEXT[62] = "&gt;".toCharArray();
    }
}

