/*
 * Decompiled with CFR 0.152.
 */
package cn.dolphin.core.freemarker;

import freemarker.ext.beans.BeansWrapper;
import freemarker.ext.beans.BeansWrapperBuilder;
import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import freemarker.template.TemplateHashModel;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FreemarkerUtil {
    private static Logger logger = LoggerFactory.getLogger(FreemarkerUtil.class);
    private static boolean isInit = false;
    private static String templatePath = null;
    private static final String ENCODING = "UTF-8";
    private static Configuration freemarkerConfig = new Configuration(Configuration.VERSION_2_3_28);
    public static final String PATH_SEPARATOR = "/";
    private static final Integer TEMPLATE_LOADING_FILE = 1;
    private static final Integer TEMPLATE_LOADING_PROJECT = 2;

    public static void initFreeMarker(String applicationPath) {
        FreemarkerUtil.initFreeMarker(applicationPath, 2);
    }

    public static void initFreeMarker(String applicationPath, Integer type) {
        try {
            if (!isInit) {
                templatePath = applicationPath;
                if (TEMPLATE_LOADING_FILE == type) {
                    freemarkerConfig.setDirectoryForTemplateLoading(new File(applicationPath));
                }
                if (TEMPLATE_LOADING_PROJECT == type) {
                    freemarkerConfig.setClassForTemplateLoading(FreemarkerUtil.class, applicationPath);
                }
                freemarkerConfig.setEncoding(Locale.getDefault(), ENCODING);
                isInit = true;
            }
        }
        catch (Exception e) {
            logger.error("\u521d\u59cb\u5316FreeMarker\u914d\u7f6e\u51fa\u9519", (Throwable)e);
        }
    }

    public static TemplateHashModel useStaticPackage(String packageName) {
        try {
            BeansWrapper wrapper = new BeansWrapperBuilder(Configuration.DEFAULT_INCOMPATIBLE_IMPROVEMENTS).build();
            TemplateHashModel staticModels = wrapper.getStaticModels();
            TemplateHashModel fileStatics = (TemplateHashModel)staticModels.get(packageName);
            return fileStatics;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String crateHTML(String templateName, Map<String, Object> params) {
        String htmlText = "";
        Template template = FreemarkerUtil.getTemplate(templateName);
        try {
            htmlText = FreemarkerUtil.processTemplateIntoString(template, params);
        }
        catch (Exception e) {
            logger.error("\u8f6c\u6362Freemarker\u6a21\u677f\u4e3aHTML\u6587\u4ef6\u51fa\u9519", (Throwable)e);
        }
        return htmlText;
    }

    public static String generateString(String templateName, String templateDirectory, Map<String, Object> datas) {
        String json = "";
        try {
            freemarkerConfig.setDefaultEncoding(ENCODING);
            freemarkerConfig.setClassForTemplateLoading(FreemarkerUtil.class, templateDirectory);
            Template template = freemarkerConfig.getTemplate(templateName);
            json = FreemarkerUtil.processTemplateIntoString(template, datas);
            return json;
        }
        catch (Exception e) {
            logger.error("\u8f6c\u6362Freemarker\u6a21\u677f\u6587\u4ef6\u51fa\u9519", (Throwable)e);
            return json;
        }
    }

    public static String generateStringField(String templateName, String templateDirectory, Map<String, Object> datas) {
        String json = "";
        try {
            freemarkerConfig.setDefaultEncoding(ENCODING);
            freemarkerConfig.setClassForTemplateLoading(FreemarkerUtil.class, templateDirectory);
            Template template = freemarkerConfig.getTemplate(templateName);
            json = FreemarkerUtil.processTemplateIntoString(template, datas);
            return json;
        }
        catch (Exception e) {
            logger.error("\u8f6c\u6362Freemarker\u6a21\u677f\u6587\u4ef6\u51fa\u9519", (Throwable)e);
            return json;
        }
    }

    public static Template getTemplate(String name) {
        Template template = null;
        try {
            template = freemarkerConfig.getTemplate(name, ENCODING);
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6Freemarker\u6a21\u677f\u6587\u4ef6\u51fa\u9519", (Throwable)e);
        }
        return template;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String processTemplateIntoString(Template template, Object model) throws IOException, TemplateException {
        StringWriter result = new StringWriter();
        try {
            template.process(model, (Writer)result);
            result.flush();
        }
        catch (Exception e) {
            logger.error("\u5c06\u89e3\u6790\u4e4b\u540e\u7684\u6587\u4ef6\u5185\u5bb9\u8fd4\u56de\u5b57\u7b26\u4e32", (Throwable)e);
        }
        finally {
            try {
                if (result != null) {
                    result.close();
                }
            }
            catch (IOException e) {
                throw new RuntimeException("\u5c06\u89e3\u6790\u4e4b\u540e\u7684\u6587\u4ef6\u5185\u5bb9\u8fd4\u56de\u5b57\u7b26\u4e32", e);
            }
        }
        return result.toString();
    }

    public static void exec(Map<String, Object> model, String templateName, String storeFilePath) {
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(storeFilePath);
            Template template = FreemarkerUtil.getTemplate(templateName);
            template.process(model, (Writer)new OutputStreamWriter(fileOutputStream));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                fileOutputStream.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static void printConsole(String templateName, Map<String, Object> params) {
        System.out.println(FreemarkerUtil.crateHTML(templateName, params));
    }

    public static void main(String[] args) {
        FreemarkerUtil.initFreeMarker("/template");
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("userName", "\u6d4b\u8bd5");
        params.put("age", 12);
        FreemarkerUtil.printConsole("user.ftl", params);
    }
}

