/*
 * Decompiled with CFR 0.152.
 */
package cn.dolphin.core.file;

import cn.dolphin.core.check.CheckAssert;
import cn.dolphin.core.io.IOUtil;
import cn.dolphin.core.util.CollectionUtil;
import cn.dolphin.core.util.SystemUtil;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.FileCopyUtils;

public class FileUtil
extends FileCopyUtils {
    private static final Logger logger = LoggerFactory.getLogger(FileUtil.class);
    public static final long KB = 1024L;
    public static final long MB = 0x100000L;
    public static final long GB = 0x40000000L;
    public static final long TB = 0x10000000000L;
    public static final long PB = 0x4000000000000L;
    private static final long FILE_COPY_BUFFER_SIZE = 0x1E00000L;
    public static final File[] EMPTY_FILE_ARRAY = new File[0];
    private static final String FILE_SEPARATOR = System.getProperty("file.separator");
    private static final char UNIX_SEPARATOR = '/';
    private static final char WINDOWS_SEPARATOR = '\\';
    private static Pattern FILE_NAME_INVALID_PATTERN_WIN = Pattern.compile("[\\\\/:*?\"<>|]");
    private static final List<String> LIST_FILE_SIZE_UNIT = Arrays.asList("GB", "MB", "KB", "B");
    private static final String FOLDER_SEPARATOR = "/";
    private static final char EXTENSION_SEPARATOR = '.';

    private FileUtil() {
    }

    public static boolean isWindows() {
        return '\\' == File.separatorChar;
    }

    public static void createFile(File file) throws IOException {
        CheckAssert.check(file, (Object)"\u521b\u5efa\u7684\u6587\u4ef6\u4e0d\u80fd\u4e3a\u7a7a");
        File parent = file.getParentFile();
        if (parent != null && !parent.exists()) {
            parent.mkdirs();
        }
        if (!file.exists()) {
            file.createNewFile();
        }
    }

    public static void createFile(String path) throws IOException {
        File file = new File(path);
        FileUtil.createFile(file);
    }

    public static void createDirectory(String directory) throws IOException {
        File file = new File(directory);
        FileUtil.createDirectory(file);
    }

    public static void createDirectory(String directory, boolean cascade) throws IOException {
        File file = new File(directory);
        FileUtil.createDirectory(directory, cascade);
    }

    public static void createDirectory(File directory) throws IOException {
        FileUtil.createDirectory(directory, false);
    }

    public static void createDirectory(File directory, boolean cascade) throws IOException {
        CheckAssert.check(directory, (Object)"\u521b\u5efa\u7684\u6587\u4ef6\u5939\u4e0d\u5b58\u5728");
        if (cascade) {
            directory.mkdirs();
        } else {
            directory.mkdir();
        }
    }

    public static FileInputStream openInputStream(File file) throws IOException {
        FileUtil.checkFileRequired(file, true);
        CheckAssert.check(file.isDirectory(), (Object)String.format("\u6587\u4ef6'%s'\u662f\u4e00\u4e2a\u6587\u4ef6\u5939", file));
        CheckAssert.check(!file.canRead(), (Object)String.format("\u6587\u4ef6'%s'\u4e0d\u80fd\u8bfb,\u8bf7\u68c0\u67e5\u6743\u9650", file));
        return new FileInputStream(file);
    }

    public static FileOutputStream openOutputStream(File file) throws IOException {
        return FileUtil.openOutputStream(file, false);
    }

    public static FileOutputStream openOutputStream(File file, boolean append) throws IOException {
        FileUtil.checkFileRequired(file, true);
        CheckAssert.check(file.isDirectory(), (Object)String.format("\u6587\u4ef6'%s'\u662f\u4e00\u4e2a\u6587\u4ef6\u5939", file));
        CheckAssert.check(!file.canRead(), (Object)String.format("\u6587\u4ef6'%s'\u4e0d\u80fd\u8bfb,\u8bf7\u68c0\u67e5\u6743\u9650", file));
        return new FileOutputStream(file, append);
    }

    public static File toFile(URL url) throws URISyntaxException {
        if (url == null || !"file".equalsIgnoreCase(url.getProtocol())) {
            return null;
        }
        return new File(url.toURI());
    }

    public static File[] toFiles(URL[] urls) throws URISyntaxException {
        if (CollectionUtil.isEmpty(urls)) {
            return EMPTY_FILE_ARRAY;
        }
        File[] files = new File[urls.length];
        for (int i = 0; i < urls.length; ++i) {
            URL url = urls[i];
            if (url == null) continue;
            files[i] = FileUtil.toFile(url);
        }
        return files;
    }

    public static void copyFileToDirectory(File srcFile, File destDir) throws IOException {
        FileUtil.copyFileToDirectory(srcFile, destDir, true);
    }

    public static void copyFileToDirectory(File srcFile, File destDir, boolean preserveFileDate) throws IOException {
        FileUtil.checkFileRequired(srcFile, true);
        FileUtil.checkFileRequired(destDir, true);
        if (!destDir.isDirectory()) {
            throw new IllegalArgumentException("Destination '" + destDir + "' is not a directory");
        }
        File destFile = new File(destDir, srcFile.getName());
        FileUtil.copyFile(srcFile, destFile, preserveFileDate);
    }

    public static void copyFile(File srcFile, File destFile) throws IOException {
        FileUtil.copyFile(srcFile, destFile, true);
    }

    public static void copyFile(File srcFile, File destFile, boolean upFileDate) throws IOException {
        FileUtil.checkFileRequired(srcFile, true);
        FileUtil.checkFileRequired(destFile, false);
        CheckAssert.check(srcFile.isDirectory(), (Object)"\u539f\u59cb\u6587\u4ef6\u662f\u4e2a\u6587\u4ef6\u5939");
        if (srcFile.getCanonicalPath().equals(destFile.getCanonicalPath())) {
            throw new IOException("copy\u7684\u6587\u4ef6\u5730\u5740\u76f8\u540c");
        }
        if (destFile.exists() && !destFile.canWrite()) {
            throw new IOException(String.format("\u76ee\u6807\u6587\u4ef6 '%s' \u5b58\u5728\u4f46\u4e0d\u53ef\u5199", destFile));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void doCopyFile(File srcFile, File destFile, boolean upFileDate) throws IOException {
        FileInputStream fis = null;
        FileOutputStream fos = null;
        FileChannel input = null;
        FileChannel output = null;
        try {
            long remain;
            long bytesCopied;
            fis = new FileInputStream(srcFile);
            fos = new FileOutputStream(destFile);
            input = fis.getChannel();
            output = fos.getChannel();
            long size = input.size();
            long count = 0L;
            for (long pos = 0L; pos < size && (bytesCopied = output.transferFrom(input, pos, count = (remain = size - pos) > 0x1E00000L ? 0x1E00000L : remain)) != 0L; pos += bytesCopied) {
            }
        }
        catch (Throwable throwable) {
            IOUtil.close(output, fos, input, fis);
            throw throwable;
        }
        IOUtil.close(output, fos, input, fis);
        long srcLen = srcFile.length();
        long dstLen = destFile.length();
        if (srcLen != dstLen) {
            throw new IOException(String.format("Failed to copy full contents from '%s' to '%s' Expected length: %d Actual: %d", srcFile, destFile, srcLen, dstLen));
        }
        if (upFileDate) {
            destFile.setLastModified(srcFile.lastModified());
        }
    }

    public static void copyDirectoryToDirectory(File srcDir, File destDir) throws IOException {
        FileUtil.checkFileRequired(srcDir, true);
        CheckAssert.check(!srcDir.isDirectory(), (Object)String.format("\u6e90'%s'\u4e0d\u662f\u6587\u4ef6\u5939", srcDir));
        FileUtil.checkFileRequired(destDir, false);
        if (destDir.exists() && !destDir.isDirectory()) {
            throw new IllegalArgumentException(String.format("\u76ee\u6807'%s'\u4e0d\u662f\u6587\u4ef6\u5939", destDir));
        }
        FileUtil.copyDirectory(srcDir, new File(destDir, srcDir.getName()), true);
    }

    public static void copyDirectory(File srcDir, File destDir) throws IOException {
        FileUtil.copyDirectory(srcDir, destDir, true);
    }

    public static void copyDirectory(File srcDir, File destDir, boolean upFileDate) throws IOException {
        FileUtil.copyDirectory(srcDir, destDir, null, upFileDate);
    }

    public static void copyDirectory(File srcDir, File destDir, FileFilter filter, boolean upFileDate) throws IOException {
        FileUtil.checkFileRequired(srcDir, true);
        FileUtil.checkFileRequired(destDir, false);
        CheckAssert.check(!srcDir.isDirectory(), (Object)String.format("\u6e90'%s'\u4e0d\u662f\u6587\u4ef6\u5939", srcDir));
        if (srcDir.getCanonicalPath().equals(destDir.getCanonicalPath())) {
            throw new IOException("copy\u7684\u76ee\u5f55\u76f8\u540c");
        }
        ArrayList<String> exclusionList = null;
        if (destDir.getCanonicalPath().startsWith(srcDir.getCanonicalPath())) {
            File[] srcFiles;
            File[] fileArray = srcFiles = filter == null ? srcDir.listFiles() : srcDir.listFiles(filter);
            if (srcFiles != null && srcFiles.length > 0) {
                exclusionList = new ArrayList<String>(srcFiles.length);
                for (File srcFile : srcFiles) {
                    File copiedFile = new File(destDir, srcFile.getName());
                    exclusionList.add(copiedFile.getCanonicalPath());
                }
            }
        }
        FileUtil.doCopyDirectory(srcDir, destDir, filter, upFileDate, exclusionList);
    }

    private static void doCopyDirectory(File srcDir, File destDir, FileFilter filter, boolean upFileDate, List<String> exclusionList) throws IOException {
        File[] srcFiles = filter == null ? srcDir.listFiles() : srcDir.listFiles(filter);
        CheckAssert.check(srcFiles, (Object)String.format("\u5728'%s'\u6ca1\u6709\u53ef\u62f7\u8d1d\u7684\u76ee\u5f55\u6587\u4ef6", srcDir));
        if (destDir.exists()) {
            CheckAssert.check(!destDir.isDirectory(), (Object)String.format("\u76ee\u6807 '%s' \u5b58\u5728\u4e0d\u662f\u4e00\u4e2a\u6587\u4ef6\u5939", destDir));
        } else {
            CheckAssert.check(!destDir.mkdirs() && !destDir.isDirectory(), (Object)String.format("\u76ee\u6807 '%s' \u76ee\u5f55\u65e0\u6cd5\u521b\u5efa", destDir));
        }
        CheckAssert.check(!destDir.canWrite(), (Object)String.format("\u76ee\u6807\u76ee\u5f55'%s'\u65e0\u6cd5\u8fdb\u884c\u62f7\u8d1d", destDir));
        for (File srcFile : srcFiles) {
            File dstFile = new File(destDir, srcFile.getName());
            if (exclusionList != null && exclusionList.contains(srcFile.getCanonicalPath())) continue;
            if (srcFile.isDirectory()) {
                FileUtil.doCopyDirectory(srcFile, dstFile, filter, upFileDate, exclusionList);
                continue;
            }
            FileUtil.doCopyFile(srcFile, dstFile, upFileDate);
        }
        if (upFileDate) {
            destDir.setLastModified(srcDir.lastModified());
        }
    }

    public static void copyURLToFile(URL source, File destination) throws IOException {
        FileUtil.copyInputStreamToFile(source.openStream(), destination);
    }

    public static void copyURLToFile(URL source, File destination, int connectionTimeout, int readTimeout) throws IOException {
        URLConnection connection = source.openConnection();
        connection.setConnectTimeout(connectionTimeout);
        connection.setReadTimeout(readTimeout);
        FileUtil.copyInputStreamToFile(connection.getInputStream(), destination);
    }

    public static void copyInputStreamToFile(InputStream source, File destination) throws IOException {
        try {
            FileUtil.copyToFile(source, destination);
        }
        finally {
            IOUtil.close(source);
        }
    }

    public static void copyToFile(InputStream source, File destination) throws IOException {
        FileOutputStream output = FileUtil.openOutputStream(destination);
        try {
            IOUtil.copy(source, output);
        }
        finally {
            IOUtil.close(output);
        }
    }

    public static void deleteDirectory(File directory) throws IOException {
        if (!directory.exists()) {
            return;
        }
        if (!FileUtil.isSymlink(directory)) {
            FileUtil.cleanDirectory(directory);
        }
        CheckAssert.check(!directory.delete(), (Object)String.format("\u65e0\u6cd5\u5220\u9664\u76ee\u5f55 %s", directory));
    }

    public static void cleanDirectory(File directory) throws IOException {
        File[] files;
        for (File file : files = FileUtil.verifiedListFiles(directory)) {
            FileUtil.forceDelete(file);
        }
    }

    public static void forceDelete(File file) throws IOException {
        if (file.isDirectory()) {
            FileUtil.deleteDirectory(file);
        } else {
            boolean filePresent = file.exists();
            if (!file.delete()) {
                CheckAssert.check(!filePresent, (Object)String.format("\u6587\u4ef6'%s'\u4e0d\u5b58\u5728", file));
                throw new IOException(String.format("\u65e0\u6cd5\u5220\u9664\u6587\u4ef6:%s", file));
            }
        }
    }

    public static String readFileToString(File file) throws IOException {
        return FileUtil.readFileToString(file, Charset.defaultCharset().name());
    }

    public static byte[] readFileToByteArray(File file) throws IOException {
        FileInputStream in = null;
        try {
            in = FileUtil.openInputStream(file);
            byte[] byArray = IOUtil.toByteArray(in);
            return byArray;
        }
        finally {
            IOUtil.close(in);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readFileToString(File file, String encoding) throws IOException {
        FileInputStream in = null;
        try {
            in = FileUtil.openInputStream(file);
            String string = IOUtil.toString(in, encoding, false);
            return string;
        }
        finally {
            IOUtil.close(in);
        }
    }

    public static void writeStringToFile(File file, String data, Charset encoding) throws IOException {
        FileUtil.writeStringToFile(file, data, encoding, false);
    }

    public static void writeStringToFile(File file, String data, String encoding) throws IOException {
        FileUtil.writeStringToFile(file, data, encoding, false);
    }

    public static void writeStringToFile(File file, String data, String encoding, boolean append) throws IOException {
        FileUtil.writeStringToFile(file, data, Charset.forName(encoding), append);
    }

    public static void writeStringToFile(File file, String data) throws IOException {
        FileUtil.writeStringToFile(file, data, Charset.defaultCharset(), false);
    }

    public static void writeStringToFile(File file, String data, boolean append) throws IOException {
        FileUtil.writeStringToFile(file, data, Charset.defaultCharset(), append);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeStringToFile(File file, String data, Charset encoding, boolean append) throws IOException {
        FileOutputStream out = null;
        try {
            out = FileUtil.openOutputStream(file, append);
            IOUtil.write(data, out, encoding);
        }
        finally {
            IOUtil.close(out);
        }
    }

    public static void write(File file, CharSequence data) throws IOException {
        FileUtil.write(file, data, Charset.defaultCharset(), false);
    }

    public static void write(File file, CharSequence data, boolean append) throws IOException {
        FileUtil.write(file, data, Charset.defaultCharset(), append);
    }

    public static void write(File file, CharSequence data, Charset encoding) throws IOException {
        FileUtil.write(file, data, encoding, false);
    }

    public static void write(File file, CharSequence data, String encoding) throws IOException {
        FileUtil.write(file, data, encoding, false);
    }

    public static void write(File file, CharSequence data, String encoding, boolean append) throws IOException {
        FileUtil.write(file, data, Charset.forName(encoding), append);
    }

    public static void write(File file, CharSequence data, Charset encoding, boolean append) throws IOException {
        String str = data == null ? null : data.toString();
        FileUtil.writeStringToFile(file, str, encoding, append);
    }

    public static void writeByteArrayToFile(File file, byte[] data) throws IOException {
        FileUtil.writeByteArrayToFile(file, data, false);
    }

    public static void writeByteArrayToFile(File file, byte[] data, boolean append) throws IOException {
        FileUtil.writeByteArrayToFile(file, data, 0, data.length, append);
    }

    public static void writeByteArrayToFile(File file, byte[] data, int off, int len) throws IOException {
        FileUtil.writeByteArrayToFile(file, data, off, len, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeByteArrayToFile(File file, byte[] data, int off, int len, boolean append) throws IOException {
        FileOutputStream out = null;
        try {
            out = FileUtil.openOutputStream(file, append);
            ((OutputStream)out).write(data, off, len);
        }
        finally {
            IOUtil.close(out);
        }
    }

    public static void moveDirectory(File srcDir, File destDir) throws IOException {
        CheckAssert.check(srcDir, (Object)"\u6e90\u6587\u4ef6\u5939\u4e0d\u80fd\u4e3a\u7a7a");
        CheckAssert.check(destDir, (Object)"\u76ee\u6807\u6587\u4ef6\u5939\u4e0d\u80fd\u4e3a\u7a7a");
        CheckAssert.check(!srcDir.exists(), (Object)String.format("\u6e90\u6587\u4ef6\u5939%s\u4e0d\u5b58\u5728", srcDir));
        CheckAssert.check(!srcDir.isDirectory(), (Object)String.format("\u6e90%s\u4e0d\u662f\u4e00\u4e2a\u6587\u4ef6\u5939", srcDir));
        CheckAssert.check(destDir.exists(), (Object)String.format("\u76ee\u6807\u6e90\u6587\u4ef6\u5939%s\u5df2\u5b58\u5728", destDir));
        boolean rename = srcDir.renameTo(destDir);
        if (!rename) {
            if (destDir.getCanonicalPath().startsWith(srcDir.getCanonicalPath() + File.separator)) {
                throw new IOException(String.format("\u65e0\u6cd5\u79fb\u52a8\u6587\u4ef6\u5939:\u6e90 %s \u662f\u5b83\u7684\u5b50\u76ee\u5f55: %s", srcDir, destDir));
            }
            FileUtil.copyDirectory(srcDir, destDir);
            FileUtil.deleteDirectory(srcDir);
            CheckAssert.check(srcDir.exists(), (Object)String.format("\u79fb\u52a8\u540e\u5220\u9664\u6e90\u6587\u4ef6\u5939'%s'\u5931\u8d25", srcDir));
        }
    }

    public static void moveDirectoryToDirectory(File src, File destDir, boolean createDestDir) throws IOException {
        CheckAssert.check(src, (Object)"\u6e90\u6587\u4ef6\u5939\u4e0d\u80fd\u4e3a\u7a7a");
        CheckAssert.check(destDir, (Object)"\u76ee\u6807\u6587\u4ef6\u5939\u4e0d\u80fd\u4e3a\u7a7a");
        if (!destDir.exists() && createDestDir) {
            destDir.mkdirs();
        }
        CheckAssert.check(!destDir.exists(), (Object)String.format("\u76ee\u6807\u6587\u4ef6\u5939%s\u4e0d\u5b58\u5728", destDir));
        CheckAssert.check(!destDir.isDirectory(), (Object)String.format("\u76ee\u6807\u6e90%s\u4e0d\u662f\u4e00\u4e2a\u6587\u4ef6\u5939", destDir));
        FileUtil.moveDirectory(src, new File(destDir, src.getName()));
    }

    public static void moveFile(File srcFile, File destFile) throws IOException {
        CheckAssert.check(srcFile, (Object)"\u6e90\u6587\u4ef6\u4e0d\u80fd\u4e3a\u7a7a");
        CheckAssert.check(destFile, (Object)"\u76ee\u6807\u6587\u4ef6\u4e0d\u80fd\u4e3a\u7a7a");
        CheckAssert.check(!srcFile.exists(), (Object)String.format("\u6e90\u6587\u4ef6'%s'\u4e0d\u5b58\u5728", srcFile));
        CheckAssert.check(srcFile.isDirectory(), (Object)String.format("\u6e90\u6587\u4ef6'%s'\u662f\u4e00\u4e2a\u6587\u4ef6\u5939", srcFile));
        CheckAssert.check(destFile.exists(), (Object)String.format("\u76ee\u6807\u6587\u4ef6'%s'\u5df2\u5b58\u5728", destFile));
        CheckAssert.check(destFile.isDirectory(), (Object)String.format("\u76ee\u6807\u6587\u4ef6'%s'\u662f\u4e00\u4e2a\u6587\u4ef6\u5939", destFile));
        boolean rename = srcFile.renameTo(destFile);
        if (!rename) {
            FileUtil.copyFile(srcFile, destFile);
            if (!srcFile.delete()) {
                FileUtil.delete(destFile);
                throw new IOException("\u5220\u9664\u6e90\u6587\u4ef6 '" + srcFile + "' \u5931\u8d25\u3001\u5220\u9664\u62f7\u8d1d\u7684\u6587\u4ef6 '" + destFile + "'");
            }
        }
    }

    public static void moveFileToDirectory(File srcFile, File destDir, boolean createDestDir) throws IOException {
        CheckAssert.check(srcFile, (Object)"\u6e90\u6587\u4ef6\u4e0d\u80fd\u4e3a\u7a7a");
        CheckAssert.check(destDir, (Object)"\u76ee\u6807\u6587\u4ef6\u4e0d\u80fd\u4e3a\u7a7a");
        if (!destDir.exists() && createDestDir) {
            destDir.mkdirs();
        }
        CheckAssert.check(!destDir.exists(), (Object)"\u76ee\u6807\u6587\u4ef6\u6ca1\u6709\u521b\u5efa\u3001\u8bf7\u8bbe\u7f6ecreateDestDir\u53c2\u6570\u4e3aTrue");
        CheckAssert.check(!destDir.isDirectory(), (Object)String.format("\u76ee\u6807\u6587\u4ef6'%s'\u4e0d\u662f\u4e00\u4e2a\u6587\u4ef6\u5939", destDir));
        FileUtil.moveFile(srcFile, new File(destDir, srcFile.getName()));
    }

    public static void moveToDirectory(File src, File destDir, boolean createDestDir) throws IOException {
        CheckAssert.check(src, (Object)"\u6e90\u6587\u4ef6\u4e0d\u80fd\u4e3a\u7a7a");
        CheckAssert.check(destDir, (Object)"\u76ee\u6807\u6587\u4ef6\u4e0d\u80fd\u4e3a\u7a7a");
        CheckAssert.check(!src.exists(), (Object)String.format("\u6e90\u6587\u4ef6'%s'\u4e0d\u5b58\u5728", src));
        if (src.isDirectory()) {
            FileUtil.moveDirectoryToDirectory(src, destDir, createDestDir);
        } else {
            FileUtil.moveFileToDirectory(src, destDir, createDestDir);
        }
    }

    public static boolean delete(File file) {
        if (file == null) {
            return false;
        }
        try {
            if (file.isDirectory()) {
                FileUtil.cleanDirectory(file);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            return file.delete();
        }
        catch (Exception ignored) {
            return false;
        }
    }

    private static File[] verifiedListFiles(File directory) throws IOException {
        CheckAssert.check(!directory.exists(), (Object)String.format("%s \u76ee\u5f55\u4e0d\u5b58\u5728", directory));
        CheckAssert.check(!directory.isDirectory(), (Object)String.format("%s \u4e0d\u662f\u4e00\u4e2a\u76ee\u5f55", directory));
        File[] files = directory.listFiles();
        CheckAssert.check(files, (Object)String.format("\u6ca1\u6709\u627e\u5230\u76ee\u5f55\u4e0b\u7684\u4e1c\u897f %s", directory));
        return files;
    }

    public static boolean isSymlink(File file) throws IOException {
        return SystemUtil.isSymLink(file);
    }

    private static void checkFileRequired(File file, boolean checkNotExists) {
        CheckAssert.check(file, (Object)"\u6587\u4ef6\u4e0d\u5b58\u5728");
        if (checkNotExists) {
            CheckAssert.check(!file.exists(), (Object)String.format("\u6587\u4ef6'%s'\u4e0d\u5b58\u5728", file));
        }
    }

    public static boolean renameFolder(String oldName, String newName, String path) {
        File oldFile = new File(path + FILE_SEPARATOR + oldName);
        return oldFile.renameTo(new File(path + FILE_SEPARATOR + newName));
    }

    public static boolean deleteFiles(String dirPath) {
        String[] fileNames;
        File file = new File(dirPath);
        boolean success = Boolean.TRUE;
        if (!file.isDirectory()) {
            if (!file.delete()) {
                success = Boolean.FALSE;
            }
            return success;
        }
        for (String fileName : fileNames = file.list()) {
            if (FileUtil.deleteFiles(dirPath + FILE_SEPARATOR + fileName)) continue;
            success = Boolean.FALSE;
        }
        if (!file.delete()) {
            success = Boolean.FALSE;
        }
        return success;
    }

    public static String getFileExt(File file) {
        if (!file.isFile() || !file.exists()) {
            return "";
        }
        int i = file.getName().lastIndexOf(".");
        if (i == -1) {
            return "";
        }
        return file.getName().substring(i);
    }

    public static String getFileExt(String fileName) {
        int i;
        if (StringUtils.isEmpty((CharSequence)fileName)) {
            logger.error("given fileName '{}' is null!", (Object)fileName);
        }
        if ((i = fileName.lastIndexOf(".")) == -1) {
            return "";
        }
        return fileName.substring(i);
    }

    public static String getFileName(String fileName) {
        int i;
        if (StringUtils.isEmpty((CharSequence)fileName)) {
            logger.error("given fileName '{}' is null!", (Object)fileName);
        }
        if ((i = fileName.lastIndexOf(".")) == -1) {
            return fileName;
        }
        return fileName.substring(0, i);
    }

    public static String getFileName(File file) {
        if (!file.isFile() || !file.exists()) {
            return "";
        }
        return FileUtil.getFileName(file.getName());
    }

    public static byte[] getFileByte(File file) throws Exception {
        if (!(file.exists() && file.isFile() && file.canRead())) {
            logger.error("given path '{}' is not a file, maybe a folder! or it can not read!", (Object)file);
            return null;
        }
        FileInputStream fis = FileUtil.openInputStream(file);
        if (fis == null) {
            logger.error("the FileInputStream is null!");
        }
        return IOUtils.toByteArray((InputStream)fis);
    }

    public static byte[] getFileByte(String filePath) throws Exception {
        if (StringUtils.isEmpty((CharSequence)filePath)) {
            logger.error("given filePath is null!");
            return null;
        }
        File file = new File(filePath);
        return FileUtil.getFileByte(file);
    }

    public static char[] getFileChar(File file) throws Exception {
        if (!(file.exists() && file.isFile() && file.canRead())) {
            logger.error("given path '{}' is not a file, maybe a folder! or it can not read!", (Object)file);
            return null;
        }
        FileInputStream fis = FileUtil.openInputStream(file);
        if (fis == null) {
            logger.error("the FileInputStream is null!");
        }
        return IOUtils.toCharArray((InputStream)fis);
    }

    public static char[] getFileChar(String filePath) throws Exception {
        if (StringUtils.isEmpty((CharSequence)filePath)) {
            logger.error("given filePath is null!");
            return null;
        }
        File file = new File(filePath);
        return FileUtil.getFileChar(file);
    }

    public static String readableFileSize(File file) {
        return FileUtil.readableFileSize(file.length());
    }

    public static String readableFileSize(long size) {
        if (size <= 0L) {
            return "0";
        }
        String[] units = new String[]{"B", "kB", "MB", "GB", "TB", "EB"};
        int digitGroups = (int)(Math.log10(size) / Math.log10(1024.0));
        return new DecimalFormat("#,##0.##").format((double)size / Math.pow(1024.0, digitGroups)) + " " + units[digitGroups];
    }

    public static List<String> readLines(File file, String encoding) throws Exception {
        return FileUtil.readLines(FileUtil.openInputStream(file), encoding);
    }

    public static List<String> readLines(File file) throws Exception {
        return FileUtil.readLines(file, null);
    }

    public static List<String> readLines(InputStream in, String encoding) throws Exception {
        if (in == null) {
            return Collections.EMPTY_LIST;
        }
        return IOUtils.readLines((InputStream)in, (String)encoding);
    }

    public static List<String> readLines(InputStream in) throws Exception {
        return FileUtil.readLines(in, null);
    }

    public static byte[] Tobyte(File tradeFile) {
        byte[] buffer = null;
        try {
            int n;
            FileInputStream fis = new FileInputStream(tradeFile);
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            byte[] b = new byte[1024];
            while ((n = fis.read(b)) != -1) {
                bos.write(b, 0, n);
            }
            fis.close();
            bos.close();
            buffer = bos.toByteArray();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return buffer;
    }
}

