/*
 * Decompiled with CFR 0.152.
 */
package cn.dolphin.core.file;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileUploadUtil {
    private static final Logger log = LoggerFactory.getLogger(FileUploadUtil.class);
    private static final String[] FILE_EXTS = new String[]{"JPG", "PNG", "GIF"};
    private static final byte[][] FILE_MAGS = new byte[][]{{-1, -40, -1, -32}, {-119, 80, 78, 71}, {71, 73, 70, 56}};

    public static boolean byteUpload(byte[] data, String path, String fileName) {
        boolean flag = false;
        File file = new File(path);
        if (!file.exists()) {
            file.mkdirs();
        }
        file = new File(path + fileName);
        try {
            FileOutputStream os = new FileOutputStream(file);
            ((OutputStream)os).write(data);
            ((OutputStream)os).close();
            flag = true;
        }
        catch (Exception e) {
            log.error("\u4e0a\u4f20\u56fe\u7247\u5931\u8d25 ----", (Throwable)e);
        }
        return flag;
    }

    public static String getFileType(byte[] contents) {
        for (int i = 0; i < FILE_MAGS.length; ++i) {
            byte[] mag = FILE_MAGS[i];
            if (contents.length < mag.length || !Arrays.equals(Arrays.copyOf(contents, mag.length), mag)) continue;
            return FILE_EXTS[i];
        }
        return null;
    }

    public static boolean validateFileType(String fileType) {
        for (String type : FILE_EXTS) {
            if (!type.equalsIgnoreCase(fileType)) continue;
            return true;
        }
        return false;
    }
}

