/*
 * Decompiled with CFR 0.152.
 */
package cn.dolphin.core.encrypt.factory;

import cn.dolphin.core.encrypt.factory.CryptoFactory;
import java.nio.charset.Charset;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.InvalidKeySpecException;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESKeySpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DesCryptoFactory
implements CryptoFactory {
    private static final Logger log = LoggerFactory.getLogger(DesCryptoFactory.class);
    private volatile Cipher encryptCipher = null;
    private volatile Cipher decryptCipher = null;
    private static final Charset DEFAULT_KEY_CHARSET = Charset.forName("UTF-8");
    private static final String DES = "DES";

    @Override
    public byte[] encrypt(String key, byte[] content) {
        try {
            return this.encryptCipher(key).doFinal(content);
        }
        catch (NoSuchAlgorithmException | InvalidKeySpecException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
            log.error("[DES \u52a0\u5bc6\u5931\u8d25", (Throwable)e);
        }
        catch (InvalidKeyException e) {
            log.error("[DES \u52a0\u5bc6\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5 key \u7684\u957f\u5ea6\u662f\u5426\u7b26\u54088\u7684\u500d\u6570]", (Throwable)e);
        }
        return null;
    }

    @Override
    public byte[] decrypt(String key, byte[] content) throws RuntimeException {
        try {
            return this.decryptCipher(key).doFinal(content);
        }
        catch (NoSuchAlgorithmException | InvalidKeySpecException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
            log.error("[DES \u89e3\u5bc6\u5931\u8d25", (Throwable)e);
        }
        catch (InvalidKeyException e) {
            log.error("[DES \u89e3\u5bc6\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5 key \u7684\u957f\u5ea6\u662f\u5426\u7b26\u54088\u7684\u500d\u6570]", (Throwable)e);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Cipher encryptCipher(String key) throws NoSuchAlgorithmException, InvalidKeySpecException, NoSuchPaddingException, InvalidKeyException {
        if (this.encryptCipher != null) return this.encryptCipher;
        Class<DesCryptoFactory> clazz = DesCryptoFactory.class;
        synchronized (DesCryptoFactory.class) {
            if (this.encryptCipher != null) return this.encryptCipher;
            SecureRandom random = new SecureRandom();
            DESKeySpec desKey = new DESKeySpec(key.getBytes(DEFAULT_KEY_CHARSET));
            SecretKeyFactory keyFactory = SecretKeyFactory.getInstance(DES);
            Cipher cipher = Cipher.getInstance(DES);
            cipher.init(1, (Key)keyFactory.generateSecret(desKey), random);
            this.encryptCipher = cipher;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return this.encryptCipher;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Cipher decryptCipher(String key) throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, InvalidKeySpecException {
        if (this.decryptCipher != null) return this.decryptCipher;
        Class<DesCryptoFactory> clazz = DesCryptoFactory.class;
        synchronized (DesCryptoFactory.class) {
            if (this.decryptCipher != null) return this.decryptCipher;
            SecureRandom random = new SecureRandom();
            DESKeySpec desKey = new DESKeySpec(key.getBytes(DEFAULT_KEY_CHARSET));
            SecretKeyFactory keyFactory = SecretKeyFactory.getInstance(DES);
            Cipher cipher = Cipher.getInstance(DES);
            cipher.init(2, (Key)keyFactory.generateSecret(desKey), random);
            this.decryptCipher = cipher;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return this.decryptCipher;
        }
    }
}

