/*
 * Decompiled with CFR 0.152.
 */
package cn.dolphin.core.encrypt.factory;

import cn.dolphin.core.encrypt.factory.CryptoFactory;
import java.nio.charset.Charset;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.KeyGenerator;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AesCryptoFactory
implements CryptoFactory {
    private static final Logger log = LoggerFactory.getLogger(AesCryptoFactory.class);
    private volatile Cipher encryptCipher = null;
    private volatile Cipher decryptCipher = null;
    private static final Charset DEFAULT_KEY_CHARSET = Charset.forName("UTF-8");
    private static final String AES = "AES";
    private static final String ALGORITHM = "SHA1PRNG";

    @Override
    public byte[] encrypt(String key, byte[] content) {
        try {
            return this.encryptCipher(key).doFinal(content);
        }
        catch (Exception e) {
            log.error("[AES \u52a0\u5bc6\u5931\u8d25]", (Throwable)e);
            return null;
        }
    }

    @Override
    public byte[] decrypt(String key, byte[] content) {
        try {
            return this.decryptCipher(key).doFinal(content);
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
            log.error("[AES \u89e3\u5bc6\u5931\u8d25]", (Throwable)e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Cipher encryptCipher(String key) throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException {
        if (this.encryptCipher != null) return this.encryptCipher;
        Class<AesCryptoFactory> clazz = AesCryptoFactory.class;
        synchronized (AesCryptoFactory.class) {
            if (this.encryptCipher != null) return this.encryptCipher;
            KeyGenerator generator = KeyGenerator.getInstance(AES);
            SecureRandom random = SecureRandom.getInstance(ALGORITHM);
            random.setSeed(key.getBytes(DEFAULT_KEY_CHARSET));
            generator.init(128, random);
            SecretKey secretKey = generator.generateKey();
            byte[] enCodeFormat = secretKey.getEncoded();
            SecretKeySpec spec = new SecretKeySpec(enCodeFormat, AES);
            Cipher cipher = Cipher.getInstance(AES);
            cipher.init(1, spec);
            this.encryptCipher = cipher;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return this.encryptCipher;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Cipher decryptCipher(String key) throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException {
        if (this.decryptCipher != null) return this.decryptCipher;
        Class<AesCryptoFactory> clazz = AesCryptoFactory.class;
        synchronized (AesCryptoFactory.class) {
            if (this.decryptCipher != null) return this.decryptCipher;
            KeyGenerator generator = KeyGenerator.getInstance(AES);
            SecureRandom random = SecureRandom.getInstance(ALGORITHM);
            random.setSeed(key.getBytes(DEFAULT_KEY_CHARSET));
            generator.init(128, random);
            SecretKey secretKey = generator.generateKey();
            byte[] enCodeFormat = secretKey.getEncoded();
            SecretKeySpec spec = new SecretKeySpec(enCodeFormat, AES);
            Cipher cipher = Cipher.getInstance(AES);
            cipher.init(2, spec);
            this.decryptCipher = cipher;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return this.decryptCipher;
        }
    }
}

