/*
 * Decompiled with CFR 0.152.
 */
package cn.dolphin.core.encrypt;

import cn.dolphin.core.encrypt.CryptoType;
import cn.dolphin.core.encrypt.factory.AesCryptoFactory;
import cn.dolphin.core.encrypt.factory.CryptoFactory;
import cn.dolphin.core.encrypt.factory.DesCryptoFactory;
import cn.dolphin.core.encrypt.factory.RsaCryptoFactory;
import cn.dolphin.core.sec.HexUtil;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import org.apache.commons.io.IOUtils;

public class CryptoUtil {
    private static CryptoFactory getFactory(CryptoType type) {
        switch (type) {
            case AES: {
                return LazyCryptoHolder.AES_CRYPTO_FACTORY;
            }
            case DES: {
                return LazyCryptoHolder.DES_CRYPTO_FACTORY;
            }
            case RSA: {
                return LazyCryptoHolder.RSA_CRYPTO_FACTORY;
            }
        }
        throw new NullPointerException("\u672a\u68c0\u6d4b\u5230\u52a0\u5bc6");
    }

    public static InputStream encrypt(CryptoType type, String key, InputStream inputStream) throws IOException {
        CryptoFactory factory = CryptoUtil.getFactory(type);
        byte[] bytes = IOUtils.toByteArray((InputStream)inputStream);
        return new ByteArrayInputStream(factory.encrypt(key, bytes));
    }

    public static InputStream decrypt(CryptoType type, String key, InputStream inputStream) throws IOException {
        CryptoFactory factory = CryptoUtil.getFactory(type);
        byte[] bytes = IOUtils.toByteArray((InputStream)inputStream);
        byte[] decrypt = factory.decrypt(key, bytes);
        return new ByteArrayInputStream(decrypt);
    }

    public static byte[] encrypt(CryptoType type, String key, byte[] content) {
        CryptoFactory factory = CryptoUtil.getFactory(type);
        return factory.encrypt(key, content);
    }

    public static byte[] decrypt(CryptoType type, String key, byte[] content) {
        CryptoFactory factory = CryptoUtil.getFactory(type);
        return factory.decrypt(key, content);
    }

    public static String encryptToString(CryptoType type, String key, String content, Charset charset) {
        return HexUtil.toHexString(CryptoUtil.encrypt(type, key, content.getBytes(charset)));
    }

    public static String decryptToString(CryptoType type, String key, String content, Charset charset) {
        byte[] bytes = HexUtil.fromHexString(content);
        byte[] decrypt = CryptoUtil.decrypt(type, key, bytes);
        return new String(decrypt, charset);
    }

    private static class LazyCryptoHolder {
        private static final CryptoFactory AES_CRYPTO_FACTORY = new AesCryptoFactory();
        private static final CryptoFactory DES_CRYPTO_FACTORY = new DesCryptoFactory();
        private static final CryptoFactory RSA_CRYPTO_FACTORY = new RsaCryptoFactory();

        private LazyCryptoHolder() {
        }
    }
}

