/*
 * Decompiled with CFR 0.152.
 */
package cn.dolphin.core.dialect.util;

import cn.dolphin.core.dialect.Dialect;
import cn.dolphin.core.dialect.common.MySQLDialect;
import cn.dolphin.core.dialect.common.OracleDialect;
import cn.dolphin.core.util.StrUtil;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import javax.sql.DataSource;
import org.springframework.jdbc.core.JdbcTemplate;

public class DialectUtil {
    private static final Map<Object, Dialect> map = new HashMap<Object, Dialect>();

    public static Dialect getDialect(String dbType) throws Exception {
        try {
            Dialect dialect = map.get(dbType);
            if (dialect != null) {
                return dialect;
            }
            if (dbType.equals("oracle")) {
                dialect = new OracleDialect();
                map.put(dbType, dialect);
            } else if (dbType.equals("mysql")) {
                dialect = new MySQLDialect();
                map.put(dbType, dialect);
            } else {
                throw new Exception("\u6ca1\u6709\u8bbe\u7f6e\u5408\u9002\u7684\u6570\u636e\u5e93\u7c7b\u578b");
            }
            return dialect;
        }
        catch (Exception e) {
            throw new Exception("\u6ca1\u6709\u8bbe\u7f6e\u5408\u9002\u7684\u6570\u636e\u5e93\u7c7b\u578b");
        }
    }

    public static final Dialect getDialect(JdbcTemplate jt) {
        Dialect dialect = map.get(jt);
        if (dialect != null) {
            return dialect;
        }
        try {
            dialect = DialectUtil.getDialect(jt.getDataSource().getConnection());
            map.put(jt, dialect);
            return dialect;
        }
        catch (SQLException e) {
            throw new RuntimeException("Can't get the database product name .");
        }
    }

    public static Dialect getDialect(DataSource dataSource) {
        Dialect dialect = map.get(dataSource);
        if (dialect != null) {
            return dialect;
        }
        try {
            dialect = DialectUtil.getDialect(dataSource.getConnection());
            map.put(dataSource, dialect);
            return dialect;
        }
        catch (SQLException e) {
            throw new RuntimeException("Can't get the database product name .");
        }
    }

    public static Dialect getDialect(Connection conn) {
        String name = null;
        try {
            Dialect dialect;
            name = conn.getMetaData().getDatabaseProductName();
            if (StrUtil.isEmpty((CharSequence)name)) {
                throw new RuntimeException("Get dialect error.");
            }
            if ("oracle".equals(name.toLowerCase())) {
                dialect = new OracleDialect();
            } else if ("mysql".equals(name.toLowerCase())) {
                dialect = new MySQLDialect();
            } else {
                throw new Exception("\u6ca1\u6709\u8bbe\u7f6e\u5408\u9002\u7684\u6570\u636e\u5e93\u7c7b\u578b");
            }
            return dialect;
        }
        catch (Exception e) {
            throw new RuntimeException("Can't get the database product name .");
        }
    }
}

