/*
 * Decompiled with CFR 0.152.
 */
package cn.dolphin.core.db;

import cn.dolphin.core.bean.BaseModel;
import cn.dolphin.core.db.IEntityDao;
import cn.dolphin.core.map.MapUtil;
import cn.dolphin.core.mybatis.BaseMyBatisDao;
import cn.dolphin.core.mybatis.IbatisSql;
import cn.dolphin.core.mybatis.SqlMapper;
import cn.dolphin.core.page.PageBean;
import cn.dolphin.core.page.PageList;
import cn.dolphin.core.page.QueryFilter;
import cn.dolphin.core.util.StrUtil;
import cn.dolphin.core.util.SystemClock;
import java.io.Serializable;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.annotation.Resource;
import org.apache.ibatis.session.ExecutorType;
import org.apache.ibatis.session.RowBounds;
import org.apache.ibatis.session.SqlSession;
import org.apache.ibatis.session.SqlSessionFactory;
import org.mybatis.spring.SqlSessionUtils;
import org.springframework.dao.support.PersistenceExceptionTranslator;

public abstract class GenericDao<E, PK extends Serializable>
extends BaseMyBatisDao<E, PK>
implements IEntityDao<E, PK> {
    @Resource
    Properties configproperties;

    public abstract Class<?> getEntityClass();

    public abstract SqlMapper sqlMapper();

    protected String getDbType() {
        return this.configproperties.getProperty("jdbc.dbType");
    }

    private String getIbatisMapperNamespace() {
        return this.getEntityClass().getName();
    }

    @Override
    public E getMyBatisById(PK primaryKey) throws Exception {
        String getStatement = this.getIbatisMapperNamespace() + ".getById";
        Object object = this.getSqlSessionTemplate().selectOne(getStatement, primaryKey);
        return (E)object;
    }

    @Override
    public E getMyBatisUnique(String sqlKey, Object params) throws Exception {
        String getStatement = this.getIbatisMapperNamespace() + "." + sqlKey;
        Object object = this.getSqlSessionTemplate().selectOne(getStatement, params);
        return (E)object;
    }

    public Object getMyBatisOne(String sqlKey, Object params) throws Exception {
        String getStatement = this.getIbatisMapperNamespace() + "." + sqlKey;
        Object object = this.getSqlSessionTemplate().selectOne(getStatement, params);
        return object;
    }

    public List<E> getMyBatisBySqlKey(String sqlKey, QueryFilter queryFilter) throws Exception {
        List list = new ArrayList();
        list = null == queryFilter ? this.getMyBatisBySqlKey(sqlKey) : (queryFilter.getPageBean() == null ? this.getMyBatisBySqlKey(sqlKey, queryFilter.getFilters()) : this.getMyBatisBySqlKey(sqlKey, queryFilter.getFilters(), queryFilter.getPageBean()));
        return list;
    }

    public List<E> getMyBatisBySqlKey(String sqlKey, Object params, PageBean pageBean) throws Exception {
        return this.getMyBatisList(sqlKey, params, pageBean);
    }

    public List getMyBatisBySqlKeyGenericity(String sqlKey, Object params) throws Exception {
        String statement = this.getIbatisMapperNamespace() + "." + sqlKey;
        return this.getSqlSessionTemplate().selectList(statement, params);
    }

    public List getMyBatisBySqlKeyGenericity(String sqlKey) throws Exception {
        String statement = this.getIbatisMapperNamespace() + "." + sqlKey;
        return this.getSqlSessionTemplate().selectList(statement);
    }

    public <T> List<T> getMyBatisBySqlKeyGenericity(String sqlKey, Object params, PageBean pageBean) throws Exception {
        if (pageBean == null) {
            return this.getMyBatisBySqlKeyGenericity(sqlKey, params);
        }
        String statementName = this.getIbatisMapperNamespace() + "." + sqlKey;
        HashMap filters = new HashMap();
        if (params != null && params instanceof Map) {
            filters.putAll((Map)params);
        }
        if (pageBean.isShowTotal()) {
            int totalCount;
            IbatisSql ibatisSql = this.getIbatisSql(statementName, MapUtil.isNotEmpty(filters) ? filters : params);
            if (pageBean.isDistinct()) {
                if (StrUtil.isEmpty((CharSequence)this.primaryKey)) {
                    totalCount = (Integer)this.getJdbcTemplate().queryForObject(ibatisSql.getCountSqlDistinct(), ibatisSql.getParameters(), Integer.class);
                    pageBean.setTotalCount(totalCount);
                } else {
                    totalCount = (Integer)this.getJdbcTemplate().queryForObject(ibatisSql.getCountSqlDistinct(this.primaryKey), ibatisSql.getParameters(), Integer.class);
                    pageBean.setTotalCount(totalCount);
                }
            } else if (StrUtil.isEmpty((CharSequence)this.primaryKey)) {
                totalCount = (Integer)this.getJdbcTemplate().queryForObject(ibatisSql.getCountSql(), ibatisSql.getParameters(), Integer.class);
                pageBean.setTotalCount(totalCount);
            } else {
                totalCount = (Integer)this.getJdbcTemplate().queryForObject(ibatisSql.getCountSql(this.primaryKey), ibatisSql.getParameters(), Integer.class);
                pageBean.setTotalCount(totalCount);
            }
        }
        RowBounds rowBounds = new RowBounds(pageBean.getFirst(), pageBean.getPageSize());
        List list = this.getSqlSessionTemplate().selectList(statementName, MapUtil.isNotEmpty(filters) ? filters : params, rowBounds);
        PageList pageList = new PageList();
        pageList.addAll(list);
        pageList.setPageBean(pageBean);
        return pageList;
    }

    public List<E> getMyBatisBySqlKey(String sqlKey, Object params) throws Exception {
        String statement = this.getIbatisMapperNamespace() + "." + sqlKey;
        return this.getSqlSessionTemplate().selectList(statement, params);
    }

    public List<E> getMyBatisBySqlKey(String sqlKey) throws Exception {
        String statement = this.getIbatisMapperNamespace() + "." + sqlKey;
        List list = this.getSqlSessionTemplate().selectList(statement);
        return list;
    }

    @Override
    public int deleteMyBatisById(PK id) throws Exception {
        String delStatement = this.getIbatisMapperNamespace() + ".delById";
        int affectCount = this.getSqlSessionTemplate().delete(delStatement, id);
        return affectCount;
    }

    public int deleteMyBatisBySqlKey(String sqlKey, Object params) throws Exception {
        String delStatement = this.getIbatisMapperNamespace() + "." + sqlKey;
        int affectCount = this.getSqlSessionTemplate().delete(delStatement, params);
        return affectCount;
    }

    @Override
    public void saveMyBatis(E entity) throws Exception {
        BaseModel baseModel;
        String addStatement = this.getIbatisMapperNamespace() + ".add";
        if (entity instanceof BaseModel && (baseModel = (BaseModel)entity).getCreatedAt() == null) {
            baseModel.setCreatedAt(SystemClock.nowDate());
        }
        this.getSqlSessionTemplate().insert(addStatement, entity);
    }

    public int saveMyBatis(String sqlKey, Object params) throws Exception {
        String addStatement = this.getIbatisMapperNamespace() + "." + sqlKey;
        int affectCount = this.getSqlSessionTemplate().insert(addStatement, params);
        return affectCount;
    }

    @Override
    public int updateMyBatis(E entity) throws Exception {
        String updStatement = this.getIbatisMapperNamespace() + ".update";
        if (entity instanceof BaseModel) {
            BaseModel baseModel = (BaseModel)entity;
            baseModel.setUpdatedAt(SystemClock.nowDate());
        }
        int affectCount = this.getSqlSessionTemplate().update(updStatement, entity);
        return affectCount;
    }

    public int updateMyBatis(String sqlKey, Object params) throws Exception {
        String updStatement = this.getIbatisMapperNamespace() + "." + sqlKey;
        int affectCount = this.getSqlSessionTemplate().update(updStatement, params);
        return affectCount;
    }

    public Object batchSaveMyBatis(List objs) throws Exception {
        String addStatement = this.getIbatisMapperNamespace() + ".batchSave";
        return this.getSqlSessionTemplate().insert(addStatement, (Object)objs);
    }

    public Object batchSaveMyBatis(String sqlKey, List objs) throws Exception {
        String addStatement = this.getIbatisMapperNamespace() + "." + sqlKey;
        return this.getSqlSessionTemplate().insert(addStatement, (Object)objs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void batchUpdateMyBatis(String sqlKey, List objs) throws Exception {
        String addStatement = this.getIbatisMapperNamespace() + "." + sqlKey;
        SqlSessionFactory sqlSessionFactory = this.getSqlSessionTemplate().getSqlSessionFactory();
        try (SqlSession sqlSession = sqlSessionFactory.openSession(ExecutorType.BATCH, false);){
            if (objs != null) {
                int size = objs.size();
                for (int i = 0; i < size; ++i) {
                    sqlSession.update(addStatement, objs.get(i));
                }
                sqlSession.flushStatements();
                sqlSession.commit();
                sqlSession.clearCache();
            }
        }
    }

    public Object batchDeleteMyBatis(String sqlKey, List objs) throws Exception {
        String delStatement = this.getIbatisMapperNamespace() + "." + sqlKey;
        return this.getSqlSessionTemplate().delete(delStatement, (Object)objs);
    }

    @Override
    public List<E> getMyBatisList(String sqlKey, Object params, PageBean pageBean) throws Exception {
        if (pageBean == null) {
            return this.getMyBatisList(sqlKey, params);
        }
        String statementName = this.getIbatisMapperNamespace() + "." + sqlKey;
        HashMap filters = new HashMap();
        if (params != null && params instanceof Map) {
            filters.putAll((Map)params);
        }
        if (pageBean.isShowTotal()) {
            int totalCount;
            IbatisSql ibatisSql = this.getIbatisSql(statementName, MapUtil.isNotEmpty(filters) ? filters : params);
            if (pageBean.isDistinct()) {
                if (StrUtil.isEmpty((CharSequence)this.primaryKey)) {
                    totalCount = (Integer)this.getJdbcTemplate().queryForObject(ibatisSql.getCountSqlDistinct(), ibatisSql.getParameters(), Integer.class);
                    pageBean.setTotalCount(totalCount);
                } else {
                    totalCount = (Integer)this.getJdbcTemplate().queryForObject(ibatisSql.getCountSqlDistinct(this.primaryKey), ibatisSql.getParameters(), Integer.class);
                    pageBean.setTotalCount(totalCount);
                }
            } else if (StrUtil.isEmpty((CharSequence)this.primaryKey)) {
                totalCount = (Integer)this.getJdbcTemplate().queryForObject(ibatisSql.getCountSql(), ibatisSql.getParameters(), Integer.class);
                pageBean.setTotalCount(totalCount);
            } else {
                totalCount = (Integer)this.getJdbcTemplate().queryForObject(ibatisSql.getCountSql(this.primaryKey), ibatisSql.getParameters(), Integer.class);
                pageBean.setTotalCount(totalCount);
            }
        }
        RowBounds rowBounds = new RowBounds(pageBean.getFirst(), pageBean.getPageSize());
        List list = this.getSqlSessionTemplate().selectList(statementName, MapUtil.isNotEmpty(filters) ? filters : params, rowBounds);
        PageList pageList = new PageList();
        pageList.addAll(list);
        pageList.setPageBean(pageBean);
        return pageList;
    }

    @Override
    public List<E> getMyBatisList(String sqlKey, Object params) throws Exception {
        String statementName = this.getIbatisMapperNamespace() + "." + sqlKey;
        HashMap filters = new HashMap();
        if (params != null && params instanceof Map) {
            filters.putAll((Map)params);
        }
        return this.getSqlSessionTemplate().selectList(statementName, MapUtil.isNotEmpty(filters) ? filters : params);
    }

    @Override
    public List<E> getMyBatisAll() throws Exception {
        String statementName = this.getIbatisMapperNamespace() + ".getAll";
        return this.getSqlSessionTemplate().selectList(statementName, null);
    }

    public Integer getMyBatisCount(String sqlKey, Object params) throws Exception {
        try {
            String statementName = this.getIbatisMapperNamespace() + "." + sqlKey;
            return (Integer)this.getSqlSessionTemplate().selectOne(statementName, params);
        }
        catch (Exception e) {
            this.logger.error((Object)(this.getClass().getName() + " count exception and key is: " + sqlKey), (Throwable)e);
            return 0;
        }
    }

    public Connection getConnection() throws Exception {
        Connection connection = SqlSessionUtils.getSqlSession((SqlSessionFactory)this.getSqlSessionTemplate().getSqlSessionFactory(), (ExecutorType)this.getSqlSessionTemplate().getExecutorType(), (PersistenceExceptionTranslator)this.getSqlSessionTemplate().getPersistenceExceptionTranslator()).getConnection();
        return connection;
    }
}

