/*
 * Decompiled with CFR 0.152.
 */
package cn.dolphin.core.db;

import cn.dolphin.core.db.GenericDao;
import cn.dolphin.core.jdbc.JdbcTemplatePlus;
import cn.dolphin.core.jdbc.support.CommonObj;
import cn.dolphin.core.mybatis.SqlMapper;
import cn.dolphin.core.spring.SpringContextUtil;
import java.io.Serializable;
import org.apache.ibatis.session.SqlSessionFactory;
import org.springframework.jdbc.core.RowMapper;

public abstract class BaseDao<E, PK extends Serializable>
extends GenericDao<E, PK> {
    ThreadLocal<JdbcTemplatePlus> jdbc = new ThreadLocal();
    private JdbcTemplatePlus jdbcTemplatePlus;

    public BaseDao() {
    }

    public BaseDao(SqlSessionFactory sqlSessionFactory) {
        this.setSqlSessionFactory(sqlSessionFactory);
    }

    public BaseDao(JdbcTemplatePlus jdbcTemplatePlus) {
        this.setJdbcTemplatePlus(jdbcTemplatePlus);
    }

    public BaseDao(JdbcTemplatePlus jdbcTemplatePlus, SqlSessionFactory sqlSessionFactory) {
        this.setJdbcTemplatePlus(jdbcTemplatePlus);
        this.setSqlSessionFactory(sqlSessionFactory);
    }

    public void setJdbcTemplatePlus(JdbcTemplatePlus jdbcTemplatePlus) {
        this.jdbcTemplatePlus = jdbcTemplatePlus;
    }

    @Override
    public void setSqlSessionFactory(SqlSessionFactory sqlSessionFactory) {
        super.setSqlSessionFactory(sqlSessionFactory);
    }

    @Override
    public JdbcTemplatePlus getJdbcTemplate() {
        if (this.jdbcTemplatePlus == null) {
            this.jdbcTemplatePlus = this.jdbc.get();
            if (this.jdbcTemplatePlus == null) {
                this.jdbcTemplatePlus = SpringContextUtil.getBean(JdbcTemplatePlus.class);
                this.jdbc.set(this.jdbcTemplatePlus);
            }
        }
        return this.jdbcTemplatePlus;
    }

    @Override
    public Class<?> getEntityClass() {
        return this.entityClass;
    }

    @Override
    protected RowMapper<E> getRowMapper() {
        return new CommonObj(this.getEntityClass());
    }

    @Override
    public SqlMapper sqlMapper() {
        SqlMapper sqlMapper = new SqlMapper(this.openSession());
        return sqlMapper;
    }
}

