/*
 * Decompiled with CFR 0.152.
 */
package cn.dolphin.core.date;

import cn.dolphin.core.date.DateFormatUtil;
import cn.dolphin.core.date.DateUtil;
import cn.dolphin.core.util.StrUtil;
import cn.dolphin.core.util.SystemClock;
import java.io.Serializable;
import java.lang.management.ManagementFactory;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimeUtil
implements Serializable {
    private static final Logger log = LoggerFactory.getLogger(TimeUtil.class);
    public static final String YYYY = "yyyy";
    public static final String YYYYMM = "yyyyMM";
    public static final String YYYYMMDD = "yyyyMMdd";
    public static final String YYYYMMDDHH = "yyyyMMddHH";
    public static final String YYYYMMDDHHMMSS = "yyyyMMddHHmmss";
    public static final String HHMMSS = "HHmmss";
    public static final String YYYYMMDDHHMMSSSSS = "yyyyMMddHHmmssSSS";
    private static final long ONE_MINUTE = 60000L;
    private static final long ONE_HOUR = 3600000L;
    private static final long ONE_DAY = 86400000L;
    private static final long ONE_WEEK = 604800000L;
    private static final String ONE_SECOND_AGO = "\u79d2\u524d";
    private static final String ONE_MINUTE_AGO = "\u5206\u949f\u524d";
    private static final String ONE_HOUR_AGO = "\u5c0f\u65f6\u524d";
    private static final String ONE_DAY_AGO = "\u5929\u524d";
    private static final String ONE_MONTH_AGO = "\u6708\u524d";
    private static final String ONE_YEAR_AGO = "\u5e74\u524d";
    private static String[] parsePatterns = new String[]{"yyyy-MM-dd", "yyyy-MM-dd HH:mm:ss", "yyyy-MM-dd HH:mm", "yyyy-MM", "yyyy/MM/dd", "yyyy/MM/dd HH:mm:ss", "yyyy/MM/dd HH:mm", "yyyy/MM", "yyyy.MM.dd", "yyyy.MM.dd HH:mm:ss", "yyyy.MM.dd HH:mm", "yyyy.MM"};

    public static Date getTime() {
        return new Date();
    }

    public static long unixTimestamp() {
        return SystemClock.now() / 1000L;
    }

    public static long unixTimestamp(Date time) {
        Timestamp ts = new Timestamp(time.getTime());
        return ts.getTime() / 1000L;
    }

    public static long unixTimestamp(long time) {
        return TimeUtil.toSeconds(time);
    }

    public static Long getCurrentUnixTimeStamp() {
        return new DateTime().getMillis() / 1000L;
    }

    public static Long getUnixTimeStamp(Date date) {
        return new DateTime((Object)date).getMillis() / 1000L;
    }

    public static Date parseToDate(String stringDate) {
        if (StrUtil.isBlank((CharSequence)stringDate)) {
            return new Date();
        }
        List patterns = Stream.of("yyyy\u5e74MM\u6708dd\u65e5", "yy-MM", "yyyy-MM", "yyyy-MM-dd", "yyyy/MM/dd", "yyyy-MM-dd HH:mm:ss", "yyyy-MM-dd HH:mm", "yyyy-MM-dd HH").collect(Collectors.toList());
        for (String pattern : patterns) {
            SimpleDateFormat df = new SimpleDateFormat(pattern);
            try {
                return df.parse(stringDate);
            }
            catch (Exception exception) {
            }
        }
        log.error("\u8f6c\u6362\u65e5\u671f\u53d1\u751f\u5f02\u5e38\uff0c\u6ca1\u6709\u9002\u914d\u7684pattern\u3002\u65e5\u671f\u4e3a\uff1a{}", (Object)stringDate);
        return null;
    }

    public static Date getTodayBegin() {
        Calendar currentDate = Calendar.getInstance();
        currentDate.set(11, 0);
        currentDate.set(12, 0);
        currentDate.set(13, 0);
        return currentDate.getTime();
    }

    public static String getDateStamp(long date) {
        long times = date * 1000L;
        Date d = new Date(times);
        return DateFormatUtil.DATETIME_FORMAT.format(d);
    }

    public static Date getTodayEnd() {
        Calendar currentDate = Calendar.getInstance();
        currentDate.set(11, 23);
        currentDate.set(12, 59);
        currentDate.set(13, 59);
        return currentDate.getTime();
    }

    public static long getSeconds(long date) {
        return TimeUtil.toSeconds(date);
    }

    public static long intervalMs(Date beforeDate, Date endDate) {
        return endDate.getTime() - beforeDate.getTime();
    }

    public static Date parseDate(Object str) {
        try {
            if (str == null) {
                return null;
            }
            return DateUtil.parseDate((String)str.toString(), (String[])parsePatterns);
        }
        catch (ParseException e) {
            return null;
        }
    }

    public static boolean isOverdueSecond(long lastAccessedTime, long secondLimit) {
        if (secondLimit == 0L) {
            return true;
        }
        if (secondLimit < 0L) {
            return false;
        }
        long interval = SystemClock.now();
        long interval_sec = interval / 1000L;
        return interval_sec > secondLimit;
    }

    public static String getDatePoor(Date endDate, Date nowDate) {
        long nd = 86400000L;
        long nh = 3600000L;
        long nm = 60000L;
        long diff = endDate.getTime() - nowDate.getTime();
        long day = diff / nd;
        long hour = diff % nd / nh;
        long min = diff % nd % nh / nm;
        return day + "\u5929" + hour + "\u5c0f\u65f6" + min + "\u5206\u949f";
    }

    public static Date getServerStartDate() {
        long time = ManagementFactory.getRuntimeMXBean().getStartTime();
        return new Date(time);
    }

    public static String getDate(Integer num) {
        if (num != null && num >= 1) {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
            return simpleDateFormat.format(new Date(SystemClock.now() - TimeUnit.DAYS.toMillis(num.intValue())));
        }
        return null;
    }

    public static String format(Date date, String format) {
        return TimeUtil.getSimpleDateFormat(format).format(date);
    }

    public static SimpleDateFormat getSimpleDateFormat(String strFormat) {
        if (strFormat != null && !"".equals(strFormat.trim())) {
            return new SimpleDateFormat(strFormat);
        }
        return new SimpleDateFormat();
    }

    public static Timestamp getUnixTimestamp(String time) {
        Long timestamp = Long.parseLong(time) * 1000L;
        String date = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date(timestamp));
        Timestamp ts = new Timestamp(SystemClock.now());
        try {
            ts = Timestamp.valueOf(date);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ts;
    }

    public static Timestamp getTimestamp(long time) {
        String date = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date(time));
        Timestamp ts = new Timestamp(SystemClock.now());
        try {
            ts = Timestamp.valueOf(date);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ts;
    }

    public static Timestamp getTimestamp(String time) {
        try {
            Date date = DateUtil.parseDate((String)time.trim(), (String[])parsePatterns);
            return new Timestamp(date.getTime());
        }
        catch (ParseException e) {
            return null;
        }
    }

    public static Timestamp getGMTTimestamp(long time) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(time);
        calendar.set(10, calendar.get(10) + 8);
        String date = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(calendar.getTime());
        Timestamp ts = new Timestamp(SystemClock.now());
        try {
            ts = Timestamp.valueOf(date);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ts;
    }

    public static String formatAgo(Date date) {
        if (date == null) {
            return "\u672a\u77e5";
        }
        long curTime = System.currentTimeMillis() - date.getTime();
        if (curTime < 60000L) {
            long seconds = TimeUtil.toSeconds(curTime);
            return (seconds <= 0L ? 1L : seconds) + ONE_SECOND_AGO;
        }
        if (curTime < 2700000L) {
            long minutes = TimeUtil.toMinutes(curTime);
            return (minutes <= 0L ? 1L : minutes) + ONE_MINUTE_AGO;
        }
        if (curTime < 86400000L) {
            long hours = TimeUtil.toHours(curTime);
            return (hours <= 0L ? 1L : hours) + ONE_HOUR_AGO;
        }
        if (curTime < 172800000L) {
            return "\u6628\u5929";
        }
        if (curTime < 2592000000L) {
            long days = TimeUtil.toDays(curTime);
            return (days <= 0L ? 1L : days) + ONE_DAY_AGO;
        }
        if (curTime < 29030400000L) {
            long months = TimeUtil.toMonths(curTime);
            return (months <= 0L ? 1L : months) + ONE_MONTH_AGO;
        }
        long years = TimeUtil.toYears(curTime);
        return (years <= 0L ? 1L : years) + ONE_YEAR_AGO;
    }

    public static int dateCompare(Date date1, Date date2) {
        int dateLastIntVal;
        SimpleDateFormat dateFormat = new SimpleDateFormat(YYYYMMDD);
        String dateFirst = dateFormat.format(date1);
        String dateLast = dateFormat.format(date2);
        int dateFirstIntVal = Integer.parseInt(dateFirst);
        if (dateFirstIntVal > (dateLastIntVal = Integer.parseInt(dateLast))) {
            return 1;
        }
        if (dateFirstIntVal < dateLastIntVal) {
            return -1;
        }
        return 0;
    }

    public static Long getDateDiff(Date beginTime, Date endTime, Integer type) {
        long time = 0L;
        long diffTime = endTime.getTime() - beginTime.getTime();
        switch (type) {
            case 0: {
                time = diffTime / 1000L;
                break;
            }
            case 1: {
                time = diffTime / 60000L;
                break;
            }
            case 2: {
                time = diffTime / 3600000L;
                break;
            }
        }
        return time;
    }

    public static Date addYears(Date date, Integer amount) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(1, amount);
        return calendar.getTime();
    }

    public static Date addMonths(Date date, Integer amount) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(2, amount);
        return calendar.getTime();
    }

    public static Date addDays(Date date, Integer amount) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(6, amount);
        return calendar.getTime();
    }

    public static Date addHours(Date date, Integer amount) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(10, amount);
        return calendar.getTime();
    }

    public static Date addMinutes(Date date, Integer amount) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(12, amount);
        return calendar.getTime();
    }

    public static Date addSeconds(Date date, Integer amount) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(13, amount);
        return calendar.getTime();
    }

    private static long toSeconds(long date) {
        return date / 1000L;
    }

    private static long toMinutes(long date) {
        return TimeUtil.toSeconds(date) / 60L;
    }

    private static long toHours(long date) {
        return TimeUtil.toMinutes(date) / 60L;
    }

    private static long toDays(long date) {
        return TimeUtil.toHours(date) / 24L;
    }

    private static long toMonths(long date) {
        return TimeUtil.toDays(date) / 30L;
    }

    private static long toYears(long date) {
        return TimeUtil.toMonths(date) / 365L;
    }
}

