/*
 * Decompiled with CFR 0.152.
 */
package cn.dolphin.core.date;

import cn.dolphin.core.consts.DateConstant;
import cn.dolphin.core.util.ConvertUtil;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.Period;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAdjusters;
import java.util.Date;

public final class LocalDateUtil {
    private static DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");

    public static Instant getInstant(LocalDateTime dateTime) {
        return dateTime.atZone(DateConstant.ZONE_ID).toInstant();
    }

    public static Instant getInstant(long timestamp) {
        return Instant.ofEpochMilli(timestamp);
    }

    public static Instant getInstant(Date date) {
        return date.toInstant();
    }

    public static Instant getInstant(LocalDate date) {
        return date.atStartOfDay().atZone(DateConstant.ZONE_ID).toInstant();
    }

    public static Duration between(LocalDateTime startTime, LocalDateTime endTime) {
        return Duration.between(startTime, endTime);
    }

    public static Period between(LocalDate startTime, LocalDate endTime) {
        return Period.between(startTime, endTime);
    }

    public static Duration between(LocalTime startTime, LocalTime endTime) {
        return Duration.between(startTime, endTime);
    }

    public static LocalDateTime toLocalDateTime(String date) {
        return LocalDateTime.parse(date, DateConstant.DATE_TIME_FROMAT);
    }

    public static LocalDateTime toLocalDateTimeNum(String date) {
        return LocalDateTime.parse(date, DateConstant.DATE_TIME_FROMAT_NUM);
    }

    public static LocalDate toLocalDate(String date) {
        return LocalDate.parse(date, DateConstant.DATE_FROMAT);
    }

    public static LocalDate toLocalDateNum(String date) {
        return LocalDate.parse(date, DateConstant.DATE_FROMAT_NUM);
    }

    public static String toStr(LocalDateTime date) {
        return date.format(DateConstant.DATE_TIME_FROMAT);
    }

    public static String toStr(LocalDate date) {
        return date.format(DateConstant.DATE_FROMAT);
    }

    public static String toStr(LocalTime date) {
        return date.format(DateConstant.TIME_FROMAT);
    }

    public static String toStr() {
        return LocalDateTime.now().format(DateConstant.DATE_TIME_FROMAT);
    }

    public static String toDateStr() {
        return LocalDate.now().format(DateConstant.DATE_FROMAT);
    }

    public static String toTimeStr() {
        return LocalTime.now().format(DateConstant.TIME_FROMAT);
    }

    public static String toNum(LocalDateTime date) {
        return date.format(DateConstant.DATE_TIME_FROMAT_NUM);
    }

    public static String toNum(LocalDate date) {
        return date.format(DateConstant.DATE_FROMAT_NUM);
    }

    public static String toNum(LocalTime date) {
        return date.format(DateConstant.TIME_FROMAT_NUM);
    }

    public static String toNum() {
        return LocalDateTime.now().format(DateConstant.DATE_TIME_FROMAT_NUM);
    }

    public static String toDateNum() {
        return LocalDate.now().format(DateConstant.DATE_FROMAT_NUM);
    }

    public static String toTimeNum() {
        return LocalTime.now().format(DateConstant.TIME_FROMAT_NUM);
    }

    public static long getTime() {
        return System.currentTimeMillis();
    }

    public static long getTime(LocalDateTime dateTime) {
        return LocalDateUtil.getInstant(dateTime).toEpochMilli();
    }

    public static long getTime(LocalDate date) {
        return LocalDateUtil.getTime(date.atStartOfDay());
    }

    public static Date toDate(LocalDateTime dateTime) {
        return Date.from(LocalDateUtil.getInstant(dateTime));
    }

    public static Date toDate(LocalDate date) {
        return Date.from(LocalDateUtil.getInstant(date));
    }

    public static LocalDateTime toLocalDateTime(Date date) {
        return LocalDateTime.ofInstant(LocalDateUtil.getInstant(date), DateConstant.ZONE_ID);
    }

    public static LocalDateTime toLocalDateTime(Long timestamp) {
        return LocalDateTime.ofInstant(LocalDateUtil.getInstant(timestamp), DateConstant.ZONE_ID);
    }

    public static LocalDate toLocalDate(Date date) {
        return LocalDateUtil.toLocalDateTime(date).toLocalDate();
    }

    public static LocalDate toLocalDate(Long timestamp) {
        return LocalDateUtil.toLocalDateTime(timestamp).toLocalDate();
    }

    public static LocalTime toLocalTime(Date date) {
        return LocalDateUtil.toLocalDateTime(date).toLocalTime();
    }

    public static LocalTime toLocalTime(Long timestamp) {
        return LocalDateUtil.toLocalDateTime(timestamp).toLocalTime();
    }

    public static String nowTimeStr() {
        return formatter.format(LocalDateTime.now().withNano(0));
    }

    public static Date nowTime() {
        return LocalDateUtil.localDateTimeToDate(LocalDateTime.now());
    }

    public static String dayStartTimeStr(int days) {
        return formatter.format(LocalDate.now().minusDays(days).atTime(0, 0, 0).withNano(0));
    }

    public static Date dayStartTime(int days) {
        return LocalDateUtil.localDateTimeToDate(LocalDate.now().minusDays(days).atTime(0, 0, 0).withNano(0));
    }

    public static String dayEndTimeStr(int days) {
        return formatter.format(LocalDate.now().minusDays(days).atTime(23, 59, 59).withNano(0));
    }

    public static Date dayEndTime(int days) {
        return LocalDateUtil.localDateTimeToDate(LocalDate.now().minusDays(days).atTime(23, 59, 59).withNano(0));
    }

    public static String dayStartTimeStr() {
        return formatter.format(LocalDate.now().atTime(0, 0, 0).withNano(0));
    }

    public static Date dayStartTime() {
        return LocalDateUtil.localDateTimeToDate(LocalDate.now().atTime(0, 0, 0).withNano(0));
    }

    public static String dayEndTimeStr() {
        return formatter.format(LocalDate.now().atTime(23, 59, 59).withNano(0));
    }

    public static Date dayEndTime() {
        return LocalDateUtil.localDateTimeToDate(LocalDate.now().atTime(23, 59, 59).withNano(0));
    }

    public static String lastDayStartTimeStr() {
        return formatter.format(LocalDate.now().atTime(0, 0, 0).minusDays(1L).withNano(0));
    }

    public static Date lastDayStartTime() {
        return LocalDateUtil.localDateTimeToDate(LocalDate.now().atTime(0, 0, 0).minusDays(1L).withNano(0));
    }

    public static String lastDayEndTimeStr() {
        return formatter.format(LocalDate.now().atTime(23, 59, 59).minusDays(1L).withNano(0));
    }

    public static Date lastDayEndTime() {
        return LocalDateUtil.localDateTimeToDate(LocalDate.now().atTime(23, 59, 59).minusDays(1L).withNano(0));
    }

    public static String weekStartTimeStr() {
        LocalDate date = LocalDate.now();
        int week = date.getDayOfWeek().getValue();
        return formatter.format(date.atTime(0, 0, 0).minusDays(week - 1).withNano(0));
    }

    public static Date weekStartTime() {
        LocalDate date = LocalDate.now();
        int week = date.getDayOfWeek().getValue();
        return LocalDateUtil.localDateTimeToDate(date.atTime(0, 0, 0).minusDays(week - 1).withNano(0));
    }

    public static String weekEndTimeStr() {
        LocalDate date = LocalDate.now();
        int week = date.getDayOfWeek().getValue();
        return formatter.format(date.atTime(23, 59, 59).plusDays(7 - week).withNano(0));
    }

    public static Date weekEndTime() {
        LocalDate date = LocalDate.now();
        int week = date.getDayOfWeek().getValue();
        return LocalDateUtil.localDateTimeToDate(date.atTime(23, 59, 59).plusDays(7 - week).withNano(0));
    }

    public static String lastWeekStartTimeStr() {
        LocalDate date = LocalDate.now();
        int week = date.getDayOfWeek().getValue();
        return formatter.format(date.atTime(0, 0, 0).minusWeeks(1L).minusDays(week - 1).withNano(0));
    }

    public static Date lastWeekStartTime() {
        LocalDate date = LocalDate.now();
        int week = date.getDayOfWeek().getValue();
        return LocalDateUtil.localDateTimeToDate(date.atTime(0, 0, 0).minusWeeks(1L).minusDays(week - 1).withNano(0));
    }

    public static String lastWeekEndTimeStr() {
        LocalDate date = LocalDate.now();
        int week = date.getDayOfWeek().getValue();
        return formatter.format(date.atTime(23, 59, 59).minusWeeks(1L).plusDays(7 - week).withNano(0));
    }

    public static Date lastWeekEndTime() {
        LocalDate date = LocalDate.now();
        int week = date.getDayOfWeek().getValue();
        return LocalDateUtil.localDateTimeToDate(date.atTime(23, 59, 59).minusWeeks(1L).plusDays(7 - week).withNano(0));
    }

    public static String monthStartTimeStr() {
        return formatter.format(LocalDate.now().atTime(0, 0, 0).with(TemporalAdjusters.firstDayOfMonth()).withNano(0));
    }

    public static Date monthStartTime() {
        return LocalDateUtil.localDateTimeToDate(LocalDate.now().atTime(0, 0, 0).with(TemporalAdjusters.firstDayOfMonth()).withNano(0));
    }

    public static String monthEndTimeStr() {
        return formatter.format(LocalDate.now().atTime(23, 59, 59).with(TemporalAdjusters.lastDayOfMonth()).withNano(0));
    }

    public static Date monthEndTime() {
        return LocalDateUtil.localDateTimeToDate(LocalDate.now().atTime(23, 59, 59).with(TemporalAdjusters.lastDayOfMonth()).withNano(0));
    }

    public static String lastMonthStartTimeStr() {
        return formatter.format(LocalDate.now().atTime(0, 0, 0).minusMonths(1L).with(TemporalAdjusters.firstDayOfMonth()).withNano(0));
    }

    public static Date lastMonthStartTime() {
        return LocalDateUtil.localDateTimeToDate(LocalDate.now().atTime(0, 0, 0).minusMonths(1L).with(TemporalAdjusters.firstDayOfMonth()).withNano(0));
    }

    public static String lastMonthEndTimeStr() {
        return formatter.format(LocalDate.now().atTime(23, 59, 59).minusMonths(1L).with(TemporalAdjusters.lastDayOfMonth()).withNano(0));
    }

    public static Date lastMonthEndTime() {
        return LocalDateUtil.localDateTimeToDate(LocalDate.now().atTime(23, 59, 59).minusMonths(1L).with(TemporalAdjusters.lastDayOfMonth()).withNano(0));
    }

    public static Date localDateToDate(LocalDate date) {
        ZoneId zoneId = ZoneId.systemDefault();
        ZonedDateTime zdt = date.atStartOfDay(zoneId);
        return Date.from(zdt.toInstant());
    }

    public static Date localDateTimeToDate(LocalDateTime date) {
        ZoneId zoneId = ZoneId.systemDefault();
        Instant instant = date.atZone(zoneId).toInstant();
        return Date.from(instant);
    }

    public static int get2ZeroHour() {
        long nowTime = LocalDateUtil.nowTime().getTime();
        long endTime = LocalDateUtil.dayEndTime().getTime();
        long currentTime = endTime - nowTime;
        return ConvertUtil.toInteger(currentTime / 1000L);
    }

    public static void main(String[] args) {
        System.out.println("\u83b7\u53d6\u5f53\u524d\u65f6\u95f4:" + LocalDateUtil.nowTimeStr());
        System.out.println("\u83b7\u53d6\u5f53\u524d\u65f6\u95f4:" + LocalDateUtil.nowTime().getTime());
        System.out.println("\u5f53\u5929\u5f00\u59cb\u65f6\u95f4:" + LocalDateUtil.dayStartTimeStr());
        System.out.println("\u5f53\u5929\u5f00\u59cb\u65f6\u95f4:" + LocalDateUtil.dayStartTime());
        System.out.println("\u5f53\u5929\u7ed3\u675f\u65f6\u95f4:" + LocalDateUtil.dayEndTimeStr());
        System.out.println("\u5f53\u5929\u7ed3\u675f\u65f6\u95f4:" + LocalDateUtil.dayEndTime());
        System.out.println("\u6628\u5929\u5f00\u59cb\u65f6\u95f4:" + LocalDateUtil.lastDayStartTimeStr());
        System.out.println("\u6628\u5929\u5f00\u59cb\u65f6\u95f4" + LocalDateUtil.lastDayStartTime());
        System.out.println("\u6628\u5929\u7ed3\u675f\u65f6\u95f4" + LocalDateUtil.lastDayEndTimeStr());
        System.out.println("\u6628\u5929\u7ed3\u675f\u65f6\u95f4" + LocalDateUtil.lastDayEndTime());
        System.out.println("\u672c\u5468\u5f00\u59cb\u65f6\u95f4" + LocalDateUtil.weekStartTimeStr());
        System.out.println("\u672c\u5468\u5f00\u59cb\u65f6\u95f4" + LocalDateUtil.weekStartTime());
        System.out.println("\u672c\u5468\u7ed3\u675f\u65f6\u95f4" + LocalDateUtil.weekEndTimeStr());
        System.out.println("\u672c\u5468\u7ed3\u675f\u65f6\u95f4" + LocalDateUtil.weekEndTime());
        System.out.println("\u4e0a\u5468\u5f00\u59cb\u65f6\u95f4" + LocalDateUtil.lastWeekStartTimeStr());
        System.out.println("\u4e0a\u5468\u5f00\u59cb\u65f6\u95f4" + LocalDateUtil.lastWeekStartTime());
        System.out.println("\u4e0a\u5468\u7ed3\u675f\u65f6\u95f4" + LocalDateUtil.lastWeekEndTimeStr());
        System.out.println("\u4e0a\u5468\u7ed3\u675f\u65f6\u95f4" + LocalDateUtil.lastWeekEndTime());
        System.out.println("\u672c\u6708\u5f00\u59cb\u65f6\u95f4" + LocalDateUtil.monthStartTimeStr());
        System.out.println("\u672c\u6708\u5f00\u59cb\u65f6\u95f4" + LocalDateUtil.monthStartTime());
        System.out.println("\u672c\u6708\u7ed3\u675f\u65f6\u95f4" + LocalDateUtil.monthEndTimeStr());
        System.out.println("\u672c\u6708\u7ed3\u675f\u65f6\u95f4" + LocalDateUtil.monthEndTime());
        System.out.println("\u4e0a\u6708\u5f00\u59cb\u65f6\u95f4" + LocalDateUtil.lastMonthStartTimeStr());
        System.out.println("\u4e0a\u6708\u5f00\u59cb\u65f6\u95f4" + LocalDateUtil.lastMonthStartTime());
        System.out.println("\u4e0a\u6708\u7ed3\u675f\u65f6\u95f4" + LocalDateUtil.lastMonthEndTimeStr());
        System.out.println("\u4e0a\u6708\u7ed3\u675f\u65f6\u95f4" + LocalDateUtil.lastMonthEndTime());
    }
}

