/*
 * Decompiled with CFR 0.152.
 */
package cn.dolphin.core.date;

import com.google.common.collect.Lists;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.Days;
import org.joda.time.LocalDate;
import org.joda.time.Period;
import org.joda.time.PeriodType;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public class JodaUtil {
    public static final String DATE_FORMAT = "yyyy-MM-dd";
    public static final String TIME_FORMAT = "yyyy-MM-dd HH:mm:ss";
    public static final String[] parsePatterns = new String[]{"yyyy-MM-dd", "yyyy-MM-dd HH:mm:ss", "yyyy-MM-dd HH:mm", "yyyy-MM", "yyyy/MM/dd", "yyyy/MM/dd HH:mm:ss", "yyyy/MM/dd HH:mm", "yyyy/MM", "yyyy.MM.dd", "yyyy.MM.dd HH:mm:ss", "yyyy.MM.dd HH:mm", "yyyy.MM", "yyyyMMddHHmmss", "yyyyMMdd", "yyyy-MM-dd'T'HH:mm:ss.SSS", "yyyy-MM-dd'T'HH:mm:ss:SSSZZ", "yyyy-MM-dd'T'HH:mm:ss.SSSX", "yyyy-MM-dd'T'HH:mm:ss.SSS Z", "dd MMM yyyy"};

    public static String getDate() {
        return LocalDate.now().toString(DATE_FORMAT);
    }

    public static String getCurSysTime() {
        DateTime dateTime = new DateTime();
        return dateTime.toString(TIME_FORMAT);
    }

    public static DateTime getUnixTimeStamp(Long unixTimeStamp) {
        if (String.valueOf(unixTimeStamp).length() > 10) {
            unixTimeStamp = unixTimeStamp / 1000L;
        }
        try {
            return new DateTime(unixTimeStamp * 1000L);
        }
        catch (Exception ex) {
            return null;
        }
    }

    public static String parseStrToDate(String input) {
        DateTime dateTime = JodaUtil.parseStr(input);
        if (null != dateTime) {
            return dateTime.toString(DATE_FORMAT);
        }
        return null;
    }

    public static DateTime parseStr(String input) {
        DateTime dateTime = JodaUtil.parseStr(input, parsePatterns);
        if (null == dateTime || dateTime.getYear() < 1980) {
            dateTime = JodaUtil.getUnixTimeStamp(NumberUtils.toLong((String)input));
        }
        if (null != dateTime && dateTime.getYear() < 1980) {
            dateTime = null;
        }
        return dateTime;
    }

    public static DateTime parseStr(String input, String[] parsePatterns) {
        DateTime dateTime = null;
        try {
            Date date = DateUtils.parseDate((String)input, (String[])parsePatterns);
            dateTime = new DateTime((Object)date);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return dateTime;
    }

    public static List<String[]> getWeekList(Date startDate, Date endDate) {
        DateTime lastDay;
        ArrayList<String[]> weekList = new ArrayList<String[]>();
        DateTime firstDay = new DateTime((Object)startDate).dayOfWeek().withMinimumValue();
        Period p = new Period((ReadableInstant)firstDay, (ReadableInstant)(lastDay = new DateTime((Object)endDate).dayOfWeek().withMaximumValue()), PeriodType.days());
        int days = p.getDays();
        if (days > 0) {
            int weekLength = 7;
            for (int i = 0; i < days; i += weekLength) {
                String monDay = firstDay.plusDays(i).toString(DATE_FORMAT);
                String sunDay = firstDay.plusDays(i + 6).toString(DATE_FORMAT);
                String[] week = new String[]{monDay, sunDay};
                weekList.add(week);
            }
        }
        return weekList;
    }

    public static List<String> getWeekList(Date startDate, int days, final boolean isOrder) {
        ArrayList<String> weekList = new ArrayList<String>();
        for (int i = 0; i < days; ++i) {
            DateTime sunDay = new DateTime((Object)startDate).plusDays(-i);
            weekList.add(sunDay.toString(DATE_FORMAT));
        }
        Collections.sort(weekList, new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                if (isOrder) {
                    return o1.compareTo(o2);
                }
                return o2.compareTo(o1);
            }
        });
        return weekList;
    }

    public static DateTime getUTCTime() {
        Calendar cal = Calendar.getInstance();
        int zoneOffset = cal.get(15);
        int dstOffset = cal.get(16);
        cal.add(14, -(zoneOffset + dstOffset));
        return new DateTime((Object)cal);
    }

    public static boolean isSameDay(String date, String anotherDate) {
        boolean res = false;
        DateTime dateTime = new DateTime();
        DateTime dt1 = new DateTime((Object)date);
        DateTime dt2 = new DateTime((Object)anotherDate);
        int intervalDays = Days.daysBetween((ReadableInstant)dt1, (ReadableInstant)dt2).getDays();
        if (intervalDays == 0) {
            res = true;
        }
        return res;
    }

    public static Integer diffDay(Date startDate, Date endDate) {
        if (startDate == null || endDate == null) {
            return null;
        }
        DateTime dt1 = new DateTime((Object)startDate);
        DateTime dt2 = new DateTime((Object)endDate);
        int day = Days.daysBetween((ReadableInstant)dt1, (ReadableInstant)dt2).getDays();
        return Math.abs(day);
    }

    public static String day00() {
        DateTime dt = new DateTime().withMillisOfDay(0);
        return dt.toString(TIME_FORMAT);
    }

    public static Date day00(Integer days, String date, String zimeZone) {
        DateTime dt;
        try {
            TimeZone timeZone = StringUtils.isBlank((CharSequence)zimeZone) ? TimeZone.getDefault() : TimeZone.getTimeZone(zimeZone);
            dt = StringUtils.isBlank((CharSequence)date) ? new DateTime().withZone(DateTimeZone.forTimeZone((TimeZone)timeZone)).toLocalDateTime().toDateTime() : new DateTime((Object)date).withZone(DateTimeZone.forTimeZone((TimeZone)timeZone)).toLocalDateTime().toDateTime();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        DateTime y = dt.minusDays(days.intValue()).withHourOfDay(0).withMinuteOfHour(0).withSecondOfMinute(0);
        return y.toDate();
    }

    public static Date day59(Integer days, String date, String zimeZone) {
        DateTime dt;
        try {
            TimeZone timeZone = StringUtils.isBlank((CharSequence)zimeZone) ? TimeZone.getDefault() : TimeZone.getTimeZone(zimeZone);
            dt = StringUtils.isBlank((CharSequence)date) ? new DateTime().withZone(DateTimeZone.forTimeZone((TimeZone)timeZone)).toLocalDateTime().toDateTime() : new DateTime((Object)date).withZone(DateTimeZone.forTimeZone((TimeZone)timeZone)).toLocalDateTime().toDateTime();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        DateTime y = dt.minusDays(days.intValue()).withHourOfDay(23).withMinuteOfHour(59).withSecondOfMinute(59);
        return y.toDate();
    }

    public static List<LocalDate> getDateBetween(String start, String end) {
        DateTime endTime;
        ArrayList listDates = Lists.newArrayList();
        DateTime startTime = JodaUtil.parseStr(start);
        Integer betweenDays = Days.daysBetween((ReadableInstant)startTime, (ReadableInstant)(endTime = JodaUtil.parseStr(end))).getDays();
        if (betweenDays > 0) {
            for (int i = 0; i <= betweenDays; ++i) {
                listDates.add(startTime.plusDays(i).toLocalDate());
            }
        }
        return listDates;
    }

    public static List<String> getDateStrBetween(String start, String end, final boolean isOrder) {
        DateTime endTime;
        ArrayList listDates = Lists.newArrayList();
        DateTime startTime = JodaUtil.parseStr(start);
        Integer betweenDays = Days.daysBetween((ReadableInstant)startTime, (ReadableInstant)(endTime = JodaUtil.parseStr(end))).getDays();
        if (betweenDays > 0) {
            for (int i = 0; i <= betweenDays; ++i) {
                listDates.add(startTime.plusDays(i).toString(DATE_FORMAT));
            }
        }
        Collections.sort(listDates, new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                if (isOrder) {
                    return o1.compareTo(o2);
                }
                return o2.compareTo(o1);
            }
        });
        return listDates;
    }

    public static String formatFrom(String dateStr, String fromPattern, String toPattern) {
        DateTimeFormatter dateTimeFormatter = DateTimeFormat.forPattern((String)fromPattern);
        DateTime localTime = dateTimeFormatter.parseDateTime(dateStr);
        return localTime.toString(toPattern);
    }

    public static String format(Long timestamp) {
        String dateStr = "";
        if (null == timestamp || timestamp < 0L) {
            return dateStr;
        }
        try {
            DateTimeFormatter dateTimeFormatter = DateTimeFormat.forPattern((String)TIME_FORMAT);
            dateStr = dateTimeFormatter.print(timestamp.longValue());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return dateStr;
    }
}

