/*
 * Decompiled with CFR 0.152.
 */
package cn.dolphin.core.date;

import java.sql.Time;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Calendar;
import java.util.Date;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class DateUtil8 {
    private static final ConcurrentMap<String, DateTimeFormatter> FORMATTER_CACHE = new ConcurrentHashMap<String, DateTimeFormatter>();

    private DateUtil8() {
    }

    public static String formatDate(long l) {
        return DateUtil8.formatDate(new Date(l));
    }

    public static String formatDate(Date date) {
        return LocalDateTime.ofInstant(date.toInstant(), ZoneId.systemDefault()).format(DateUtil8.formatFor("yyyy-MM-dd"));
    }

    public static String formatTime(long l) {
        return DateUtil8.formatTime(new Date(l));
    }

    public static String formatTime(Date date) {
        return LocalDateTime.ofInstant(date.toInstant(), ZoneId.systemDefault()).format(DateUtil8.formatFor("HH:mm:ss"));
    }

    public static String formatDateTime(long l) {
        return DateUtil8.formatDateTime(new Date(l));
    }

    public static String formatDateTime(Date date) {
        return LocalDateTime.ofInstant(date.toInstant(), ZoneId.systemDefault()).format(DateUtil8.formatFor("yyyy-MM-dd HH:mm:ss"));
    }

    public static String formatCompactDate(long l) {
        return DateUtil8.formatCompactDate(new Date(l));
    }

    public static String formatCompactDate(Date date) {
        return LocalDateTime.ofInstant(date.toInstant(), ZoneId.systemDefault()).format(DateUtil8.formatFor("yyyyMMdd"));
    }

    public static String formatCompactTime(long l) {
        return DateUtil8.formatCompactTime(new Date(l));
    }

    public static String formatCompactTime(Date date) {
        return LocalDateTime.ofInstant(date.toInstant(), ZoneId.systemDefault()).format(DateUtil8.formatFor("HHmmss"));
    }

    public static String formatCompactDateTime(long l) {
        return DateUtil8.formatCompactDateTime(new Date(l));
    }

    public static String formatCompactDateTime(Date date) {
        return LocalDateTime.ofInstant(date.toInstant(), ZoneId.systemDefault()).format(DateUtil8.formatFor("yyyyMMddHHmmss"));
    }

    public static String format(long l, String format) {
        return DateUtil8.format(new Date(l), format);
    }

    public static String format(Date date, String pattern) {
        return LocalDateTime.ofInstant(date.toInstant(), ZoneId.systemDefault()).format(DateUtil8.formatFor(pattern));
    }

    public static String formatChnTime(long l) {
        return DateUtil8.formatChnTime(l, false);
    }

    public static String formatChnTime(long l, boolean trim) {
        if (l <= 0L) {
            return "";
        }
        long d = l / 86400000L;
        long h = (l %= 86400000L) / 3600000L;
        long m = (l %= 3600000L) / 60000L;
        long s = (l %= 60000L) / 1000L;
        StringBuilder sb = new StringBuilder();
        if (!trim || d != 0L) {
            sb.append(d).append("\u5929");
        }
        if (!trim || h != 0L) {
            sb.append(h).append("\u5c0f\u65f6");
        }
        if (!trim || m != 0L) {
            sb.append(m).append("\u5206");
        }
        if (!trim || s != 0L) {
            sb.append(s).append("\u79d2");
        }
        return sb.toString();
    }

    public static Calendar addDay(Date date, int deltaDay) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(5, deltaDay);
        return calendar;
    }

    public static Calendar addSecond(Date date, int deltaSecond) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(13, deltaSecond);
        return calendar;
    }

    public static Calendar add(Date date, int field, int deltaSecond) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(field, deltaSecond);
        return calendar;
    }

    public static Long dateDiff(Date firstDate, Date secondDate, int interval) {
        if (firstDate == null || secondDate == null) {
            return null;
        }
        switch (interval) {
            case 1: {
                return (firstDate.getTime() - secondDate.getTime()) / 1471228928L;
            }
            case 2: {
                return (firstDate.getTime() - secondDate.getTime()) / -1702967296L;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                return (firstDate.getTime() - secondDate.getTime()) / 86400000L;
            }
            case 10: 
            case 11: {
                return (firstDate.getTime() - secondDate.getTime()) / 3600000L;
            }
            case 12: {
                return (firstDate.getTime() - secondDate.getTime()) / 60000L;
            }
            case 13: {
                return (firstDate.getTime() - secondDate.getTime()) / 1000L;
            }
            case 14: {
                return firstDate.getTime() - secondDate.getTime();
            }
        }
        return null;
    }

    public static Calendar getLastDayOfMonth(Date date) {
        Calendar calendar = Calendar.getInstance();
        if (date != null) {
            calendar.setTime(date);
        }
        calendar.set(5, calendar.getActualMaximum(5));
        return calendar;
    }

    public static Date truncDate(Date date) {
        return DateUtil8.parseDateTime(DateUtil8.truncDateStr(date, 5));
    }

    public static Date truncDate(Date date, int field) {
        return DateUtil8.parseDateTime(DateUtil8.truncDateStr(date, field));
    }

    public static Date truncCurDate(int field) {
        return DateUtil8.parseDateTime(DateUtil8.truncDateStr(new Date(), field));
    }

    public static String truncDateStr(Date date, int field) {
        String fmt = null;
        switch (field) {
            case 13: {
                break;
            }
            case 12: {
                fmt = "yyyy-MM-dd HH:mm:00";
                break;
            }
            case 10: 
            case 11: {
                fmt = "yyyy-MM-dd HH:00:00";
                break;
            }
            case 5: {
                fmt = "yyyy-MM-dd 00:00:00";
                break;
            }
            case 2: {
                fmt = "yyyy-MM-01 00:00:00";
                break;
            }
            case 1: {
                fmt = "yyyy-01-01 00:00:00";
                break;
            }
            default: {
                fmt = "yyyy-MM-dd HH:mm:ss";
            }
        }
        return DateUtil8.format(date, fmt);
    }

    public static String truncCurDateStr(int field) {
        return DateUtil8.truncDateStr(new Date(), field);
    }

    public static String truncCurDateStr() {
        return DateUtil8.truncDateStr(new Date(), 5);
    }

    public static Time truncToSqlTime(Date date) {
        if (date == null) {
            return null;
        }
        Date dt = DateUtil8.parseDateTime("1970-01-01 " + DateUtil8.formatTime(date));
        return new Time(dt.getTime());
    }

    public static Date replaceTime(Date date, String timeStr) {
        return DateUtil8.parseDateTime(DateUtil8.formatDate(date) + " " + timeStr);
    }

    public static Date replaceDate(Date date, String dateStr) {
        return DateUtil8.parseDateTime(dateStr + " " + DateUtil8.formatTime(date));
    }

    public static String getCurDate() {
        return DateUtil8.formatDate(new Date());
    }

    public static String getCurTime() {
        return DateUtil8.formatTime(new Date());
    }

    public static String getCurDateTime() {
        return DateUtil8.formatDateTime(new Date());
    }

    public static String getCurCompactDate() {
        return DateUtil8.formatCompactDate(new Date());
    }

    public static String getCurCompactTime() {
        return DateUtil8.formatCompactTime(new Date());
    }

    public static String getCurCompactDateTime() {
        return DateUtil8.formatCompactDateTime(new Date());
    }

    public static String getCurDateTime(String format) {
        return DateUtil8.format(new Date(), format);
    }

    public static Date parseDate(String str) {
        return DateUtil8.parse(str, "yyyy-MM-dd");
    }

    public static Date parseTime(String str) {
        return DateUtil8.parse(str, "HH:mm:ss");
    }

    public static Date parseDateTime(String str) {
        return DateUtil8.parse(str, "yyyy-MM-dd HH:mm:ss");
    }

    public static Date parseCompactDate(String str) {
        return DateUtil8.parse(str, "yyyyMMdd");
    }

    public static Date parseCompactTime(String str) {
        return DateUtil8.parse(str, "HHmmss");
    }

    public static Date parseCompactDateTime(String str) {
        return DateUtil8.parse(str, "yyyyMMddHHmmss");
    }

    public static Date parse(String str, String format) {
        return Date.from(LocalDateTime.parse(str, DateUtil8.formatFor(format)).atZone(ZoneId.systemDefault()).toInstant());
    }

    public static int getCurUnixTimestamp() {
        return (int)(System.currentTimeMillis() / 1000L);
    }

    public static int getUnixTimestamp(Date date) {
        return (int)(date.getTime() / 1000L);
    }

    public static Date parseUnixTimestamp(int timestamp) {
        long tms = (long)timestamp * 1000L;
        return new Date(tms);
    }

    private static DateTimeFormatter formatFor(String pattern) {
        DateTimeFormatter formats = (DateTimeFormatter)FORMATTER_CACHE.get(pattern);
        if (formats == null) {
            formats = DateTimeFormatter.ofPattern(pattern);
            FORMATTER_CACHE.put(pattern, formats);
        }
        return formats;
    }
}

