/*
 * Decompiled with CFR 0.152.
 */
package cn.dolphin.core.date;

import cn.dolphin.core.date.DateFormatUtil;
import cn.dolphin.core.enums.DateEnum;
import cn.dolphin.core.exception.UtilsRuntimeException;
import cn.dolphin.core.util.CastUtil;
import cn.dolphin.core.util.StrUtil;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.Duration;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.time.DateUtils;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public class DateUtil
extends DateUtils {
    private static final Calendar calendar = Calendar.getInstance();

    private DateUtil() {
    }

    public static Date dayBegin(Date date) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.set(11, 0);
        c.set(12, 0);
        c.set(13, 0);
        c.set(14, 0);
        return c.getTime();
    }

    public static Date dayBegin() {
        return DateUtil.dayBegin(DateUtil.day());
    }

    public static Date dayEnd(Date date) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.set(11, 23);
        c.set(12, 59);
        c.set(13, 59);
        c.set(14, 999);
        return c.getTime();
    }

    public static Date dayEnd() {
        return DateUtil.dayEnd(DateUtil.day());
    }

    public static Date day() {
        return new Date();
    }

    public static long getMillis(Date date) {
        calendar.setTime(date);
        return calendar.getTimeInMillis();
    }

    public static DateTime create() {
        return DateTime.now();
    }

    public static DateTime create(long timestamp) {
        String milStr = Long.toString(timestamp);
        if (milStr.length() == 10) {
            timestamp *= 1000L;
        }
        return new DateTime(timestamp);
    }

    public static String getCurrentTime(String format) {
        SimpleDateFormat sdf = DateFormatUtil.getFormat(format);
        Date date = new Date();
        return sdf.format(date);
    }

    public static String format(DateTime dateTime) {
        return DateUtil.format(dateTime, DateEnum.FORMAT_YYMMDDHMS_MID);
    }

    public static String format(DateTime dateTime, DateEnum fmt) {
        return dateTime.toString(DateUtil.getFormatter(fmt));
    }

    public static String format(DateTime dateTime, String format) {
        return dateTime.toString(DateUtil.getFormatter(format));
    }

    public static DateTime parse(String date) {
        return DateUtil.parse(date, DateEnum.FORMAT_YYMMDDHMS_MID);
    }

    public static DateTime parse(String date, DateEnum fmt) {
        return DateUtil.getFormatter(fmt).parseDateTime(date);
    }

    public static DateTime parse(String date, String format) {
        return DateUtil.getFormatter(format).parseDateTime(date);
    }

    public static Map<String, Object> getYearMonthDayParse(String date, String format) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        try {
            SimpleDateFormat sdf = DateFormatUtil.getFormat(format);
            Date d = sdf.parse(date);
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(d);
            result.put("year", calendar.get(1));
            result.put("month", calendar.get(2) + 1);
            result.put("day", calendar.get(5));
        }
        catch (ParseException e) {
            throw new UtilsRuntimeException(e);
        }
        return result;
    }

    public static DateTime addSeconds(DateTime dateTime, int seconds) {
        return dateTime.plusSeconds(seconds);
    }

    public static DateTime addMinutes(DateTime dateTime, int minutes) {
        return dateTime.plusMinutes(minutes);
    }

    public static DateTime addHours(DateTime dateTime, int hours) {
        return dateTime.plusHours(hours);
    }

    public static DateTime addDays(DateTime dateTime, int days) {
        return dateTime.plusDays(days);
    }

    public static DateTime addWeeks(DateTime dateTime, int weeks) {
        return dateTime.plusWeeks(weeks);
    }

    public static DateTime addMonths(DateTime dateTime, int months) {
        return dateTime.plusMonths(months);
    }

    public static DateTime addYears(DateTime dateTime, int years) {
        return dateTime.plusYears(years);
    }

    public static int getDayOfWeek(DateTime dateTime) {
        return dateTime.getDayOfWeek();
    }

    public static int getWeekOfYear(DateTime dateTime) {
        return dateTime.getWeekOfWeekyear();
    }

    public static DateTime getDayOfBegin(DateTime dateTime) {
        return dateTime.withTimeAtStartOfDay();
    }

    public static DateTime getDayOfEnd(DateTime dateTime) {
        return dateTime.millisOfDay().withMaximumValue();
    }

    public static DateTime getWeekOfBegin(DateTime dateTime) {
        return dateTime.dayOfWeek().withMinimumValue();
    }

    public static DateTime getWeekOfEnd(DateTime dateTime) {
        return dateTime.dayOfWeek().withMaximumValue();
    }

    public static DateTime getMonthOfBegin(DateTime dateTime) {
        return dateTime.dayOfMonth().withMinimumValue();
    }

    public static DateTime getMonthOfEnd(DateTime dateTime) {
        return dateTime.dayOfMonth().withMaximumValue();
    }

    public static DateTime getYearOfBegin(DateTime dateTime) {
        return dateTime.dayOfYear().withMinimumValue();
    }

    public static DateTime getYearOfEnd(DateTime dateTime) {
        return dateTime.dayOfYear().withMaximumValue();
    }

    public static int compare(DateTime left, DateTime right) {
        if (left.isBefore((ReadableInstant)right)) {
            return 1;
        }
        if (left.isEqual((ReadableInstant)right)) {
            return 0;
        }
        return -1;
    }

    public static boolean between(DateTime src, DateTime left, DateTime right) {
        return src.isAfter((ReadableInstant)left) && src.isBefore((ReadableInstant)right);
    }

    public static DateTime getHourOfBegin(DateTime dateTime) {
        return dateTime.hourOfDay().roundFloorCopy();
    }

    public static DateTime getMinuteOfBegin(DateTime dateTime) {
        return dateTime.minuteOfDay().roundFloorCopy();
    }

    public static DateTime getSecondOfBegin(DateTime dateTime) {
        return dateTime.secondOfDay().roundFloorCopy();
    }

    private static DateTimeFormatter getFormatter(DateEnum fmt) {
        return DateTimeFormat.forPattern((String)fmt.getFmt());
    }

    private static DateTimeFormatter getFormatter(String format) {
        return DateTimeFormat.forPattern((String)format);
    }

    public static Long getMonthBegin(Long dateTimeMillis) {
        calendar.setTime(new Date(dateTimeMillis));
        calendar.set(5, 1);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar.getTimeInMillis() / 1000L;
    }

    public static Long getMonthEnd(Long dateTimeMillis) {
        calendar.setTime(new Date(dateTimeMillis));
        calendar.set(5, calendar.getActualMaximum(5));
        calendar.set(11, 23);
        calendar.set(12, 59);
        calendar.set(13, 59);
        calendar.set(14, 999);
        return calendar.getTimeInMillis() / 1000L;
    }

    public static Long getMonthMiddle(Long dateTimeMillis) {
        calendar.setTime(new Date(dateTimeMillis));
        calendar.set(5, 15);
        calendar.set(11, 23);
        calendar.set(12, 59);
        calendar.set(13, 59);
        calendar.set(14, 999);
        return calendar.getTimeInMillis() / 1000L;
    }

    public static int getYear() {
        calendar.setTime(new Date());
        return calendar.get(1);
    }

    public static int getYear(Date date) {
        calendar.setTime(date);
        return calendar.get(1);
    }

    public static int getMonth() {
        calendar.setTime(new Date());
        return calendar.get(2) + 1;
    }

    public static int getMonth(Date date) {
        calendar.setTime(date);
        return calendar.get(2) + 1;
    }

    public static int getDay() {
        calendar.setTime(new Date());
        return calendar.get(5);
    }

    public static int getDay(Date date) {
        calendar.setTime(date);
        return calendar.get(5);
    }

    public static int getMaxDay(int year, int month) {
        calendar.set(year, month, 1);
        calendar.add(6, -1);
        return calendar.get(5);
    }

    public static Date getFirstDayOfMonth(int year, int month) {
        calendar.set(1, year);
        calendar.set(2, --month);
        int day = calendar.getActualMinimum(5);
        calendar.set(5, day);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    public static Date getLastDayOfMonth(int year, int month) {
        calendar.set(1, year);
        calendar.set(2, --month);
        int day = calendar.getActualMaximum(5);
        calendar.set(5, day);
        calendar.set(11, 23);
        calendar.set(12, 59);
        calendar.set(13, 59);
        calendar.set(14, 999);
        return calendar.getTime();
    }

    public static int getHour() {
        calendar.setTime(new Date());
        return calendar.get(11);
    }

    public static int getHour(Date date) {
        calendar.setTime(date);
        return calendar.get(11);
    }

    public static int getMinute() {
        calendar.setTime(new Date());
        return calendar.get(12);
    }

    public static int getMinute(Date date) {
        calendar.setTime(date);
        return calendar.get(12);
    }

    public static int getSecond() {
        calendar.setTime(new Date());
        return calendar.get(13);
    }

    public static int getSecond(Date date) {
        calendar.setTime(date);
        return calendar.get(13);
    }

    public static Date unixTimestampToDate(Long time) {
        long temp = time * 1000L;
        Timestamp ts = new Timestamp(temp);
        return ts;
    }

    public static Integer dateToUnixTimestamp(Date time) {
        Timestamp ts = new Timestamp(time.getTime());
        return (int)(ts.getTime() / 1000L);
    }

    public static Date getDayBefore(Date date, String format) {
        calendar.setTime(date);
        int day = calendar.get(5);
        calendar.set(5, day - 1);
        String dayBeforeStr = new SimpleDateFormat(format).format(calendar.getTime());
        Date dayBefore = null;
        try {
            dayBefore = new SimpleDateFormat(format).parse(dayBeforeStr);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return dayBefore;
    }

    public static Date getDayAfter(Date date, String format) {
        calendar.setTime(date);
        int day = calendar.get(5);
        calendar.set(5, day + 1);
        String dayAfterStr = new SimpleDateFormat(format).format(calendar.getTime());
        Date dayAfter = null;
        try {
            dayAfter = new SimpleDateFormat(format).parse(dayAfterStr);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return dayAfter;
    }

    public static Duration duration(Date startDate, Date endDate) {
        return Duration.between(startDate.toInstant(), endDate.toInstant());
    }

    public static long durationNanos(Date startDate, Date endDate) {
        return DateUtil.duration(startDate, endDate).toNanos();
    }

    public static long durationMillis(Date startDate, Date endDate) {
        return DateUtil.duration(startDate, endDate).toMillis();
    }

    public static long durationSeconds(Date startDate, Date endDate) {
        return DateUtil.duration(startDate, endDate).toMillis() / 1000L;
    }

    public static long durationMinutes(Date startDate, Date endDate) {
        return DateUtil.duration(startDate, endDate).toMinutes();
    }

    public static long durationHours(Date startDate, Date endDate) {
        return DateUtil.duration(startDate, endDate).toHours();
    }

    public static long durationDays(Date startDate, Date endDate) {
        return DateUtil.duration(startDate, endDate).toDays();
    }

    public static int getTodayWeek() {
        Calendar now = Calendar.getInstance();
        boolean isFirstSunday = now.getFirstDayOfWeek() == 1;
        int weekDay = now.get(7);
        if (isFirstSunday && --weekDay == 0) {
            weekDay = 7;
        }
        return weekDay;
    }

    public static int dayForWeek(String date, String format) {
        try {
            SimpleDateFormat sdf = DateFormatUtil.getFormat(format);
            Date d = sdf.parse(date);
            long ms = d.getTime();
            long day = ms / 86400000L;
            long week = (day + 4L) % 7L;
            return CastUtil.castInt(week + 1L);
        }
        catch (ParseException e) {
            throw new UtilsRuntimeException(e);
        }
    }

    public static boolean isWeekend(long milliseconds) {
        int dayForWeek = DateUtil.dayForWeek(milliseconds);
        if (dayForWeek == 6) {
            return true;
        }
        return dayForWeek == 7;
    }

    public static int dayForWeek(long milliseconds) {
        try {
            Calendar calendar = Calendar.getInstance();
            calendar.setTimeInMillis(DateUtil.completMilliseconds(milliseconds));
            calendar.setTimeInMillis(DateUtil.completMilliseconds(milliseconds));
            calendar.set(11, 0);
            calendar.set(12, 0);
            calendar.set(13, 0);
            calendar.set(14, 0);
            Integer whatDay = 0;
            if (calendar.get(7) == 7) {
                whatDay = 6;
            }
            if (calendar.get(7) == 1) {
                whatDay = 7;
            }
            if (calendar.get(7) == 2) {
                whatDay = 1;
            }
            if (calendar.get(7) == 3) {
                whatDay = 2;
            }
            if (calendar.get(7) == 4) {
                whatDay = 3;
            }
            if (calendar.get(7) == 5) {
                whatDay = 4;
            }
            if (calendar.get(7) == 6) {
                whatDay = 5;
            }
            return whatDay;
        }
        catch (Exception e) {
            throw new UtilsRuntimeException(e);
        }
    }

    private static long completMilliseconds(long milliseconds) {
        String milStr = Long.toString(milliseconds);
        if (milStr.length() == 10) {
            milliseconds *= 1000L;
        }
        return milliseconds;
    }

    public static Integer toMm(String time) {
        if (StrUtil.isBlank((CharSequence)time)) {
            return 0;
        }
        String[] tim = StrUtil.split(time, ":");
        return Integer.valueOf(tim[0]) * 60 + Integer.valueOf(tim[1]);
    }

    public static void main(String[] args) throws Exception {
        Date date = new Date();
        System.out.println("\u83b7\u53d6\u5f53\u524d\u7cfb\u7edf\u65f6\u95f4\u7684\u5e74\u4efd\uff1a" + DateUtil.getYear());
        System.out.println("\u83b7\u53d6\u5f53\u524d\u7cfb\u7edf\u65f6\u95f4\u7684\u6708\u4efd\uff1a" + DateUtil.getMonth());
        System.out.println("\u83b7\u53d6\u5f53\u524d\u7cfb\u7edf\u65f6\u95f4\u7684\u65e5\u671f\uff1a" + DateUtil.getDay());
        System.out.println("\u83b7\u53d6\u65f6\u95f4\u6233\u7684\u65e5\u671f\uff1a" + DateUtil.getDay(DateUtil.unixTimestampToDate(1575216000L)));
        System.out.println("\u83b7\u53d6\u5f53\u524d\u7cfb\u7edf\u65f6\u95f4\u7684\u5c0f\u65f6\uff1a" + DateUtil.getHour());
        System.out.println("\u83b7\u53d6\u5f53\u524d\u7cfb\u7edf\u65f6\u95f4\u7684\u5206\u949f\uff1a" + DateUtil.getMinute());
        System.out.println("\u83b7\u53d6\u5f53\u524d\u7cfb\u7edf\u65f6\u95f4\u7684\u79d2\u949f\uff1a" + DateUtil.getSecond());
        System.out.println("\u8ba1\u7b97\u6240\u9009\u6708\u7684\u6700\u5927\u5929\u6570\uff1a" + DateUtil.getMaxDay(2019, 12));
        long currentTime = System.currentTimeMillis();
        System.out.println("\u683c\u5f0f\u5316\u65e5\u671f\uff1a" + DateFormatUtil.formatDate(currentTime, DateEnum.FORMAT_YYMMDD_MID));
        System.out.println("\u8f6c\u6362\u65e5\u671f:" + DateUtil.getYearMonthDayParse("2019-12", "yyyy-MM"));
        System.out.println("\u83b7\u53d6\u4eca\u5929\u661f\u671f\u51e0:" + DateUtil.getTodayWeek());
        System.out.println("\u661f\u671f\u51e0:" + DateUtil.dayForWeek("2019-12-05", "yyyy-MM-dd"));
        System.out.println("\u661f\u671f\u51e0:" + DateUtil.dayForWeek(1575527594L));
    }
}

