/*
 * Decompiled with CFR 0.152.
 */
package cn.dolphin.core.date;

import cn.dolphin.core.enums.DateEnum;
import cn.dolphin.core.util.StrUtil;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DateFormatUtil {
    private static final Logger log = LoggerFactory.getLogger(DateFormatUtil.class);
    public static final DateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd");
    public static final DateFormat DATETIME_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    public static final DateFormat DATETIME_NOSECOND_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm");
    public static final DateFormat TIME_FORMAT = new SimpleDateFormat("HH:mm:ss");
    public static final DateFormat TIME_NOSECOND_FORMAT = new SimpleDateFormat("HH:mm");
    public static final DateFormat TIMESTAMP_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
    public static final ThreadLocal<SimpleDateFormat> SDF_DATETIME = new ThreadLocal<SimpleDateFormat>(){

        @Override
        protected SimpleDateFormat initialValue() {
            return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        }
    };
    public static final ThreadLocal<SimpleDateFormat> SDF_DATETIME_NOSEP = new ThreadLocal<SimpleDateFormat>(){

        @Override
        protected SimpleDateFormat initialValue() {
            return new SimpleDateFormat("yyyyMMddHHmmss");
        }
    };
    public static final ThreadLocal<SimpleDateFormat> SDF_DATE_MONTH_NOSEP = new ThreadLocal<SimpleDateFormat>(){

        @Override
        protected SimpleDateFormat initialValue() {
            return new SimpleDateFormat("yyyyMM");
        }
    };
    public static final ThreadLocal<SimpleDateFormat> SDF_DATE = new ThreadLocal<SimpleDateFormat>(){

        @Override
        protected SimpleDateFormat initialValue() {
            return new SimpleDateFormat("yyyy-MM-dd");
        }
    };
    public static final ThreadLocal<SimpleDateFormat> SDF_DATE_NOSEP = new ThreadLocal<SimpleDateFormat>(){

        @Override
        protected SimpleDateFormat initialValue() {
            return new SimpleDateFormat("yyyyMMdd");
        }
    };
    public static final ThreadLocal<SimpleDateFormat> SDF_TIME = new ThreadLocal<SimpleDateFormat>(){

        @Override
        protected SimpleDateFormat initialValue() {
            return new SimpleDateFormat("HH:mm:ss");
        }
    };

    private DateFormatUtil() {
    }

    public static Date parse(String dateString) throws ParseException {
        if (dateString.trim().indexOf(" ") > 0 && dateString.trim().indexOf(".") > 0) {
            return new Timestamp(TIMESTAMP_FORMAT.parse(dateString).getTime());
        }
        if (dateString.trim().indexOf(" ") > 0) {
            if (dateString.trim().indexOf(":") != dateString.trim().lastIndexOf(":")) {
                return new Timestamp(DATETIME_FORMAT.parse(dateString).getTime());
            }
            return new Timestamp(DATETIME_NOSECOND_FORMAT.parse(dateString).getTime());
        }
        if (dateString.indexOf(":") > 0) {
            if (dateString.trim().indexOf(":") != dateString.trim().lastIndexOf(":")) {
                return new Time(TIME_FORMAT.parse(dateString).getTime());
            }
            return new Time(TIME_NOSECOND_FORMAT.parse(dateString).getTime());
        }
        return new java.sql.Date(DATE_FORMAT.parse(dateString).getTime());
    }

    public static Date parseTime(String dateString) throws ParseException {
        if (dateString.trim().indexOf(" ") > 0) {
            String[] d = dateString.trim().split(" ");
            if (dateString.trim().indexOf(":") != dateString.trim().lastIndexOf(":")) {
                return new Timestamp(TIME_FORMAT.parse(d[1]).getTime());
            }
            return new Timestamp(TIME_NOSECOND_FORMAT.parse(d[1]).getTime());
        }
        if (dateString.indexOf(":") > 0) {
            if (dateString.trim().indexOf(":") != dateString.trim().lastIndexOf(":")) {
                return new Time(TIME_FORMAT.parse(dateString).getTime());
            }
            return new Time(TIME_NOSECOND_FORMAT.parse(dateString).getTime());
        }
        return new java.sql.Date(DATETIME_FORMAT.parse(dateString).getTime());
    }

    public static String format(Date date) {
        if (date instanceof Timestamp) {
            return TIMESTAMP_FORMAT.format(date);
        }
        if (date instanceof Time) {
            return TIME_FORMAT.format(date);
        }
        if (date instanceof java.sql.Date) {
            return DATE_FORMAT.format(date);
        }
        return DATETIME_FORMAT.format(date);
    }

    protected static SimpleDateFormat getFormat(String format) {
        if (format == null || "".equals(format)) {
            format = "yyyy-MM-dd HH:mm:ss";
        }
        return new SimpleDateFormat(format);
    }

    public static Date parse(String dateString, String style) {
        try {
            SimpleDateFormat dateFormat = new SimpleDateFormat(style);
            return dateFormat.parse(dateString);
        }
        catch (ParseException e) {
            return null;
        }
    }

    public static String formatDate(String str, String format) {
        if (str == null || str.isEmpty()) {
            return str;
        }
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        try {
            return sdf.format(sdf.parse(str));
        }
        catch (Exception e) {
            log.debug("Date format error: value=" + str + ", error=" + e.toString());
            return str;
        }
    }

    public static String format(Date date, String style) {
        SimpleDateFormat dateFormat = new SimpleDateFormat(style);
        return dateFormat.format(date);
    }

    private static Date format(String value, String format, Locale locale) {
        if (StrUtil.isNotBlank((CharSequence)value) && StrUtil.isNotBlank((CharSequence)format)) {
            SimpleDateFormat df = new SimpleDateFormat(format, locale);
            try {
                return df.parse(value);
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        return null;
    }

    private static Date format(String value, String format) {
        if (StrUtil.isNotBlank((CharSequence)value) && StrUtil.isNotBlank((CharSequence)format)) {
            SimpleDateFormat df = new SimpleDateFormat(format);
            try {
                return df.parse(value);
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        return null;
    }

    public static Date format(String value) {
        Date date = null;
        date = DateFormatUtil.format(value, "yyyy-MM-dd HH:mm:ss");
        if (date != null) {
            return date;
        }
        date = DateFormatUtil.format(value, "yyyy-MM-dd");
        if (date != null) {
            return date;
        }
        date = DateFormatUtil.format(value, "yyyy/MM/dd");
        if (date != null) {
            return date;
        }
        date = DateFormatUtil.format(value, "yyyyMMddHHmmss.SSS");
        if (date != null) {
            return date;
        }
        date = DateFormatUtil.format(value, "yyyyMMddHHmmss");
        if (date != null) {
            return date;
        }
        date = DateFormatUtil.formatByLong(value);
        if (date != null) {
            return date;
        }
        date = DateFormatUtil.format(value, "yyyyMMdd");
        if (date != null) {
            return date;
        }
        date = DateFormatUtil.format(value, "EEE MMM dd HH:mm:ss z yyyy", Locale.US);
        if (date != null) {
            return date;
        }
        date = DateFormatUtil.format(value, "yyyy-MM-dd HH:mm:ss.SSS");
        if (date != null) {
            return date;
        }
        date = DateFormatUtil.format(value, "yyyy/MM/dd HH:mm:ss");
        return date;
    }

    private static Date formatByLong(String value) {
        if (StrUtil.isNotBlank((CharSequence)value) && value.matches("[0-9]{13}")) {
            return new Date(Long.valueOf(value));
        }
        return null;
    }

    public static String formatToHHmmss(long theSecond) {
        int timetiem = (int)theSecond;
        int minute = timetiem / 60;
        int hour = minute / 60;
        int second = timetiem % 60;
        return String.format("%02d:%02d:%02d", hour, minute %= 60, second);
    }

    public static XMLGregorianCalendar formatToXmlDate(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        DatatypeFactory dtf = null;
        try {
            dtf = DatatypeFactory.newInstance();
        }
        catch (DatatypeConfigurationException datatypeConfigurationException) {
            // empty catch block
        }
        XMLGregorianCalendar dateType = dtf.newXMLGregorianCalendar();
        dateType.setYear(cal.get(1));
        dateType.setMonth(cal.get(2) + 1);
        dateType.setDay(cal.get(5));
        dateType.setHour(cal.get(11));
        dateType.setMinute(cal.get(12));
        dateType.setSecond(cal.get(13));
        return dateType;
    }

    public static Date format(XMLGregorianCalendar cal) {
        return cal.toGregorianCalendar().getTime();
    }

    public static Date parseDate(String dateString) throws ParseException {
        return DATE_FORMAT.parse(dateString);
    }

    public static String formatDate(Date date) {
        return DATE_FORMAT.format(date);
    }

    public static String formatDate(long time, DateEnum format) {
        if (time > 0L && StrUtil.isNotBlank((CharSequence)format.getFmt())) {
            SimpleDateFormat dateFormat = new SimpleDateFormat(format.getFmt());
            Date date = new Date(time);
            return dateFormat.format(date);
        }
        return "";
    }

    public static Date parseDateTime(String dateString) throws ParseException {
        return DATETIME_FORMAT.parse(dateString);
    }

    public static String formaDatetTime(Date date) {
        return DATETIME_FORMAT.format(date);
    }

    public static String formatTimeNoSecond(Date date) {
        return DATETIME_NOSECOND_FORMAT.format(date);
    }

    public static Date parseTimeNoSecond(String dateString) throws ParseException {
        return DATETIME_NOSECOND_FORMAT.parse(dateString);
    }

    public static String getNowByString(String style) {
        if (null == style || "".equals(style)) {
            style = "yyyy-MM-dd HH:mm:ss";
        }
        return DateFormatUtil.format(new Date(), style);
    }
}

