/*
 * Decompiled with CFR 0.152.
 */
package cn.dolphin.core.date;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

public class CalendarUtil {
    public static final long ONE_SECOND_MILLIS = 1000L;
    public static final long ONE_MINUTE_MILLIS = 60000L;
    public static final long ONE_HOUR_MILLIS = 3600000L;
    public static final long ONE_DAY_MILLIS = 86400000L;
    public static final long ONE_WEEK_MILLIS = 604800000L;
    public static final long ONE_MONTH_MILLIS = 2592000000L;
    public static final long ONE_YEAR_MILLIS = 31536000000L;

    public static String format(Calendar calendar, String pattern) {
        Calendar cal;
        Calendar calendar2 = cal = null == calendar ? Calendar.getInstance() : calendar;
        if (pattern == null || pattern.equals("")) {
            pattern = "yyyy-MM-dd HH:mm:ss";
        }
        return new SimpleDateFormat(pattern).format(cal.getTime());
    }

    public static Calendar format(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        return cal;
    }

    public static Date format(Calendar calendar) {
        return calendar.getTime();
    }

    public static int getYear(Calendar calendar) {
        if (calendar != null) {
            return calendar.get(1);
        }
        return Calendar.getInstance().get(1);
    }

    public static int getMonth(Calendar calendar) {
        if (calendar != null) {
            return calendar.get(2);
        }
        return Calendar.getInstance().get(2);
    }

    public static int getDate(Calendar calendar) {
        if (calendar != null) {
            return calendar.get(5);
        }
        return Calendar.getInstance().get(5);
    }

    public static int getWeek(Calendar calendar) {
        if (calendar != null) {
            return calendar.get(7);
        }
        return Calendar.getInstance().get(7);
    }

    public static int getHour(Calendar calendar) {
        if (calendar != null) {
            return calendar.get(10);
        }
        return Calendar.getInstance().get(10);
    }

    public static int getMinute(Calendar calendar) {
        if (calendar != null) {
            return calendar.get(12);
        }
        return Calendar.getInstance().get(12);
    }

    public static int getSecond(Calendar calendar) {
        if (calendar != null) {
            return calendar.get(13);
        }
        return Calendar.getInstance().get(13);
    }

    public static Calendar beforeSomeDays(Calendar calendar, int days) {
        long offset = (long)days * 86400000L;
        Calendar cal = null == calendar ? Calendar.getInstance() : calendar;
        cal.setTimeInMillis(cal.getTimeInMillis() - offset);
        return cal;
    }

    public static Calendar afterSomeDays(Calendar calendar, int days) {
        long offset = (long)days * 86400000L;
        Calendar cal = null == calendar ? Calendar.getInstance() : calendar;
        cal.setTimeInMillis(cal.getTimeInMillis() + offset);
        return cal;
    }

    public static Calendar yesterday(Calendar calendar) {
        return CalendarUtil.beforeSomeDays(calendar, 1);
    }

    public static Calendar tomorrow(Calendar calendar) {
        return CalendarUtil.afterSomeDays(calendar, 1);
    }

    public static Calendar before(Calendar calendar, long offsetMillis) {
        Calendar cal = null == calendar ? Calendar.getInstance() : calendar;
        cal.setTimeInMillis(cal.getTimeInMillis() - offsetMillis);
        return cal;
    }

    public static Calendar after(Calendar calendar, long offset) {
        Calendar cal = null == calendar ? Calendar.getInstance() : calendar;
        cal.setTimeInMillis(cal.getTimeInMillis() - offset);
        return cal;
    }

    public static String getTimeString() {
        return CalendarUtil.format(Calendar.getInstance(), "yyyy-MM-dd HH:mm:ss");
    }
}

