/*
 * Decompiled with CFR 0.152.
 */
package cn.dolphin.core.cookie;

import cn.dolphin.core.web.util.ParamEmptyUtil;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;

public final class CookieUtil {
    public static final Integer MAX_AGE = 2592000;
    public static final Integer SESSION_AGE = -1;

    public static final void delCookie(HttpServletResponse response, String domain, String path, String cookieName) {
        if (response == null) {
            return;
        }
        if (ParamEmptyUtil.isBlank(domain, cookieName)) {
            return;
        }
        path = StringUtils.isBlank((CharSequence)path) ? "/" : path;
        Cookie coo = new Cookie(cookieName, "");
        coo.setMaxAge(0);
        coo.setPath(path);
        coo.setDomain(domain);
        response.addCookie(coo);
    }

    public static final void delCookie(HttpServletResponse response, String domain, String cookieName) {
        CookieUtil.delCookie(response, domain, null, cookieName);
    }

    public static final void setCookie(HttpServletResponse response, String domain, String path, String cookieName, String value, Integer age) {
        if (response == null) {
            return;
        }
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{domain, cookieName})) {
            return;
        }
        age = age == null || age < -1 ? -1 : age;
        age = age > 0 && age > MAX_AGE ? MAX_AGE : age;
        path = StringUtils.isBlank((CharSequence)path) ? "/" : path;
        Cookie coo = new Cookie(cookieName, value);
        coo.setMaxAge(age.intValue());
        coo.setPath(path);
        coo.setDomain(domain);
        response.addCookie(coo);
    }

    public static final void setCookie(HttpServletResponse response, String domain, String cookieName, String value, Integer age) {
        CookieUtil.setCookie(response, domain, null, cookieName, value, age);
    }

    public static final void setCookie(HttpServletResponse response, String domain, String cookieName, String value) {
        CookieUtil.setCookie(response, domain, null, cookieName, value, null);
    }

    public static final String getCookie(HttpServletRequest request, String cookieName) {
        if (request == null || StringUtils.isBlank((CharSequence)cookieName)) {
            return "";
        }
        Cookie[] cookies = request.getCookies();
        if (cookies == null || cookies.length == 0) {
            return null;
        }
        for (int i = 0; i < cookies.length; ++i) {
            if (!cookieName.equals(cookies[i].getName())) continue;
            return cookies[i].getValue();
        }
        return "";
    }
}

