/*
 * Decompiled with CFR 0.152.
 */
package cn.dolphin.core.cache.map.impl;

import cn.dolphin.core.cache.map.ICache;
import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConcurrentMapCache
implements ICache {
    private static final Logger log = LoggerFactory.getLogger(ConcurrentMapCache.class);
    private static final ConcurrentMap<Object, Object> cache = new ConcurrentHashMap<Object, Object>();

    @Override
    public int getSize() {
        return cache.size();
    }

    @Override
    public synchronized void putObject(Object key, Object value) {
        cache.put(key, value);
        log.debug("Storing " + key + " to cache.");
    }

    @Override
    public synchronized Object getObject(Object key) {
        Object value = cache.get(key);
        if (log.isDebugEnabled()) {
            if (value == null) {
                log.debug(key + " cache not exists.");
            } else {
                log.debug("Reading " + key + " from cache.");
            }
        }
        return value;
    }

    @Override
    public synchronized Object removeObject(Object key) {
        log.debug("Removing " + key + " from cache.");
        return cache.remove(key);
    }

    @Override
    public synchronized void clear(String id) {
        Iterator iter = cache.keySet().iterator();
        while (iter.hasNext()) {
            String key = String.valueOf(iter.next());
            if (key.indexOf(id) == -1) continue;
            log.debug("Clearing " + key + " from cache.");
            cache.remove(key);
        }
        log.debug("Clearing *" + id + "* from cache.");
    }

    @Override
    public synchronized void putObject(Object key, Object value, int seconds) {
        this.putObject(key, value);
        log.debug("Storing " + key + " to cache[seconds:" + seconds + "].");
    }
}

