/*
 * Decompiled with CFR 0.152.
 */
package cn.dolphin.core.cache.ehcache;

import java.io.InputStream;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.CacheManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UCacheManager {
    static final Logger log = LoggerFactory.getLogger(UCacheManager.class);
    public static CacheManager manager;
    protected Cache cache;

    public UCacheManager() {
        try {
            manager = CacheManager.getInstance();
            if (manager == null) {
                manager = CacheManager.create();
                log.info("Initialize cache manager: " + manager);
            }
        }
        catch (CacheException e) {
            log.error("Initialize cache manager failed.", (Throwable)e);
        }
    }

    public UCacheManager(String configFile) {
        try {
            manager = CacheManager.getInstance();
            if (manager == null) {
                manager = CacheManager.create((String)configFile);
                log.info("Initialize cache manager: " + manager);
            }
        }
        catch (CacheException e) {
            log.error("Initialize cache manager failed.", (Throwable)e);
        }
    }

    public UCacheManager(InputStream is) {
        try {
            manager = CacheManager.getInstance();
            if (manager == null) {
                manager = CacheManager.create((InputStream)is);
                log.info("Initialize cache manager: " + manager);
            }
        }
        catch (CacheException e) {
            log.error("Initialize cache manager failed.", (Throwable)e);
        }
        finally {
            try {
                is.close();
            }
            catch (Exception exception) {}
        }
    }

    public static void shutdown() {
        if (manager != null) {
            log.info("Cache manager shutdown!!!");
            try {
                manager.shutdown();
            }
            catch (CacheException e) {
                log.error("Cache manager shutdown failed.", (Throwable)e);
            }
        }
    }
}

