/*
 * Decompiled with CFR 0.152.
 */
package cn.dolphin.core.cache.ehcache;

import cn.dolphin.core.cache.ehcache.CacheHelper;
import java.util.List;
import java.util.Map;

public class CacheUtils {
    private static CacheHelper cache;

    protected static CacheHelper getCache() {
        if (cache == null) {
            cache = CacheHelper.getCache("ONE_DAY");
        }
        return cache;
    }

    public static boolean put(Object key, Object value) {
        return CacheUtils.getCache().put(key, value);
    }

    public static <T> T get(Object key) {
        return CacheUtils.getCache().get(key);
    }

    public static String getString(Object key) {
        return (String)CacheUtils.getCache().get(key);
    }

    public static Map getMap(Object key) {
        return (Map)CacheUtils.getCache().get(key);
    }

    public static <T> List<T> getList(Object key) {
        return (List)CacheUtils.getCache().get(key);
    }

    public static int getInt(Object key) {
        Object o = CacheUtils.getCache().get(key);
        if (o == null) {
            return -1;
        }
        return (Integer)o;
    }

    public static short getShort(Object key) {
        Object o = CacheUtils.getCache().get(key);
        if (o == null) {
            return -1;
        }
        return (Short)o;
    }

    public static long getLong(Object key) {
        Object o = CacheUtils.getCache().get(key);
        if (o == null) {
            return -1L;
        }
        return (Long)o;
    }

    public static float getFloat(Object key) {
        Object o = CacheUtils.getCache().get(key);
        if (o == null) {
            return -1.0f;
        }
        return ((Float)o).floatValue();
    }

    public static double getDouble(Object key) {
        Object o = CacheUtils.getCache().get(key);
        if (o == null) {
            return -1.0;
        }
        return (Double)o;
    }

    public static byte[] getBytes(Object key) {
        return (byte[])CacheUtils.getCache().get(key);
    }

    public static Byte getByte(Object key) {
        return (Byte)CacheUtils.getCache().get(key);
    }

    public static int[] getIntArray(Object key) {
        return (int[])CacheUtils.getCache().get(key);
    }

    public static <T> T[] getArray(Object key, Class<T> clazz) {
        return (Object[])CacheUtils.getCache().get(key);
    }

    public static boolean exists(Object key) {
        return CacheUtils.getCache().exists(key);
    }

    public static boolean remove(String key) {
        return CacheUtils.getCache().remove(key);
    }

    public static List getKeys() {
        return CacheUtils.getCache().getKeys();
    }
}

