/*
 * Decompiled with CFR 0.152.
 */
package cn.dolphin.core.bean;

import cn.dolphin.core.exception.UtilsRuntimeException;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.ref.Reference;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.WeakHashMap;
import org.apache.commons.lang3.StringUtils;

public class IntrospectionCache {
    public static final Map<Class<?>, Map<Class<?>, Object>> classCache = Collections.synchronizedMap(new WeakHashMap());
    private final Map<String, PropertyDescriptor> propertyDescriptorCache;

    private IntrospectionCache(Class<?> beanClass, Class<?> stopClass) {
        try {
            PropertyDescriptor[] pds;
            BeanInfo beanInfo = stopClass == null ? Introspector.getBeanInfo(beanClass) : Introspector.getBeanInfo(beanClass, stopClass);
            Class<?> classToFlush = beanClass;
            do {
                Introspector.flushFromCaches(classToFlush);
            } while ((classToFlush = classToFlush.getSuperclass()) != null);
            this.propertyDescriptorCache = new LinkedHashMap<String, PropertyDescriptor>();
            for (PropertyDescriptor pd : pds = beanInfo.getPropertyDescriptors()) {
                if (Class.class.equals(beanClass) && "classLoader".equals(pd.getName())) continue;
                this.propertyDescriptorCache.put(pd.getName(), pd);
            }
        }
        catch (IntrospectionException ex) {
            throw new UtilsRuntimeException("\u4f7f\u7528Introspector\u83b7\u53d6BeanInfo\u65f6\u51fa\u73b0\u5f02\u5e38", ex);
        }
    }

    public static IntrospectionCache forClass(Class<?> beanClass) {
        return IntrospectionCache.forClass(beanClass, null);
    }

    public static IntrospectionCache forClass(Class<?> beanClass, Class<?> stopClass) {
        IntrospectionCache introspectionCache;
        Class<?> stopCls;
        Object value;
        Map<Class<?>, Object> map = classCache.get(beanClass);
        if (map == null) {
            map = new HashMap();
            classCache.put(beanClass, map);
        }
        if ((value = map.get(stopCls = stopClass == null ? beanClass : stopClass)) instanceof Reference) {
            Reference ref = (Reference)value;
            introspectionCache = (IntrospectionCache)ref.get();
        } else {
            introspectionCache = (IntrospectionCache)value;
        }
        if (introspectionCache == null) {
            introspectionCache = new IntrospectionCache(beanClass, stopClass);
            map.put(stopCls, introspectionCache);
        }
        return introspectionCache;
    }

    public PropertyDescriptor[] getPropertyDescriptors() {
        PropertyDescriptor[] pds = new PropertyDescriptor[this.propertyDescriptorCache.size()];
        int i = 0;
        Iterator<PropertyDescriptor> iterator = this.propertyDescriptorCache.values().iterator();
        while (iterator.hasNext()) {
            PropertyDescriptor pd;
            pds[i] = pd = iterator.next();
            ++i;
        }
        return pds;
    }

    public PropertyDescriptor getPropertyDescriptor(String name) {
        PropertyDescriptor pd = this.propertyDescriptorCache.get(name);
        if (pd == null && StringUtils.isNotBlank((CharSequence)name) && (pd = this.propertyDescriptorCache.get(name.substring(0, 1).toLowerCase() + name.substring(1))) == null) {
            pd = this.propertyDescriptorCache.get(name.substring(0, 1).toUpperCase() + name.substring(1));
        }
        return pd;
    }
}

