/*
 * Decompiled with CFR 0.152.
 */
package cn.dolphin.core.bean;

public class Indicator {
    private long start;
    private long total;
    private long limit;
    private long part;
    private long lastPart;
    private long current;
    private long position;
    private long count;
    private long target;

    public Indicator start(long start) {
        this.start = start;
        return this;
    }

    public Indicator total(long total) {
        this.total = total;
        return this;
    }

    public Indicator limit(long limit) {
        if (limit <= 0L) {
            throw new ArithmeticException("below 0");
        }
        this.limit = limit;
        return this;
    }

    public Indicator ok() {
        this.total -= this.start;
        this.part = (long)Math.ceil((double)this.total / (double)this.limit);
        this.lastPart = this.total - (this.part - 1L) * this.limit;
        this.target += this.start;
        return this;
    }

    public boolean hasNext() {
        return this.current < this.part;
    }

    public long next() {
        ++this.current;
        this.count = this.current == this.part ? this.lastPart : this.limit;
        this.target += this.count;
        this.position = this.target - this.count;
        return this.count;
    }

    public long position() {
        return this.position;
    }

    public long count() {
        return this.count;
    }

    public long target() {
        return this.target;
    }

    public static void main(String[] args) {
        Indicator indicator = new Indicator().start(3L).total(10L).limit(3L).ok();
        while (indicator.hasNext()) {
            indicator.next();
            System.out.println("\u7247\u6bb5\u603b\u6570\uff1a" + indicator.count());
            System.out.println("\u5f00\u59cb\u4f4d\u7f6e\uff1a" + indicator.position());
            System.out.println("\u7ed3\u5c3e\u4f4d\u7f6e\uff1a" + indicator.target());
            System.out.println("------------------------------");
        }
    }
}

