/*
 * Decompiled with CFR 0.152.
 */
package cn.dolphin.core.bean;

import java.lang.ref.Reference;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.WeakHashMap;

public class BeanFieldCache {
    public static final Map<Class<?>, Map<Class<?>, Object>> classCache = Collections.synchronizedMap(new WeakHashMap());
    private final Map<String, Field> beanFieldCache;

    private BeanFieldCache(Class<?> beanClass, Class<?> stopClass) {
        ArrayList<Field> fieldList = new ArrayList<Field>();
        for (Class<?> parentClass = beanClass; parentClass != stopClass; parentClass = parentClass.getSuperclass()) {
            fieldList.addAll(Arrays.asList(parentClass.getDeclaredFields()));
        }
        this.beanFieldCache = new LinkedHashMap<String, Field>();
        for (Field field : fieldList) {
            this.beanFieldCache.put(field.getName(), field);
        }
    }

    public static BeanFieldCache forClass(Class<?> beanClass) {
        return BeanFieldCache.forClass(beanClass, null);
    }

    public static BeanFieldCache forClass(Class<?> beanClass, Class<?> stopClass) {
        BeanFieldCache beanFieldCache;
        Class<?> stopCls;
        Object value;
        Map<Class<?>, Object> map = classCache.get(beanClass);
        if (map == null) {
            map = new HashMap();
            classCache.put(beanClass, map);
        }
        if ((value = map.get(stopCls = stopClass == null ? beanClass : stopClass)) instanceof Reference) {
            Reference ref = (Reference)value;
            beanFieldCache = (BeanFieldCache)ref.get();
        } else {
            beanFieldCache = (BeanFieldCache)value;
        }
        if (beanFieldCache == null) {
            beanFieldCache = new BeanFieldCache(beanClass, stopClass);
            map.put(stopCls, beanFieldCache);
        }
        return beanFieldCache;
    }

    public Field[] getBeanFields() {
        Field[] fields = new Field[this.beanFieldCache.size()];
        int i = 0;
        Iterator<Field> iterator = this.beanFieldCache.values().iterator();
        while (iterator.hasNext()) {
            Field field;
            fields[i] = field = iterator.next();
            ++i;
        }
        return fields;
    }

    public Field getBeanField(String name) {
        Field field = this.beanFieldCache.get(name);
        return field;
    }
}

