/*
 * Decompiled with CFR 0.152.
 */
package cn.dolphin.codegen.util;

import cn.dolphin.core.util.StrUtil;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.beanutils.ConvertUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.support.PropertiesLoaderUtils;
import org.springframework.util.Assert;

public class PropUtils {
    private static final Logger logger = LoggerFactory.getLogger(PropUtils.class);
    private static final Properties prop = PropUtils.genConfigProperties();

    private static Properties genConfigProperties() {
        try {
            return PropertiesLoaderUtils.loadAllProperties((String)"codegen/codegen.properties");
        }
        catch (IOException e) {
            logger.error("\u52a0\u8f7d\u6570\u636e\u5e93\u914d\u7f6e\u6587\u4ef6\u5931\u8d25\u5931\u8d25", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public static <T> T getValue(String key, Class<T> classType, T defaultVal) {
        Assert.notNull((Object)key, (String)"key\u4e0d\u80fd\u4e3a\u7a7a");
        String strVal = prop.getProperty(key);
        return (T)(null != strVal && !strVal.isEmpty() ? (null == classType ? strVal : (classType.isAssignableFrom(strVal.getClass()) ? strVal : ConvertUtils.convert((String)strVal, classType))) : defaultVal);
    }

    public static <T> T getValue(String key, T defaultVal) {
        return (T)PropUtils.getValue(key, defaultVal.getClass(), defaultVal);
    }

    public static String getValue(String key, String defaultVal) {
        return PropUtils.getValue(key, String.class, defaultVal);
    }

    public static String getValue(String key) {
        return PropUtils.getValue(key, (String)null);
    }

    public static Set<String> keySetStartWith(String prefix) {
        if (StrUtil.isBlank((CharSequence)prefix)) {
            prefix = null;
        }
        LinkedHashSet<String> keys = new LinkedHashSet<String>();
        Iterator<Object> var2 = prop.keySet().iterator();
        while (var2.hasNext()) {
            Object key = var2.next();
            if (!(key instanceof String) || null != prefix && !((String)key).startsWith(prefix)) continue;
            keys.add((String)key);
        }
        return keys;
    }
}

