/*
 * Decompiled with CFR 0.152.
 */
package cn.dolphin.codegen.dao;

import cn.dolphin.codegen.model.Field;
import cn.dolphin.codegen.model.Table;
import cn.dolphin.codegen.util.DB;
import cn.dolphin.core.enums.SecurityEnum;
import cn.dolphin.core.exception.ApiException;
import cn.dolphin.core.util.CamelCaseUtil;
import cn.dolphin.core.util.ClassUtil;
import cn.dolphin.core.util.ListUtil;
import cn.dolphin.core.util.StrUtil;
import java.util.List;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;

public class DataDao {
    private JdbcTemplate jdbcTemplate;
    private String driver;
    private String jdbcurl;
    private String username;
    private String password;
    private String tableSchema;
    private String tableName;
    private final String tableSql = "select table_name as name,table_comment as description from information_schema.tables where table_schema='%s' and table_name = '%s' ";
    private final String fildSql = "SELECT c.COLUMN_NAME as name,c.DATA_TYPE as type,IFNULL(c.CHARACTER_MAXIMUM_LENGTH,0) as maxLength,(CASE c.IS_NULLABLE WHEN 'NO' THEN 0 ELSE 1 END) as isNullable,(CASE WHEN t.AUTO_INCREMENT>0 AND k.COLUMN_NAME IS NOT NULL AND c.EXTRA='auto_increment' THEN 1 ELSE 0 END) as isIdentity,c.COLUMN_COMMENT as description,(CASE c.COLUMN_KEY WHEN 'PRI' THEN 1 ELSE 0 END) as isPk FROM information_schema.COLUMNS AS c INNER JOIN information_schema.`TABLES` AS t ON t.TABLE_SCHEMA=c.TABLE_SCHEMA AND t.TABLE_NAME=c.TABLE_NAME  LEFT JOIN information_schema.KEY_COLUMN_USAGE k ON k.COLUMN_NAME=c.COLUMN_NAME AND c.TABLE_NAME=k.TABLE_NAME AND c.TABLE_SCHEMA=k.TABLE_SCHEMA WHERE c.TABLE_SCHEMA='%s' AND c.TABLE_NAME='%s'  ORDER BY c.ORDINAL_POSITION ASC";

    public DataDao() {
    }

    public DataDao(String driver, String jdbcurl, String username, String password) {
        this.driver = driver;
        this.jdbcurl = jdbcurl;
        this.username = username;
        this.password = password;
    }

    public Table getTables(Class<?> clazz) {
        try {
            this.jdbcTemplate = DB.getJdbcTemplate(this.driver, this.jdbcurl, this.username, this.password);
            String sql = String.format("select table_name as name,table_comment as description from information_schema.tables where table_schema='%s' and table_name = '%s' ", this.tableSchema, this.tableName);
            List tableList = this.jdbcTemplate.query(sql, (RowMapper)new BeanPropertyRowMapper(Table.class));
            tableList.forEach(table -> {
                table.setProName(ClassUtil.getClassName(clazz));
                table.setProNameUrl(ClassUtil.getClass(clazz));
                table.setDescription(StrUtil.toDefault(table.getDescription(), ""));
            });
            if (ListUtil.isEmpty(tableList)) {
                throw new ApiException(SecurityEnum.API_000006.code(), "\u6307\u5b9a\u7684\u8868\u540d\u672a\u627e\u5230\uff01");
            }
            return (Table)tableList.get(0);
        }
        catch (Exception e) {
            throw new ApiException(e.getMessage(), e);
        }
    }

    public List<Field> getAllColums() {
        try {
            this.jdbcTemplate = DB.getJdbcTemplate(this.driver, this.jdbcurl, this.username, this.password);
            String sql = String.format("SELECT c.COLUMN_NAME as name,c.DATA_TYPE as type,IFNULL(c.CHARACTER_MAXIMUM_LENGTH,0) as maxLength,(CASE c.IS_NULLABLE WHEN 'NO' THEN 0 ELSE 1 END) as isNullable,(CASE WHEN t.AUTO_INCREMENT>0 AND k.COLUMN_NAME IS NOT NULL AND c.EXTRA='auto_increment' THEN 1 ELSE 0 END) as isIdentity,c.COLUMN_COMMENT as description,(CASE c.COLUMN_KEY WHEN 'PRI' THEN 1 ELSE 0 END) as isPk FROM information_schema.COLUMNS AS c INNER JOIN information_schema.`TABLES` AS t ON t.TABLE_SCHEMA=c.TABLE_SCHEMA AND t.TABLE_NAME=c.TABLE_NAME  LEFT JOIN information_schema.KEY_COLUMN_USAGE k ON k.COLUMN_NAME=c.COLUMN_NAME AND c.TABLE_NAME=k.TABLE_NAME AND c.TABLE_SCHEMA=k.TABLE_SCHEMA WHERE c.TABLE_SCHEMA='%s' AND c.TABLE_NAME='%s'  ORDER BY c.ORDINAL_POSITION ASC", this.tableSchema, this.tableName);
            List fieldList = this.jdbcTemplate.query(sql, (RowMapper)new BeanPropertyRowMapper(Field.class));
            fieldList.forEach(field -> {
                field.setProName(CamelCaseUtil.toCamelCase(field.getName()));
                String fieldType = field.getType().toUpperCase();
                String javaType = DB.convertToJavaType(fieldType);
                field.setType(javaType);
                field.setJdbcType(DB.convertToJdbcType(fieldType));
                field.setDescription(StrUtil.toDefault(field.getDescription(), ""));
            });
            if (ListUtil.isEmpty(fieldList)) {
                throw new ApiException(SecurityEnum.API_000006.code(), "\u8868\u540d\u83b7\u53d6\u6240\u6709\u7684\u5217\u4fe1\u606f\u83b7\u53d6\u5f02\u5e38\uff01");
            }
            return fieldList;
        }
        catch (Exception e) {
            throw new ApiException(e.getMessage(), e);
        }
    }

    public static void main(String[] args) {
        DataDao dataDao = new DataDao();
        dataDao.setDriver("com.mysql.cj.jdbc.Driver").setJdbcurl("jdbc:mysql://10.15.2.201:3306/ncai_email_2019?useUnicode=true&characterEncoding=utf-8&allowMultiQueries=true").setUsername("root").setPassword("9aHta4gDtPuk").setTableSchema("ncai_email_2019").setTableName("email_send_log");
        System.out.println(dataDao.getAllColums());
    }

    public JdbcTemplate getJdbcTemplate() {
        return this.jdbcTemplate;
    }

    public String getDriver() {
        return this.driver;
    }

    public String getJdbcurl() {
        return this.jdbcurl;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getTableSchema() {
        return this.tableSchema;
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getTableSql() {
        return this.tableSql;
    }

    public String getFildSql() {
        return this.fildSql;
    }

    public DataDao setJdbcTemplate(JdbcTemplate jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
        return this;
    }

    public DataDao setDriver(String driver) {
        this.driver = driver;
        return this;
    }

    public DataDao setJdbcurl(String jdbcurl) {
        this.jdbcurl = jdbcurl;
        return this;
    }

    public DataDao setUsername(String username) {
        this.username = username;
        return this;
    }

    public DataDao setPassword(String password) {
        this.password = password;
        return this;
    }

    public DataDao setTableSchema(String tableSchema) {
        this.tableSchema = tableSchema;
        return this;
    }

    public DataDao setTableName(String tableName) {
        this.tableName = tableName;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DataDao)) {
            return false;
        }
        DataDao other = (DataDao)o;
        if (!other.canEqual(this)) {
            return false;
        }
        JdbcTemplate this$jdbcTemplate = this.getJdbcTemplate();
        JdbcTemplate other$jdbcTemplate = other.getJdbcTemplate();
        if (this$jdbcTemplate == null ? other$jdbcTemplate != null : !this$jdbcTemplate.equals(other$jdbcTemplate)) {
            return false;
        }
        String this$driver = this.getDriver();
        String other$driver = other.getDriver();
        if (this$driver == null ? other$driver != null : !this$driver.equals(other$driver)) {
            return false;
        }
        String this$jdbcurl = this.getJdbcurl();
        String other$jdbcurl = other.getJdbcurl();
        if (this$jdbcurl == null ? other$jdbcurl != null : !this$jdbcurl.equals(other$jdbcurl)) {
            return false;
        }
        String this$username = this.getUsername();
        String other$username = other.getUsername();
        if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
            return false;
        }
        String this$password = this.getPassword();
        String other$password = other.getPassword();
        if (this$password == null ? other$password != null : !this$password.equals(other$password)) {
            return false;
        }
        String this$tableSchema = this.getTableSchema();
        String other$tableSchema = other.getTableSchema();
        if (this$tableSchema == null ? other$tableSchema != null : !this$tableSchema.equals(other$tableSchema)) {
            return false;
        }
        String this$tableName = this.getTableName();
        String other$tableName = other.getTableName();
        if (this$tableName == null ? other$tableName != null : !this$tableName.equals(other$tableName)) {
            return false;
        }
        String this$tableSql = this.getTableSql();
        String other$tableSql = other.getTableSql();
        if (this$tableSql == null ? other$tableSql != null : !this$tableSql.equals(other$tableSql)) {
            return false;
        }
        String this$fildSql = this.getFildSql();
        String other$fildSql = other.getFildSql();
        return !(this$fildSql == null ? other$fildSql != null : !this$fildSql.equals(other$fildSql));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DataDao;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        JdbcTemplate $jdbcTemplate = this.getJdbcTemplate();
        result = result * 59 + ($jdbcTemplate == null ? 43 : $jdbcTemplate.hashCode());
        String $driver = this.getDriver();
        result = result * 59 + ($driver == null ? 43 : $driver.hashCode());
        String $jdbcurl = this.getJdbcurl();
        result = result * 59 + ($jdbcurl == null ? 43 : $jdbcurl.hashCode());
        String $username = this.getUsername();
        result = result * 59 + ($username == null ? 43 : $username.hashCode());
        String $password = this.getPassword();
        result = result * 59 + ($password == null ? 43 : $password.hashCode());
        String $tableSchema = this.getTableSchema();
        result = result * 59 + ($tableSchema == null ? 43 : $tableSchema.hashCode());
        String $tableName = this.getTableName();
        result = result * 59 + ($tableName == null ? 43 : $tableName.hashCode());
        String $tableSql = this.getTableSql();
        result = result * 59 + ($tableSql == null ? 43 : $tableSql.hashCode());
        String $fildSql = this.getFildSql();
        result = result * 59 + ($fildSql == null ? 43 : $fildSql.hashCode());
        return result;
    }

    public String toString() {
        return "DataDao(jdbcTemplate=" + this.getJdbcTemplate() + ", driver=" + this.getDriver() + ", jdbcurl=" + this.getJdbcurl() + ", username=" + this.getUsername() + ", password=" + this.getPassword() + ", tableSchema=" + this.getTableSchema() + ", tableName=" + this.getTableName() + ", tableSql=" + this.getTableSql() + ", fildSql=" + this.getFildSql() + ")";
    }
}

