/*
 * Decompiled with CFR 0.152.
 */
package cn.dolphin.codegen;

import cn.dolphin.codegen.dao.DataDao;
import cn.dolphin.codegen.model.Field;
import cn.dolphin.codegen.model.Table;
import cn.dolphin.codegen.service.DataService;
import cn.dolphin.codegen.service.impl.DataServiceImpl;
import cn.dolphin.core.freemarker.FreemarkerUtil;
import cn.dolphin.core.map.MapUtil;
import cn.dolphin.core.util.CamelCaseUtil;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CodeGen {
    private static final Logger logger = LoggerFactory.getLogger(CodeGen.class);
    private static DataService dataService = new DataServiceImpl();
    private static DataDao dataDao = new DataDao();

    protected static void generateModel(Class<?> clazz) {
        Table table = dataDao.getTables(clazz);
        List<Field> fieldList = dataDao.getAllColums();
        System.out.println("=====================================================================================================================");
        System.out.println("\u4ee3\u7801\u751f\u6210\u5668\uff5b\u6a21\u578b\u751f\u6210\uff5dStart");
        CodeGen.generateFile("ModelTemplate.ftl", table, fieldList, 1);
    }

    protected static void generateDao(Class<?> clazz) {
        Table table = dataDao.getTables(clazz);
        List<Field> fieldList = dataDao.getAllColums();
        System.out.println("\u4ee3\u7801\u751f\u6210\u5668\uff5bDAO\u751f\u6210\uff5dStart");
        CodeGen.generateFile("DaoTemplate.ftl", table, fieldList, 2);
    }

    protected static void generateMapper(Class<?> clazz) {
        Table table = dataDao.getTables(clazz);
        List<Field> fieldList = dataDao.getAllColums();
        System.out.println("\u4ee3\u7801\u751f\u6210\u5668\uff5bMapper.xml\u751f\u6210\uff5dStart");
        CodeGen.generateFile("MapperTemplate.ftl", table, fieldList, 3);
    }

    protected static void generateFile(String templateName, Table table, List<Field> fieldList, Integer type) {
        Map<String, Object> templateData = dataService.getDbTemplateData(table, fieldList);
        if (type == 1) {
            System.out.println("model\u540d\u79f0\uff1a" + CamelCaseUtil.toCapitalizeCamelCase(MapUtil.getString(templateData, "tableProName", "")));
        } else if (type == 2) {
            System.out.println("dao\u540d\u79f0\uff1a" + CamelCaseUtil.toCapitalizeCamelCase(MapUtil.getString(templateData, "tableProName", "") + "Dao"));
        } else if (type == 3) {
            System.out.println("mapper\u540d\u79f0\uff1a" + CamelCaseUtil.toCapitalizeCamelCase(MapUtil.getString(templateData, "tableProName", "") + "Dao.xml"));
        }
        String reult = FreemarkerUtil.generateString(templateName, "/codegen/template", templateData);
        System.out.println("=====================================================================================================================");
        System.out.println(reult);
        System.out.println("=====================================================================================================================");
    }

    public static void generate(Map<String, Object> params, Class<?> clazz) {
        dataDao.setDriver(MapUtil.getString(params, "driver", "")).setJdbcurl(MapUtil.getString(params, "jdbcurl", "")).setUsername(MapUtil.getString(params, "username", "")).setPassword(MapUtil.getString(params, "password", "")).setTableSchema(MapUtil.getString(params, "tableSchema", "")).setTableName(MapUtil.getString(params, "tableName", ""));
        CodeGen.generateModel(clazz);
        CodeGen.generateDao(clazz);
        CodeGen.generateMapper(clazz);
        System.out.println("=====================================================================================================================");
    }
}

