/*
 * Decompiled with CFR 0.152.
 */
package cn.thinkingdata.tga.javasdk;

import cn.thinkingdata.tga.javasdk.Consumer;
import cn.thinkingdata.tga.javasdk.exception.IllegalDataException;
import cn.thinkingdata.tga.javasdk.exception.InvalidArgumentException;
import cn.thinkingdata.tga.javasdk.exception.NeedRetryException;
import cn.thinkingdata.tga.javasdk.util.HttpRequestUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.GZIPOutputStream;
import net.jpountz.lz4.LZ4BlockOutputStream;
import net.jpountz.lz4.LZ4Compressor;
import net.jpountz.lz4.LZ4Factory;
import org.anarres.lzo.LzoAlgorithm;
import org.anarres.lzo.LzoCompressor;
import org.anarres.lzo.LzoLibrary;
import org.anarres.lzo.LzoOutputStream;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.apache.http.util.TextUtils;

public class ThinkingDataAnalytics {
    private final Consumer consumer;
    private final Map<String, Object> superProperties;
    private final boolean enableUUID;
    private static final String LIB_VERSION = "1.8.1";
    private static final String LIB_NAME = "tga_java_sdk";
    private static final String DEFAULT_DATE_FORMAT = "yyyy-MM-dd HH:mm:ss.SSS";
    private static final Pattern KEY_PATTERN = Pattern.compile("^(#[a-z][a-z0-9_]{0,49})|([a-z][a-z0-9_]{0,50})$", 2);

    public ThinkingDataAnalytics(Consumer consumer) {
        this.consumer = consumer;
        this.enableUUID = false;
        this.superProperties = new ConcurrentHashMap<String, Object>();
    }

    public ThinkingDataAnalytics(Consumer consumer, boolean enableUUID) {
        this.consumer = consumer;
        this.enableUUID = enableUUID;
        this.superProperties = new ConcurrentHashMap<String, Object>();
    }

    public void user_del(String accountId, String distinctId) throws InvalidArgumentException {
        this.add(distinctId, accountId, DataType.USER_DEL, null);
    }

    public void user_add(String accountId, String distinctId, Map<String, Object> properties) throws InvalidArgumentException {
        this.add(distinctId, accountId, DataType.USER_ADD, properties);
    }

    public void user_setOnce(String accountId, String distinctId, Map<String, Object> properties) throws InvalidArgumentException {
        this.add(distinctId, accountId, DataType.USER_SET_ONCE, properties);
    }

    public void user_set(String accountId, String distinctId, Map<String, Object> properties) throws InvalidArgumentException {
        this.add(distinctId, accountId, DataType.USER_SET, properties);
    }

    public void user_unset(String accountId, String distinctId, String ... properties) throws InvalidArgumentException {
        if (properties == null) {
            return;
        }
        HashMap<String, Object> prop = new HashMap<String, Object>();
        for (String s : properties) {
            prop.put(s, 0);
        }
        this.add(distinctId, accountId, DataType.USER_UNSET, prop);
    }

    public void user_append(String accountId, String distinctId, Map<String, Object> properties) throws InvalidArgumentException {
        this.add(distinctId, accountId, DataType.USER_APPEND, properties);
    }

    public void track(String accountId, String distinctId, String eventName, Map<String, Object> properties) throws InvalidArgumentException {
        HashMap<String, Object> allProperties = new HashMap<String, Object>(this.superProperties);
        if (properties != null) {
            allProperties.putAll(properties);
        }
        this.add(distinctId, accountId, DataType.TRACK, eventName, null, allProperties);
    }

    public void track_update(String accountId, String distinctId, String eventName, String eventId, Map<String, Object> properties) throws InvalidArgumentException {
        HashMap<String, Object> allProperties = new HashMap<String, Object>(this.superProperties);
        if (properties != null) {
            allProperties.putAll(properties);
        }
        this.add(distinctId, accountId, DataType.TRACK_UPDATE, eventName, eventId, allProperties);
    }

    public void track_overwrite(String accountId, String distinctId, String eventName, String eventId, Map<String, Object> properties) throws InvalidArgumentException {
        HashMap<String, Object> allProperties = new HashMap<String, Object>(this.superProperties);
        if (properties != null) {
            allProperties.putAll(properties);
        }
        this.add(distinctId, accountId, DataType.TRACK_OVERWRITE, eventName, eventId, allProperties);
    }

    private void add(String distinctId, String accountId, DataType type, Map<String, Object> properties) throws InvalidArgumentException {
        this.add(distinctId, accountId, type, null, null, properties);
    }

    private void add(String distinctId, String accountId, DataType type, String eventName, String eventId, Map<String, Object> properties) throws InvalidArgumentException {
        if (TextUtils.isEmpty((CharSequence)accountId) && TextUtils.isEmpty((CharSequence)distinctId)) {
            throw new InvalidArgumentException("accountId or distinctId must be provided.");
        }
        HashMap<String, Object> finalProperties = properties == null ? new HashMap<String, Object>() : new HashMap<String, Object>(properties);
        HashMap<String, Object> event = new HashMap<String, Object>();
        if (finalProperties.containsKey("#uuid")) {
            event.put("#uuid", finalProperties.get("#uuid"));
            finalProperties.remove("#uuid");
        } else if (this.enableUUID) {
            event.put("#uuid", UUID.randomUUID().toString());
        }
        this.assertProperties(type, finalProperties);
        if (!TextUtils.isEmpty((CharSequence)distinctId)) {
            event.put("#distinct_id", distinctId);
        }
        if (!TextUtils.isEmpty((CharSequence)accountId)) {
            event.put("#account_id", accountId);
        }
        if (finalProperties.containsKey("#app_id")) {
            event.put("#app_id", finalProperties.get("#app_id"));
            finalProperties.remove("#app_id");
        }
        if (finalProperties.containsKey("#time")) {
            event.put("#time", finalProperties.get("#time"));
            finalProperties.remove("#time");
        } else {
            event.put("#time", new Date());
        }
        if (finalProperties.containsKey("#ip")) {
            event.put("#ip", finalProperties.get("#ip"));
            finalProperties.remove("#ip");
        }
        if (finalProperties.containsKey("#first_check_id")) {
            event.put("#first_check_id", finalProperties.get("#first_check_id"));
            finalProperties.remove("#first_check_id");
        }
        if (finalProperties.containsKey("#transaction_property")) {
            event.put("#transaction_property", finalProperties.get("#transaction_property"));
            finalProperties.remove("#transaction_property");
        }
        if (finalProperties.containsKey("#import_tool_id")) {
            event.put("#import_tool_id", finalProperties.get("#import_tool_id"));
            finalProperties.remove("#import_tool_id");
        }
        event.put("#type", type.getType());
        if (type == DataType.TRACK || type == DataType.TRACK_OVERWRITE || type == DataType.TRACK_UPDATE) {
            if (TextUtils.isEmpty((CharSequence)eventName)) {
                throw new InvalidArgumentException("The event name must be provided.");
            }
            if ((type == DataType.TRACK_OVERWRITE || type == DataType.TRACK_UPDATE) && TextUtils.isEmpty((CharSequence)eventId)) {
                throw new InvalidArgumentException("The event id must be provided.");
            }
            if (!TextUtils.isEmpty((CharSequence)eventId)) {
                event.put("#event_id", eventId);
            }
            event.put("#event_name", eventName);
            finalProperties.put("#lib", LIB_NAME);
            finalProperties.put("#lib_version", LIB_VERSION);
        }
        event.put("properties", finalProperties);
        this.consumer.add(event);
    }

    private void assertProperties(DataType type, Map<String, Object> properties) throws InvalidArgumentException {
        if (properties.size() == 0) {
            return;
        }
        for (Map.Entry<String, Object> property : properties.entrySet()) {
            Object value = property.getValue();
            if (null == value) continue;
            if (KEY_PATTERN.matcher(property.getKey()).matches()) {
                if (DataType.USER_ADD != type || value instanceof Number || property.getKey().startsWith("#")) continue;
                throw new InvalidArgumentException("Only Number is allowed for user_add. Invalid property: " + property.getKey());
            }
            throw new InvalidArgumentException("Invalid key format: " + property.getKey());
        }
    }

    public void clearSuperProperties() {
        this.superProperties.clear();
    }

    public void setSuperProperties(Map<String, Object> properties) {
        this.superProperties.putAll(properties);
    }

    public void flush() {
        this.consumer.flush();
    }

    public void close() {
        this.consumer.close();
    }

    private static class HttpService
    implements Closeable {
        private ConsumeMode consumeMode = ConsumeMode.BATCH;
        private final URI serverUri;
        private final String appId;
        private Boolean writeData = true;
        private String compress = "gzip";
        private Integer connectTimeout = null;
        private static CloseableHttpClient httpClient;

        void setDebugMode() {
            this.consumeMode = ConsumeMode.DEBUG;
        }

        private HttpService(URI server_uri, String appId, Integer timeout) {
            this(server_uri, appId);
            this.connectTimeout = timeout;
        }

        private HttpService(URI server_uri, String appId, boolean writeData) {
            this(server_uri, appId);
            this.writeData = writeData;
        }

        private HttpService(URI server_uri, String appId) {
            if (httpClient == null) {
                httpClient = HttpRequestUtil.getHttpClient();
            }
            this.serverUri = server_uri;
            this.appId = appId;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        private synchronized void send(String data, int dataSize) {
            HttpPost httpPost = new HttpPost(this.serverUri);
            HttpEntity params = this.consumeMode == ConsumeMode.BATCH ? this.getBatchHttpEntity(data) : this.getDebugHttpEntity(data);
            httpPost.setEntity(params);
            httpPost.addHeader("appid", this.appId);
            httpPost.addHeader("TA-Integration-Type", "Java");
            httpPost.addHeader("TA-Integration-Version", ThinkingDataAnalytics.LIB_VERSION);
            httpPost.addHeader("TA-Integration-Count", String.valueOf(dataSize));
            httpPost.addHeader("compress", this.compress);
            if (this.connectTimeout != null) {
                RequestConfig requestConfig = RequestConfig.custom().setSocketTimeout(this.connectTimeout + 5000).setConnectTimeout(this.connectTimeout.intValue()).build();
                httpPost.setConfig(requestConfig);
            }
            int i = 0;
            while (true) {
                try {
                    Throwable throwable;
                    CloseableHttpResponse response;
                    block20: {
                        block21: {
                            response = httpClient.execute((HttpUriRequest)httpPost);
                            throwable = null;
                            int statusCode = response.getStatusLine().getStatusCode();
                            if (statusCode != 200) {
                                throw new NeedRetryException("Cannot post message to " + this.serverUri + ", status code:" + statusCode);
                            }
                            String result = EntityUtils.toString((HttpEntity)response.getEntity(), (String)"UTF-8");
                            JSONObject resultJson = JSONObject.parseObject((String)result);
                            this.checkingRetCode(resultJson);
                            if (response == null) break block20;
                            if (throwable == null) break block21;
                            try {
                                response.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            break block20;
                        }
                        response.close();
                    }
                    return;
                    catch (Throwable throwable3) {
                        try {
                            try {
                                throwable = throwable3;
                                throw throwable3;
                            }
                            catch (Throwable throwable4) {
                                if (response != null) {
                                    if (throwable != null) {
                                        try {
                                            response.close();
                                        }
                                        catch (Throwable throwable5) {
                                            throwable.addSuppressed(throwable5);
                                        }
                                    } else {
                                        response.close();
                                    }
                                }
                                throw throwable4;
                            }
                        }
                        catch (NeedRetryException | IOException e) {
                            if (i++ != 2) continue;
                            throw new NeedRetryException("Cannot post message to " + this.serverUri, e);
                        }
                    }
                }
                finally {
                    httpPost.releaseConnection();
                    continue;
                }
                break;
            }
        }

        UrlEncodedFormEntity getDebugHttpEntity(String data) {
            ArrayList<BasicNameValuePair> nameValuePairs = new ArrayList<BasicNameValuePair>();
            nameValuePairs.add(new BasicNameValuePair("source", "server"));
            nameValuePairs.add(new BasicNameValuePair("appid", this.appId));
            nameValuePairs.add(new BasicNameValuePair("data", data));
            if (!this.writeData.booleanValue()) {
                nameValuePairs.add(new BasicNameValuePair("dryRun", String.valueOf(1)));
            }
            return new UrlEncodedFormEntity(nameValuePairs, StandardCharsets.UTF_8);
        }

        HttpEntity getBatchHttpEntity(String data) {
            try {
                byte[] dataBytes = data.getBytes(StandardCharsets.UTF_8);
                byte[] dataCompressed = "lzo".equalsIgnoreCase(this.compress) ? HttpService.lzoCompress(dataBytes) : ("lz4".equalsIgnoreCase(this.compress) ? HttpService.lz4Compress(dataBytes) : ("none".equalsIgnoreCase(this.compress) ? dataBytes : HttpService.gzipCompress(dataBytes)));
                return new ByteArrayEntity(dataCompressed);
            }
            catch (IOException e) {
                throw new NeedRetryException("\u538b\u7f29\u6570\u636e\u5931\u8d25\uff01", e);
            }
        }

        private static byte[] lzoCompress(byte[] srcBytes) throws IOException {
            LzoCompressor compressor = LzoLibrary.getInstance().newCompressor(LzoAlgorithm.LZO1X, null);
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            LzoOutputStream cs = new LzoOutputStream((OutputStream)os, compressor);
            cs.write(srcBytes);
            cs.close();
            return os.toByteArray();
        }

        private static byte[] lz4Compress(byte[] srcBytes) throws IOException {
            LZ4Factory factory = LZ4Factory.fastestInstance();
            ByteArrayOutputStream byteOutput = new ByteArrayOutputStream();
            LZ4Compressor compressor = factory.fastCompressor();
            LZ4BlockOutputStream compressedOutput = new LZ4BlockOutputStream((OutputStream)byteOutput, 2048, compressor);
            compressedOutput.write(srcBytes);
            compressedOutput.close();
            return byteOutput.toByteArray();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static byte[] gzipCompress(byte[] srcBytes) throws IOException {
            try (DeflaterOutputStream gzipOut = null;){
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                gzipOut = new GZIPOutputStream(out);
                gzipOut.write(srcBytes);
                gzipOut.close();
                byte[] byArray = out.toByteArray();
                return byArray;
            }
        }

        private void checkingRetCode(JSONObject resultJson) {
            int retCode;
            if (this.consumeMode == ConsumeMode.DEBUG) {
                if (resultJson.getInteger("errorLevel") != 0) {
                    throw new IllegalDataException(resultJson.toJSONString());
                }
            } else if (this.consumeMode == ConsumeMode.BATCH && (retCode = resultJson.getInteger("code").intValue()) != 0) {
                if (retCode == -1) {
                    throw new IllegalDataException(resultJson.containsKey((Object)"msg") ? resultJson.getString("msg") : "invalid data format");
                }
                if (retCode == -2) {
                    throw new IllegalDataException(resultJson.containsKey((Object)"msg") ? resultJson.getString("msg") : "APP ID doesn't exist");
                }
                if (retCode == -3) {
                    throw new IllegalDataException(resultJson.containsKey((Object)"msg") ? resultJson.getString("msg") : "invalid ip transmission");
                }
                throw new IllegalDataException("Unexpected response return code: " + retCode);
            }
        }

        @Override
        public void close() {
            httpClient = null;
        }

        public static enum ConsumeMode {
            BATCH,
            DEBUG;

        }
    }

    public static class DebugConsumer
    implements Consumer {
        HttpService httpService;

        public DebugConsumer(String serverUrl, String appId) throws URISyntaxException {
            this(serverUrl, appId, true);
        }

        public DebugConsumer(String serverUrl, String appId, boolean writeData) throws URISyntaxException {
            URI uri = new URI(serverUrl);
            URI restfulUri = new URI(uri.getScheme(), uri.getUserInfo(), uri.getHost(), uri.getPort(), "/data_debug", uri.getQuery(), uri.getFragment());
            this.httpService = new HttpService(restfulUri, appId, writeData);
            this.httpService.setDebugMode();
        }

        @Override
        public void add(Map<String, Object> message) {
            String data = JSON.toJSONStringWithDateFormat(message, (String)ThinkingDataAnalytics.DEFAULT_DATE_FORMAT, (SerializerFeature[])new SerializerFeature[0]);
            try {
                this.httpService.send(data, 1);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public void flush() {
        }

        @Override
        public void close() {
            if (this.httpService != null) {
                this.httpService.close();
            }
        }
    }

    public static class BatchConsumer
    implements Consumer {
        private final int batchSize;
        private final int maxCacheSize;
        private final boolean isThrowException;
        private Timer autoFlushTimer;
        private static final int MAX_BATCH_SIZE = 1000;
        private final Object messageLock = new Object();
        private final Object cacheLock = new Object();
        private List<Map<String, Object>> messageChannel;
        private final LinkedList<List<Map<String, Object>>> cacheBuffer = new LinkedList();
        private final HttpService httpService;

        public BatchConsumer(String serverUrl, String appId) throws URISyntaxException {
            this(serverUrl, appId, 20, 0, false, 0, "gzip", 0, true);
        }

        public BatchConsumer(String serverUrl, String appId, boolean isThrowException) throws URISyntaxException {
            this(serverUrl, appId, 20, 0, false, 0, "gzip", 0, isThrowException);
        }

        public BatchConsumer(String serverUrl, String appId, Config config) throws URISyntaxException {
            this(serverUrl, appId, config.batchSize, config.timeout, config.autoFlush, config.interval, config.compress, config.maxCacheSize, config.isThrowException);
        }

        public BatchConsumer(String serverUrl, String appId, int batchSize, int timeout, boolean autoFlush, int interval) throws URISyntaxException {
            this(serverUrl, appId, batchSize, timeout, autoFlush, interval, "gzip", 0, true);
        }

        public BatchConsumer(String serverUrl, String appId, int batchSize, int timeout, boolean autoFlush, int interval, String compress) throws URISyntaxException {
            this(serverUrl, appId, batchSize, timeout, autoFlush, interval, compress, 0, true);
        }

        private BatchConsumer(String serverUrl, String appId, int batchSize, int timeout, boolean autoFlush, int interval, String compress, int maxCacheSize, boolean isThrowException) throws URISyntaxException {
            this.messageChannel = new ArrayList<Map<String, Object>>();
            this.batchSize = batchSize < 0 ? 20 : Math.min(batchSize, 1000);
            this.maxCacheSize = maxCacheSize <= 0 ? 50 : maxCacheSize;
            this.isThrowException = isThrowException;
            URI uri = new URI(serverUrl);
            URI url = new URI(uri.getScheme(), uri.getAuthority(), "/sync_server", uri.getQuery(), uri.getFragment());
            this.httpService = new HttpService(url, appId, timeout);
            this.httpService.compress = compress;
            if (autoFlush) {
                if (interval <= 0) {
                    interval = 3;
                }
                this.autoFlushTimer = new Timer();
                this.autoFlushTimer.schedule(new TimerTask(){

                    @Override
                    public void run() {
                        BatchConsumer.this.flushOnce();
                    }
                }, 1000L, (long)interval * 1000L);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void add(Map<String, Object> message) {
            Object object = this.messageLock;
            synchronized (object) {
                this.messageChannel.add(message);
            }
            if (this.messageChannel.size() >= this.batchSize || this.cacheBuffer.size() > 0) {
                this.flushOnce();
            }
        }

        @Override
        public void flush() {
            while (this.cacheBuffer.size() > 0 || this.messageChannel.size() > 0) {
                try {
                    this.flushOnce();
                }
                catch (IllegalDataException illegalDataException) {}
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void flushOnce() {
            if (this.messageChannel.size() == 0 && this.cacheBuffer.size() == 0) {
                return;
            }
            Object object = this.cacheLock;
            synchronized (object) {
                Object object2 = this.messageLock;
                synchronized (object2) {
                    if (this.messageChannel.size() == 0 && this.cacheBuffer.size() == 0) {
                        return;
                    }
                    if (this.messageChannel.size() >= this.batchSize || this.cacheBuffer.size() == 0) {
                        this.cacheBuffer.add(this.messageChannel);
                        this.messageChannel = new ArrayList<Map<String, Object>>();
                    }
                }
                List<Map<String, Object>> buffer = this.cacheBuffer.getFirst();
                try {
                    String data = JSON.toJSONStringWithDateFormat(buffer, (String)ThinkingDataAnalytics.DEFAULT_DATE_FORMAT, (SerializerFeature[])new SerializerFeature[0]);
                    this.httpService.send(data, buffer.size());
                    this.cacheBuffer.removeFirst();
                }
                catch (NeedRetryException e) {
                    if (this.isThrowException) {
                        throw e;
                    }
                }
                catch (IllegalDataException e) {
                    this.cacheBuffer.removeFirst();
                    if (this.isThrowException) {
                        throw e;
                    }
                }
                finally {
                    if (this.cacheBuffer.size() > this.maxCacheSize) {
                        this.cacheBuffer.removeFirst();
                    }
                }
            }
        }

        @Override
        public void close() {
            if (this.autoFlushTimer != null) {
                try {
                    this.autoFlushTimer.cancel();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.flush();
            if (this.httpService != null) {
                this.httpService.close();
            }
        }

        public static class Config {
            private int batchSize = 20;
            private int interval = 3;
            private String compress = "gzip";
            private int timeout = 30000;
            private boolean autoFlush = false;
            private int maxCacheSize = 50;
            private boolean isThrowException = true;

            public void setBatchSize(int batchSize) {
                this.batchSize = batchSize;
            }

            public void setInterval(int interval) {
                this.interval = interval;
            }

            public void setCompress(String compress) {
                this.compress = compress;
            }

            public void setTimeout(int timeout) {
                this.timeout = timeout;
            }

            public void setAutoFlush(boolean autoFlush) {
                this.autoFlush = autoFlush;
            }

            public void setMaxCacheSize(int maxCacheSize) {
                this.maxCacheSize = maxCacheSize;
            }

            public void setThrowException(boolean isThrowException) {
                this.isThrowException = isThrowException;
            }
        }
    }

    public static class LoggerConsumer
    implements Consumer {
        private final String fileName;
        private final String lockFileName;
        private final int bufferSize;
        private final int fileSize;
        private Timer autoFlushTimer;
        private final StringBuffer messageBuffer = new StringBuffer();
        private final ThreadLocal<SimpleDateFormat> df;
        private LoggerFileWriter loggerWriter;

        public LoggerConsumer(Config config) {
            if (config.logDirectory == null || config.logDirectory.length() == 0) {
                throw new RuntimeException("\u6307\u5b9a\u7684\u76ee\u5f55\u8def\u5f84\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            File dir = new File(config.logDirectory);
            if (!dir.exists()) {
                dir.mkdirs();
            }
            if (!dir.isDirectory()) {
                throw new RuntimeException("\u6307\u5b9a\u7684\u8def\u5f84\u5fc5\u987b\u662f\u4e2a\u76ee\u5f55\uff1a" + config.logDirectory);
            }
            String fileNamePrefix = config.fileNamePrefix == null ? config.logDirectory + File.separator : config.logDirectory + File.separator + config.fileNamePrefix + ".";
            this.fileName = fileNamePrefix + "log.";
            this.fileSize = config.fileSize;
            this.lockFileName = config.lockFileName;
            this.bufferSize = config.bufferSize;
            final String dataFormat = config.rotateMode == RotateMode.HOURLY ? "yyyy-MM-dd-HH" : "yyyy-MM-dd";
            this.df = new ThreadLocal<SimpleDateFormat>(){

                @Override
                protected SimpleDateFormat initialValue() {
                    return new SimpleDateFormat(dataFormat);
                }
            };
            if (config.autoFlush) {
                if (config.interval <= 0) {
                    config.interval = 3;
                }
                this.autoFlushTimer = new Timer();
                this.autoFlushTimer.schedule(new TimerTask(){

                    @Override
                    public void run() {
                        LoggerConsumer.this.flush();
                    }
                }, 1000L, (long)config.interval * 1000L);
            }
        }

        public LoggerConsumer(String logDirectory) {
            this(new Config(logDirectory));
        }

        public LoggerConsumer(String logDirectory, int fileSize) {
            this(new Config(logDirectory, fileSize));
        }

        @Override
        public synchronized void add(Map<String, Object> message) {
            try {
                this.messageBuffer.append(JSON.toJSONStringWithDateFormat(message, (String)ThinkingDataAnalytics.DEFAULT_DATE_FORMAT, (SerializerFeature[])new SerializerFeature[0]));
                this.messageBuffer.append("\n");
            }
            catch (JSONException e) {
                throw new RuntimeException("Failed to add data", e);
            }
            if (this.messageBuffer.length() >= this.bufferSize) {
                this.flush();
            }
        }

        @Override
        public synchronized void flush() {
            if (this.messageBuffer.length() == 0) {
                return;
            }
            String fileName = this.getFileName();
            if (this.loggerWriter != null && !this.loggerWriter.getFileName().equals(fileName)) {
                LoggerFileWriter.removeInstance(this.loggerWriter);
                this.loggerWriter = null;
            }
            if (this.loggerWriter == null) {
                try {
                    this.loggerWriter = LoggerFileWriter.getInstance(fileName, this.lockFileName);
                }
                catch (FileNotFoundException e) {
                    throw new RuntimeException(e);
                }
            }
            if (this.loggerWriter.write(this.messageBuffer)) {
                this.messageBuffer.setLength(0);
            }
        }

        private String getFileName() {
            String resultPrefix = this.fileName + this.df.get().format(new Date()) + "_";
            int count = 0;
            String result = resultPrefix + count;
            if (this.fileSize > 0) {
                File target = new File(result);
                while (target.exists() && target.length() / 0x100000L >= (long)this.fileSize) {
                    result = resultPrefix + ++count;
                    target = new File(result);
                }
            }
            return result;
        }

        @Override
        public synchronized void close() {
            this.flush();
            if (this.loggerWriter != null) {
                LoggerFileWriter.removeInstance(this.loggerWriter);
                this.loggerWriter = null;
            }
            if (this.autoFlushTimer != null) {
                this.autoFlushTimer.cancel();
            }
        }

        private static class LoggerFileWriter {
            private final String fileName;
            private final FileOutputStream outputStream;
            private final FileOutputStream lockStream;
            private int refCount;
            private static final Map<String, LoggerFileWriter> instances = new HashMap<String, LoggerFileWriter>();

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            static LoggerFileWriter getInstance(String fileName, String lockFileName) throws FileNotFoundException {
                Map<String, LoggerFileWriter> map = instances;
                synchronized (map) {
                    if (!instances.containsKey(fileName)) {
                        instances.put(fileName, new LoggerFileWriter(fileName, lockFileName));
                    }
                    LoggerFileWriter writer = instances.get(fileName);
                    ++writer.refCount;
                    return writer;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            static void removeInstance(LoggerFileWriter writer) {
                Map<String, LoggerFileWriter> map = instances;
                synchronized (map) {
                    --writer.refCount;
                    if (writer.refCount == 0) {
                        writer.close();
                        instances.remove(writer.fileName);
                    }
                }
            }

            private LoggerFileWriter(String fileName, String lockFileName) throws FileNotFoundException {
                this.outputStream = new FileOutputStream(fileName, true);
                this.lockStream = lockFileName != null ? new FileOutputStream(lockFileName, true) : this.outputStream;
                this.fileName = fileName;
                this.refCount = 0;
            }

            private void close() {
                try {
                    this.outputStream.close();
                }
                catch (Exception e) {
                    throw new RuntimeException("fail to close tga outputStream.", e);
                }
            }

            String getFileName() {
                return this.fileName;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            boolean write(StringBuffer sb) {
                FileOutputStream fileOutputStream = this.lockStream;
                synchronized (fileOutputStream) {
                    FileLock lock = null;
                    try {
                        FileChannel channel = this.lockStream.getChannel();
                        lock = channel.lock(0L, Long.MAX_VALUE, false);
                        this.outputStream.write(sb.toString().getBytes(StandardCharsets.UTF_8));
                    }
                    catch (Exception e) {
                        throw new RuntimeException("failed to write tga file.", e);
                    }
                    finally {
                        if (lock != null) {
                            try {
                                lock.release();
                            }
                            catch (IOException e) {
                                throw new RuntimeException("failed to release tga file lock.", e);
                            }
                        }
                    }
                }
                return true;
            }
        }

        public static class Config {
            String logDirectory;
            RotateMode rotateMode = RotateMode.DAILY;
            String lockFileName;
            String fileNamePrefix;
            int interval = 0;
            int fileSize = 0;
            int bufferSize = 8192;
            boolean autoFlush = false;

            public Config(String logDirectory) {
                this(logDirectory, 0);
            }

            public Config(String logDirectory, int fileSize) {
                this.logDirectory = logDirectory;
                this.fileSize = fileSize;
            }

            public void setRotateMode(RotateMode rotateMode) {
                this.rotateMode = rotateMode;
            }

            public void setFileSize(int fileSize) {
                this.fileSize = fileSize;
            }

            public void setLockFile(String lockFileName) {
                this.lockFileName = lockFileName;
            }

            public void setBufferSize(int bufferSize) {
                this.bufferSize = bufferSize;
            }

            public void setFilenamePrefix(String fileNamePrefix) {
                this.fileNamePrefix = fileNamePrefix;
            }

            public void setAutoFlush(boolean autoFlush) {
                this.autoFlush = autoFlush;
            }

            public void setInterval(int interval) {
                this.interval = interval;
            }
        }

        public static enum RotateMode {
            DAILY,
            HOURLY;

        }
    }

    private static enum DataType {
        TRACK("track"),
        USER_SET("user_set"),
        USER_SET_ONCE("user_setOnce"),
        USER_ADD("user_add"),
        USER_DEL("user_del"),
        USER_UNSET("user_unset"),
        USER_APPEND("user_append"),
        TRACK_UPDATE("track_update"),
        TRACK_OVERWRITE("track_overwrite");

        private final String type;

        private DataType(String type) {
            this.type = type;
        }

        public String getType() {
            return this.type;
        }
    }
}

