package cn.thinkingdata.tga.javasdk;

import cn.thinkingdata.tga.javasdk.exception.InvalidArgumentException;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;

/**
 * Created by quanjie on 2018/4/16.
 */
public class TestMain {
    public static void main(String[] args) throws InvalidArgumentException {
        ProduceKafka produce = new ProduceKafka("test:9092");
        ThinkingDataAnalytics tga = new ThinkingDataAnalytics(produce);
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("#time", new Date());
        properties.put("Product_Name", "月卡");
        properties.put("Price", 30);
        properties.put("OrderId", "abc_123");

        try{
            for(int i=1;i< 10000;i++){
                tga.track("account_id","distinct_id","payment",properties);
                properties = new HashMap<String, Object>();
                properties.put("count",i);
                properties.put("#time", new Date());
                tga.track("account_id","distinct_id","count",properties);

                properties.put("Product_Name", "月卡");
                properties.put("Price", 30);
                properties.put("OrderId", "abc_123");
                System.out.println(i);

                Map<String,Object> userSetProperties = new HashMap<String,Object>();
                userSetProperties.put("user_name", "ABC");
                userSetProperties.put("#time", new Date());
                //上传用户属性
                tga.user_set("account_id","distinct_id",userSetProperties);
            }

        }finally {
            tga.close();
        }

    }
}
