/*
 * Decompiled with CFR 0.152.
 */
package cn.thinkingdata.tga.javasdk;

import cn.thinkingdata.tga.javasdk.Consumer;
import cn.thinkingdata.tga.javasdk.exception.InvalidArgumentException;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.regex.Pattern;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.codec.binary.Base64;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThinkingDataAnalytics {
    private final Consumer consumer;
    private final Map<String, Object> publicProperties;
    private static final String libVersion = "1.1.16";
    private static final Pattern trackPattern = Pattern.compile("^(#[a-z][a-z0-9_]{0,49})|([a-z][a-z0-9_]{0,50})$", 2);
    private static final Pattern userPattern = Pattern.compile("^(#[a-z][a-z0-9_]{0,49})|([a-z][a-z0-9_]{0,50})$", 2);

    public ThinkingDataAnalytics(Consumer consumer) {
        this.consumer = consumer;
        this.publicProperties = new ConcurrentHashMap<String, Object>();
        this.clearSuperProperties();
    }

    public void user_del(String account_id, String distinct_id) throws InvalidArgumentException {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        if (properties.get("#time") == null) {
            properties.put("#time", new Date());
        }
        this.__add(distinct_id, account_id, "user_del", properties);
    }

    public void user_add(String account_id, String distinct_id, Map<String, Object> properties) throws InvalidArgumentException {
        this.__add(distinct_id, account_id, "user_add", properties);
    }

    public void user_setOnce(String account_id, String distinct_id, Map<String, Object> properties) throws InvalidArgumentException {
        this.__add(distinct_id, account_id, "user_setOnce", properties);
    }

    public void user_set(String account_id, String distinct_id, Map<String, Object> properties) throws InvalidArgumentException {
        this.__add(distinct_id, account_id, "user_set", properties);
    }

    public void track(String account_id, String distinct_id, String event_name, Map<String, Object> properties) throws InvalidArgumentException {
        HashMap<String, Object> all_properties = new HashMap<String, Object>();
        all_properties.putAll(this.publicProperties);
        if (properties != null) {
            all_properties.putAll(properties);
        }
        this.__add(distinct_id, account_id, "track", event_name, all_properties);
    }

    private void __add(String distinct_id, String account_id, String type, Map<String, Object> properties) throws InvalidArgumentException {
        this.__add(distinct_id, account_id, type, null, properties);
    }

    private void __add(String distinct_id, String account_id, String type, String event_name, Map<String, Object> properties_add) throws InvalidArgumentException {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.putAll(properties_add);
        if (account_id == null && distinct_id == null) {
            throw new InvalidArgumentException("account_id and distinct_id Simultaneously are null ");
        }
        if (properties != null) {
            this.assertProperties(type, properties);
        }
        HashMap<String, Object> event = new HashMap<String, Object>();
        event.put("#time", properties.get("#time"));
        properties.remove("#time");
        if (properties.containsKey("#ip")) {
            event.put("#ip", properties.get("#ip"));
            properties.remove("#ip");
        } else {
            event.put("#ip", "");
        }
        event.put("#type", type);
        if (event_name != null) {
            event.put("#event_name", event_name);
        }
        HashMap<String, Object> eventProperties = new HashMap<String, Object>();
        if (properties != null) {
            eventProperties.putAll(properties);
        }
        event.put("properties", eventProperties);
        if (distinct_id != null) {
            event.put("#distinct_id", distinct_id);
        }
        if (account_id != null) {
            event.put("#account_id", account_id);
        }
        this.consumer.add(event);
    }

    private void assertProperties(String type, Map<String, Object> properties) throws InvalidArgumentException {
        this.assertType("type catgory", type);
        Pattern pattern_key = this.getPatternKey(type);
        if (properties.containsKey("#time")) {
            if (!(properties.get("#time") instanceof Date)) {
                throw new InvalidArgumentException("type(#time) must be Date, #time is " + properties.get("#time"));
            }
        } else {
            properties.put("#time", new Date());
        }
        for (Map.Entry<String, Object> property : properties.entrySet()) {
            if (property.getValue() == null) continue;
            if (pattern_key.matcher(property.getKey()).matches()) {
                if (!(property.getValue() instanceof Number || property.getValue() instanceof Date || property.getValue() instanceof String || property.getValue() instanceof Boolean)) {
                    throw new InvalidArgumentException("The property value should be a basic type: Number, String, Date, Boolean.");
                }
                if (!type.toLowerCase().equals("user_add") || property.getValue() instanceof Number || property.getKey().startsWith("#")) continue;
                throw new InvalidArgumentException("Type user_add only support Number");
            }
            throw new InvalidArgumentException("type " + type + "'key " + property.getKey() + " is invalid");
        }
    }

    private boolean assertType(String description, String type) throws InvalidArgumentException {
        if ("user_set,user_setonce,user_add,user_del,track".contains(type.toLowerCase())) {
            return true;
        }
        throw new InvalidArgumentException(description + " without support : " + type);
    }

    private Pattern getPatternKey(String type) {
        if (type.equals("track")) {
            return trackPattern;
        }
        return userPattern;
    }

    public void clearSuperProperties() {
        this.publicProperties.clear();
        this.publicProperties.put("#lib", "tga_java_sdk");
        this.publicProperties.put("#lib_version", libVersion);
    }

    public void setSuperProperties(Map<String, Object> properties) {
        this.publicProperties.putAll(properties);
    }

    public void flush() {
        this.consumer.flush();
    }

    public void close() {
        this.consumer.close();
    }

    private static class HttpConsumer {
        private final Logger logger = LoggerFactory.getLogger(HttpConsumer.class);
        private final String server_uri;
        private final String appid;
        private Integer connectTimeout = 30000;

        private HttpConsumer(String server_url, String appid, Integer timeout) {
            this(server_url, appid);
            this.connectTimeout = timeout;
        }

        private HttpConsumer(String server_url, String appid) {
            this.server_uri = server_url;
            this.appid = appid;
        }

        public void send(String data) throws Exception {
            CloseableHttpClient httpclient = HttpClients.custom().build();
            HttpPost httppost = null;
            try {
                StringEntity params = new StringEntity(this.encodeRecord(data), "UTF-8");
                RequestConfig requestConfig = RequestConfig.custom().setSocketTimeout(this.connectTimeout + 10000).setConnectTimeout(30000).build();
                httppost = new HttpPost(this.server_uri);
                httppost.setEntity((HttpEntity)params);
                httppost.addHeader("appid", this.appid);
                httppost.addHeader("user-agent", "java_sdk_1.1.16");
                httppost.addHeader("version", ThinkingDataAnalytics.libVersion);
                httppost.setConfig(requestConfig);
                CloseableHttpResponse response = httpclient.execute((HttpUriRequest)httppost);
                Integer code = response.getStatusLine().getStatusCode();
                String result = EntityUtils.toString((HttpEntity)response.getEntity(), (String)"UTF-8");
                response.close();
                httppost.abort();
                if (code < 200 || code >= 300) {
                    throw new Exception(String.format("Unexcepted response %d from tga:%s", code, result));
                }
            }
            catch (Exception e) {
                throw new Exception("http transport with error " + e.getCause().getMessage());
            }
            finally {
                if (httpclient != null) {
                    try {
                        httpclient.close();
                    }
                    catch (IOException e) {
                        throw new Exception("httpclient with error " + e.getCause().getMessage());
                    }
                }
            }
        }

        private String encodeRecord(String data) {
            ByteArrayOutputStream byteArrayBuffer = new ByteArrayOutputStream();
            try {
                GZIPOutputStream var2 = new GZIPOutputStream(byteArrayBuffer);
                var2.write(data.getBytes(StandardCharsets.UTF_8));
                var2.close();
            }
            catch (IOException var3) {
                this.logger.error("GZIP compress with exception", (Throwable)var3);
                return null;
            }
            return new String(Base64.encodeBase64((byte[])byteArrayBuffer.toByteArray()));
        }
    }

    public static class BatchConsumer
    implements Consumer {
        private final Logger logger = LoggerFactory.getLogger(BatchConsumer.class);
        private final String appid;
        private final String server_uri;
        private Integer batch = 20;
        private Integer timeout = 30000;
        private Integer interval = 3;
        private Long lastFlushTime = System.currentTimeMillis();
        private List<Map<String, Object>> message_channel;
        private HttpConsumer httpConsumer;

        public BatchConsumer(String server_uri, String appid) {
            this.appid = appid;
            this.server_uri = server_uri;
            JSON.DEFFAULT_DATE_FORMAT = "yyyy-MM-dd HH:mm:ss.SSS";
            this.message_channel = new CopyOnWriteArrayList<Map<String, Object>>();
            this.httpConsumer = new HttpConsumer(server_uri, appid);
        }

        public BatchConsumer(String server_uri, String appid, int batch, int timeout, int interval) {
            this.appid = appid;
            this.server_uri = server_uri;
            JSON.DEFFAULT_DATE_FORMAT = "yyyy-MM-dd HH:mm:ss.SSS";
            this.message_channel = new CopyOnWriteArrayList<Map<String, Object>>();
            this.batch = batch;
            this.timeout = timeout;
            this.interval = interval;
            this.httpConsumer = new HttpConsumer(server_uri, appid, timeout);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void add(Map<String, Object> message) {
            List<Map<String, Object>> list = this.message_channel;
            synchronized (list) {
                this.message_channel.add(message);
                Long nowTime = System.currentTimeMillis();
                if (this.message_channel.size() >= this.batch || nowTime - this.lastFlushTime >= (long)(this.interval * 1000) && this.message_channel.size() > 0) {
                    this.flush();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void flush() {
            List<Map<String, Object>> list = this.message_channel;
            synchronized (list) {
                try {
                    List<Object> messageList = new CopyOnWriteArrayList();
                    messageList = this.message_channel.size() > this.batch ? this.message_channel.subList(0, this.batch) : (List)((CopyOnWriteArrayList)this.message_channel).clone();
                    String data = JSON.toJSONString(messageList, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteDateUseDateFormat});
                    this.httpConsumer.send(data);
                    if (this.message_channel.size() > this.batch) {
                        this.message_channel = this.message_channel.subList(this.batch, this.message_channel.size());
                    } else {
                        this.message_channel.clear();
                    }
                    this.lastFlushTime = System.currentTimeMillis();
                }
                catch (JSONException e) {
                    throw new RuntimeException("Failed to become json ", e);
                }
                catch (Exception e) {
                    throw new RuntimeException("Failed to transform with BatchConsumer", e);
                }
            }
        }

        @Override
        public void close() {
            while (this.message_channel.size() > 0) {
                this.flush();
            }
        }
    }

    static class InnerLoggerConsumer
    implements Consumer {
        private final String log_directory;
        private final StringBuffer message_buffer;
        private final Integer fileSize;
        private final Integer bufferSize = 81920;
        private final SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        private final LoggerFileWriterFactory fileWriterFactory;
        private LoggerFileWriter logger_writer;

        public InnerLoggerConsumer(LoggerFileWriterFactory fileWriterFactory, String log_directory, Integer fileSize) throws IOException {
            this.fileWriterFactory = fileWriterFactory;
            this.log_directory = log_directory;
            this.message_buffer = new StringBuffer();
            this.fileSize = fileSize;
            JSON.DEFFAULT_DATE_FORMAT = "yyyy-MM-dd HH:mm:ss.SSS";
        }

        @Override
        public synchronized void add(Map<String, Object> message) {
            try {
                this.message_buffer.append(JSON.toJSONString(message, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteDateUseDateFormat}));
                this.message_buffer.append("\n");
            }
            catch (JSONException e) {
                throw new RuntimeException("Failed to become json", e);
            }
            if (this.message_buffer.length() >= this.bufferSize) {
                this.flush();
            }
        }

        public String getFileName() {
            String file_base = this.log_directory + File.separator + "log." + this.simpleDateFormat.format(new Date()) + "_";
            Integer count = 0;
            String file_complete = file_base + count;
            File target = new File(file_complete);
            while (target.exists() && this.fileSizeOut(target).booleanValue()) {
                count = count + 1;
                file_complete = file_base + count;
                target = new File(file_complete);
            }
            return file_complete;
        }

        public Boolean fileSizeOut(File target) {
            Long fsize = target.length();
            if ((fsize = Long.valueOf(fsize / 0x100000L)) >= (long)this.fileSize.intValue()) {
                return true;
            }
            return false;
        }

        @Override
        public synchronized void flush() {
            if (this.message_buffer.length() == 0) {
                return;
            }
            String file_name = this.getFileName();
            if (this.logger_writer != null && !this.logger_writer.isValid(file_name)) {
                this.fileWriterFactory.closeFileWriter(this.logger_writer);
                this.logger_writer = null;
            }
            if (this.logger_writer == null) {
                try {
                    this.logger_writer = this.fileWriterFactory.getFileWriter(this.log_directory, file_name);
                }
                catch (FileNotFoundException e) {
                    throw new RuntimeException(e);
                }
            }
            if (this.logger_writer.write(this.message_buffer)) {
                this.message_buffer.setLength(0);
            }
        }

        @Override
        public synchronized void close() {
            this.flush();
            if (this.logger_writer != null) {
                this.fileWriterFactory.closeFileWriter(this.logger_writer);
                this.logger_writer = null;
            }
        }
    }

    static interface LoggerFileWriterFactory {
        public LoggerFileWriter getFileWriter(String var1, String var2) throws FileNotFoundException;

        public void closeFileWriter(LoggerFileWriter var1);
    }

    static interface LoggerFileWriter {
        public boolean isValid(String var1);

        public boolean write(StringBuffer var1);

        public void close();
    }

    public static class LoggerConsumer
    extends InnerLoggerConsumer {
        public LoggerConsumer(String log_directory) throws IOException {
            this(log_directory, 1024);
        }

        public LoggerConsumer(String log_directory, int fileSize) throws IOException {
            this(log_directory, null, (Integer)fileSize);
        }

        public LoggerConsumer(String log_directory, String lockFileName) throws IOException {
            this(log_directory, lockFileName, (Integer)81920);
        }

        public LoggerConsumer(String log_directory, String lockFileName, Integer bufferSize) throws IOException {
            super(new InnerLoggerFileWriterFactory(lockFileName), log_directory, bufferSize);
        }

        static class InnerLoggerFileWriter
        implements LoggerFileWriter {
            private final String fileName;
            private final FileOutputStream outputStream;
            private final FileOutputStream lockStream;
            private int refCount;
            private static final Map<String, InnerLoggerFileWriter> instances = new HashMap<String, InnerLoggerFileWriter>();

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            static InnerLoggerFileWriter getInstance(String fileName, String lockFileName) throws FileNotFoundException {
                Map<String, InnerLoggerFileWriter> map = instances;
                synchronized (map) {
                    if (!instances.containsKey(fileName)) {
                        instances.put(fileName, new InnerLoggerFileWriter(fileName, lockFileName));
                    }
                    InnerLoggerFileWriter writer = instances.get(fileName);
                    ++writer.refCount;
                    return writer;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            static void removeInstance(InnerLoggerFileWriter writer) {
                Map<String, InnerLoggerFileWriter> map = instances;
                synchronized (map) {
                    --writer.refCount;
                    if (writer.refCount == 0) {
                        writer.close();
                        instances.remove(writer.fileName);
                    }
                }
            }

            private InnerLoggerFileWriter(String fileName, String lockFileName) throws FileNotFoundException {
                this.outputStream = new FileOutputStream(fileName, true);
                this.lockStream = lockFileName != null ? new FileOutputStream(lockFileName, true) : this.outputStream;
                this.fileName = fileName;
                this.refCount = 0;
            }

            @Override
            public void close() {
                try {
                    this.outputStream.close();
                }
                catch (Exception e) {
                    throw new RuntimeException("fail to close tga outputStream.", e);
                }
            }

            @Override
            public boolean isValid(String fileName) {
                return this.fileName.equals(fileName);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean write(StringBuffer sb) {
                FileOutputStream fileOutputStream = this.lockStream;
                synchronized (fileOutputStream) {
                    FileLock lock = null;
                    try {
                        FileChannel channel = this.lockStream.getChannel();
                        lock = channel.lock(0L, Long.MAX_VALUE, false);
                        this.outputStream.write(sb.toString().getBytes("UTF-8"));
                    }
                    catch (Exception e) {
                        throw new RuntimeException("fail to write tga file.", e);
                    }
                    finally {
                        if (lock != null) {
                            try {
                                lock.release();
                            }
                            catch (IOException e) {
                                throw new RuntimeException("fail to release tga file lock.", e);
                            }
                        }
                    }
                }
                return true;
            }
        }

        static class InnerLoggerFileWriterFactory
        implements LoggerFileWriterFactory {
            private String lockFileName;

            InnerLoggerFileWriterFactory(String lockFileName) {
                this.lockFileName = lockFileName;
            }

            @Override
            public LoggerFileWriter getFileWriter(String log_directory, String fileName) throws FileNotFoundException {
                return InnerLoggerFileWriter.getInstance(fileName, this.lockFileName);
            }

            @Override
            public void closeFileWriter(LoggerFileWriter writer) {
                InnerLoggerFileWriter.removeInstance((InnerLoggerFileWriter)writer);
            }
        }
    }
}

