/*
 * Decompiled with CFR 0.152.
 */
package cn.thinkingdata.tga.javasdk;

import cn.thinkingdata.tga.javasdk.Consumer;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.util.Map;
import java.util.Properties;
import org.apache.kafka.clients.producer.Callback;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.Producer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;

public class ProduceKafka
implements Consumer {
    private Properties props = new Properties();
    private Producer<String, String> producer = null;
    private String topic = null;

    public ProduceKafka(String Server, String topic) {
        this.props.put("bootstrap.servers", Server);
        this.props.put("acks", "1");
        this.props.put("retries", (Object)5);
        this.props.put("linger.ms", (Object)3);
        this.props.put("batch.size", (Object)50000);
        this.props.put("compression.type", "gzip");
        this.props.put("key.serializer", "org.apache.kafka.common.serialization.StringSerializer");
        this.props.put("value.serializer", "org.apache.kafka.common.serialization.StringSerializer");
        this.topic = topic;
        JSON.DEFFAULT_DATE_FORMAT = "yyyy-MM-dd HH:mm:ss.SSS";
        this.init();
    }

    public ProduceKafka(String Server) {
        this(Server, "tga_data_collector");
    }

    @Override
    public void add(Map<String, Object> message) {
        try {
            String value = JSON.toJSONString(message, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteDateUseDateFormat});
            this.producer.send(new ProducerRecord(this.topic, (Object)value), new Callback(){

                public void onCompletion(RecordMetadata metadata, Exception exception) {
                    if (exception != null) {
                        // empty if block
                    }
                }
            });
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to become json", e);
        }
    }

    @Override
    public void flush() {
        this.producer.flush();
    }

    @Override
    public void close() {
        this.flush();
        this.producer.close();
    }

    public void setProps(String key, Object value) {
        this.props.put(key, value);
    }

    public void setTopic(String topic) {
        this.topic = topic;
    }

    private void init() {
        if (this.producer == null) {
            this.producer = new KafkaProducer(this.props);
        }
    }
}

