package cn.thinkingdata.tga.javasdk;

import cn.thinkingdata.tga.javasdk.exception.InvalidArgumentException;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

/**
 * Created by quanjie on 2018/4/16.
 */
public class TestMain {
    public static void main(String[] args) throws InvalidArgumentException, FileNotFoundException {
        if("logger".equals(args[0])){
            LoggerConsumerTest test = new LoggerConsumerTest();
            test.execute();
        }else if ("batch".equals(args[0])){
            BatchConsumerTest test = new BatchConsumerTest();
            test.execute();
        }else if ("kafka".equals(args[0])) {
            ProduceKafkaTest test = new ProduceKafkaTest();
            test.execute();
        }


    }
}

class ProduceKafkaTest {

    ProduceKafka produce = new ProduceKafka("test:9092","javasdk-1");
    ThinkingDataAnalytics tga = new ThinkingDataAnalytics(produce);

    public void close(){
        tga.flush();
        tga.close();
    }

    public void put_event_data(Map<String, Object> data){
        String distinct_id = (String) data.get("distinct_id");
        String account_id = (String) data.get("account_id");
        if(distinct_id != null){
            data.remove("distinct_id");
        }
        if(account_id != null){
            data.remove("account_id");
        }
        try {
            tga.track( account_id,distinct_id, "Payment", data);
        } catch (InvalidArgumentException e) {
            System.out.println(("write to tga failed,output was " + e.toString()));
        }
    }

    public void execute() {
        ProduceKafkaTest t = new ProduceKafkaTest();
        for (int i = 0; i < 15; i++) {
            Map<String, Object> data = new HashMap<>();
            data.put("account_id",i+"");
            data.put("distinct_id",i+"");
            data.put("gameid",i);
            data.put("from_appid","appid_"+i);
            data.put("time","2019-03-10");
            t.put_event_data(data);
        }
        t.close();

    }

}

class LoggerConsumerTest {

    String output = "/root/javasdktest/logdata";
    ThinkingDataAnalytics tga;

    public LoggerConsumerTest() throws FileNotFoundException {
        init();
    }

    public void init() throws FileNotFoundException {
        File dir = new File(output);
        if(!dir.exists()){
            dir.mkdir();
        }
        tga = new ThinkingDataAnalytics(new ThinkingDataAnalytics.LoggerConsumer(output,100));
    }

    public void close(){
        tga.flush();
        tga.close();
    }

    public void put_event_data(Map<String, Object> data){
        String distinct_id = (String) data.get("distinct_id");
        String account_id = (String) data.get("account_id");
        if(distinct_id != null){
            data.remove("distinct_id");
        }
        if(account_id != null){
            data.remove("account_id");
        }
        try {
            tga.track( account_id,distinct_id, "Payment", data);
        } catch (InvalidArgumentException e) {
            System.out.println(("write to tga failed,output was " + e.toString()));
        }
    }

    public void execute() throws FileNotFoundException {
        LoggerConsumerTest t = new LoggerConsumerTest();
        for (int i = 0; i < 305; i++) {
            Map<String, Object> data = new HashMap<>();
            data.put("account_id",i+"");
            data.put("distinct_id",i+"");
            data.put("gameid",i);
            data.put("from_appid","appid_"+i);
            data.put("time","2019-03-10");
            t.put_event_data(data);
        }
        t.close();

    }

}

class BatchConsumerTest {

    String server_uri="http://ta1:80/logagent";
    String appid = "9ec556e965d34dd1939eea73bfcaa070";
//    String server_uri="http://localhost:8326";
//    String appid = "a";
    ThinkingDataAnalytics tga;

    public BatchConsumerTest() throws FileNotFoundException {
        init();
    }

    public void init() {
        tga = new ThinkingDataAnalytics(new ThinkingDataAnalytics.BatchConsumer(server_uri,appid));
    }

    public void close(){
        tga.flush();
        tga.close();
    }

    public void put_event_data(Map<String, Object> data){
        String distinct_id = (String) data.get("distinct_id");
        String account_id = (String) data.get("account_id");
        if(distinct_id != null){
            data.remove("distinct_id");
        }
        if(account_id != null){
            data.remove("account_id");
        }
        try {
            tga.track( account_id,distinct_id, "Payment", data);
        } catch (InvalidArgumentException e) {
            System.out.println(("write to tga failed,output was " + e.toString()));
        }
    }

    public void execute() throws FileNotFoundException {
        BatchConsumerTest t = new BatchConsumerTest();
        for (int i = 0; i < 25; i++) {
            Map<String, Object> data = new HashMap<>();
            data.put("account_id",i+"");
            data.put("distinct_id",i+"");
            data.put("gameid",i);
            data.put("from_appid","appid_"+i);
            data.put("time","2019-03-10");
            t.put_event_data(data);
        }
        t.close();

    }


}