package cn.thinkingdata.tga.javasdk;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import org.apache.kafka.clients.producer.*;

import java.util.Map;
import java.util.Properties;

/**
 * Created by quanjie on 2018/4/16.
 */
public class ProduceKafka implements Consumer{
    private Properties props = new Properties();
    private Producer<String,String> producer = null;
    private String topic = null;

    public ProduceKafka(String Server,String topic){
        props.put("bootstrap.servers", Server);
        props.put("acks", "all");
        props.put("retries", 10);
        props.put("linger.ms",3);
        props.put("compression.type","gzip");
        props.put("key.serializer", "org.apache.kafka.common.serialization.StringSerializer");
        props.put("value.serializer", "org.apache.kafka.common.serialization.StringSerializer");

        this.topic = topic;
        JSON.DEFFAULT_DATE_FORMAT = "yyyy-MM-dd HH:mm:ss.SSS";
    }
    public ProduceKafka(String Server){
        this(Server,"tga_data_collector");
    }
    @Override
    public void send(Map<String, Object> message) {
        this.init();
        try {
            String value = JSON.toJSONString(message, SerializerFeature.WriteDateUseDateFormat);
            producer.send(new ProducerRecord<String, String>(this.topic, value), new Callback() {
                @Override
                public void onCompletion(RecordMetadata metadata, Exception exception) {
                    if(exception != null){

                    }
                }
            });
        } catch (Exception e) {
            throw new RuntimeException("Failed to become json",e);
        }

    }

    @Override
    public void flush() {
        producer.flush();
    }

    @Override
    public void close() {
        this.flush();
        producer.close();
    }

    public void setProps(String key,Object value){
        this.props.put(key,value);
    }
    public void setTopic(String topic){
        this.topic = topic ;
    }
    private void init(){
        if(producer == null){
            producer = new KafkaProducer<>(props);
        }
    }
}
