package cn.thinkingdata.tga.javasdk;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import org.apache.kafka.clients.producer.*;

import java.text.SimpleDateFormat;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ExecutionException;

/**
 * Created by quanjie on 2018/4/16.
 */
public class ProduceKafka implements Consumer{
    private Properties props = new Properties();
    private Producer<String,String> producer = null;
    private String topic = null;
    private final ObjectMapper jsonMapper;

    public ProduceKafka(String Server,String topic){
        props.put("bootstrap.servers", Server);
        props.put("acks", "all");
        props.put("retries", 10);
        props.put("linger.ms",3);
        props.put("compression.type","gzip");
        props.put("key.serializer", "org.apache.kafka.common.serialization.StringSerializer");
        props.put("value.serializer", "org.apache.kafka.common.serialization.StringSerializer");

        this.topic = topic;
        this.jsonMapper = new ObjectMapper();
        this.jsonMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        this.jsonMapper.setPropertyNamingStrategy(PropertyNamingStrategy.SNAKE_CASE);
        this.jsonMapper.setDateFormat(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS"));
    }
    public ProduceKafka(String Server){
        this(Server,"tga_data_collector");
    }
    @Override
    public void send(Map<String, Object> message) {
        this.init();
        try {
            String value = jsonMapper.writeValueAsString(message);
            producer.send(new ProducerRecord<String, String>(this.topic, value), new Callback() {
                @Override
                public void onCompletion(RecordMetadata metadata, Exception exception) {
                    if(exception != null){

                    }
                }
            });
        } catch (Exception e) {
            throw new RuntimeException("Failed to become json",e);
        }

    }

    @Override
    public void flush() {
        producer.flush();
    }

    @Override
    public void close() {
        this.flush();
        producer.close();
    }

    public void setProps(String key,Object value){
        this.props.put(key,value);
    }
    public void setTopic(String topic){
        this.topic = topic ;
    }
    private void init(){
        if(producer == null){
            producer = new KafkaProducer<>(props);
        }
    }
}
