package cn.thinkingdata.xiaomi;

import org.json.JSONException;
import org.json.JSONObject;

import cn.thinkingdata.installReferrer.model.BaseReferrer;
import cn.thinkingdata.installReferrer.utils.LogUtils;

public class XiaomiReferrer extends BaseReferrer {

    private final String installVersion;

    public XiaomiReferrer(String referrer, String installVersion,
                          long installBeginTimestampSeconds, long referrerClickTimestampSeconds,
                          long installBeginTimestampServerSeconds, long referrerClickTimestampServerSeconds) {
        super(referrer);
        this.installVersion = installVersion;
        this.installBeginTimestampSeconds = installBeginTimestampSeconds;
        this.referrerClickTimestampSeconds = referrerClickTimestampSeconds;
        this.installBeginTimestampServerSeconds = installBeginTimestampServerSeconds;
        this.referrerClickTimestampServerSeconds = referrerClickTimestampServerSeconds;
    }

    @Override
    public String toJsonString() {
        JSONObject jsonObject = new JSONObject();
        try {
            jsonObject.put("referrer", referrer);
            jsonObject.put("installVersion", installVersion);
            jsonObject.put("installBeginTimestampSeconds", installBeginTimestampSeconds);
            jsonObject.put("referrerClickTimestampSeconds", referrerClickTimestampSeconds);
            jsonObject.put("installBeginTimestampServerSeconds", installBeginTimestampServerSeconds);
            jsonObject.put("referrerClickTimestampServerSeconds", referrerClickTimestampServerSeconds);
        } catch (JSONException e) {
            LogUtils.e("XiaomiReferrer", " toJson error: " + e.getMessage());
        }
        return jsonObject.toString();
    }
}

