package cn.thinkingdata.xiaomi;

import android.content.Context;

import com.miui.referrer.annotation.GetAppsReferrerResponse;
import com.miui.referrer.api.GetAppsReferrerClient;
import com.miui.referrer.api.GetAppsReferrerDetails;
import com.miui.referrer.api.GetAppsReferrerStateListener;

import java.util.concurrent.TimeUnit;

import cn.thinkingdata.installReferrer.model.ReferrerInfo;
import cn.thinkingdata.installReferrer.platform.BasePlatform;
import cn.thinkingdata.installReferrer.utils.LogUtils;

public class XiaomiPlatform extends BasePlatform {
    private final static String TAG = LogUtils.INSTALL_REFERRER_TAG + XiaomiPlatform.class.getSimpleName();
    private static volatile XiaomiPlatform instance;

    private XiaomiPlatform() {

    }

    public static BasePlatform getInstance() {
        if (instance == null) {
            synchronized (BasePlatform.class) {
                if (instance == null) {
                    instance = new XiaomiPlatform();
                }
            }
        }
        return instance;
    }

    @Override
    public ReferrerInfo getReferrer(Context context) {
        try {
            final GetAppsReferrerClient referrerClient = new GetAppsReferrerClient.Builder(context).build();
            referrerClient.startConnection(new GetAppsReferrerStateListener() {
                @Override
                public void onGetAppsReferrerSetupFinished(int responseCode) {
                    try {
                        switch (responseCode) {
                            case GetAppsReferrerResponse.OK:
                                try {
                                    GetAppsReferrerDetails details = referrerClient.getInstallReferrer();
                                    referrerDetailsHolder.offer(getXiaomiReferrer(details));
                                } catch (Exception e) {
                                    getInstallReferrerError(e.getMessage());
                                } finally {
                                    referrerClient.endConnection();
                                }
                                break;
                            case GetAppsReferrerResponse.FEATURE_NOT_SUPPORTED:
                                featureNotSupported();
                                break;
                            case GetAppsReferrerResponse.SERVICE_UNAVAILABLE:
                                serviceUnavailable();
                                break;
                        }
                    } catch (Exception e) {
                        onInstallReferrerSetupError(e.getMessage());
                    }
                }

                @Override
                public void onGetAppsServiceDisconnected() {
                    referrerClient.endConnection();
                }
            });
            return referrerDetailsHolder.poll(waitTime, TimeUnit.MILLISECONDS);
        } catch (Exception e) {
            LogUtils.e(TAG, TAG + " unPredict exception: " + e.getMessage());
            return null;
        }
    }

    private static ReferrerInfo getXiaomiReferrer(GetAppsReferrerDetails details) {
        return new ReferrerInfo(new XiaomiReferrer(details.getInstallReferrer(), details.getInstallVersion(),
                details.getInstallBeginTimestampSeconds(), details.getReferrerClickTimestampSeconds(),
                details.getInstallBeginTimestampServerSeconds(), details.getReferrerClickTimestampServerSeconds()));
    }

    @Override
    public ReferrerInfo getReferrerInfo(Context context) {
        return checkReferrer(XiaomiPlatform.getInstance().getReferrer(context));
    }
}
