package cn.thinkingdata.samsung;

import org.json.JSONException;
import org.json.JSONObject;

import cn.thinkingdata.installReferrer.model.BaseReferrer;
import cn.thinkingdata.installReferrer.utils.LogUtils;

public class SamsungReferrer extends BaseReferrer {

    public SamsungReferrer(String referrer, long installBeginTimestampSeconds, long referrerClickTimestampSeconds) {
        super(referrer);
        this.installBeginTimestampSeconds = installBeginTimestampSeconds;
        this.referrerClickTimestampSeconds = referrerClickTimestampSeconds;
    }

    @Override
    public String toJsonString() {
        JSONObject jsonObject = new JSONObject();
        try {
            jsonObject.put("referrer", referrer);
            jsonObject.put("installBeginTimestampSeconds", installBeginTimestampSeconds);
            jsonObject.put("referrerClickTimestampSeconds", referrerClickTimestampSeconds);
        } catch (JSONException e) {
            LogUtils.e("SamsungReferrer", " toJson error: " + e.getMessage());
        }
        return jsonObject.toString();
    }
}

