package cn.thinkingdata.samsung;

import android.content.Context;

import com.samsung.android.sdk.sinstallreferrer.api.InstallReferrerClient;
import com.samsung.android.sdk.sinstallreferrer.api.InstallReferrerStateListener;
import com.samsung.android.sdk.sinstallreferrer.api.ReferrerDetails;

import java.util.concurrent.TimeUnit;

import cn.thinkingdata.installReferrer.model.ReferrerInfo;
import cn.thinkingdata.installReferrer.platform.BasePlatform;
import cn.thinkingdata.installReferrer.utils.LogUtils;

public class SamsungPlatform extends BasePlatform {

    private final static String TAG = LogUtils.INSTALL_REFERRER_TAG + SamsungPlatform.class.getSimpleName();
    private static volatile SamsungPlatform instance;

    private SamsungPlatform() {

    }

    public static BasePlatform getInstance() {
        if (instance == null) {
            synchronized (BasePlatform.class) {
                if (instance == null) {
                    instance = new SamsungPlatform();
                }
            }
        }
        return instance;
    }

    @Override
    public ReferrerInfo getReferrer(Context context) {
        try {
            final InstallReferrerClient referrerClient = InstallReferrerClient.newBuilder(context).build();
            referrerClient.startConnection(new InstallReferrerStateListener() {
                @Override
                public void onInstallReferrerSetupFinished(int responseCode) {
                    try {
                        switch (responseCode) {
                            case InstallReferrerClient.InstallReferrerResponse.OK:
                                try {
                                    ReferrerDetails details = referrerClient.getInstallReferrer();
                                    referrerDetailsHolder.offer(getSamsungReferrer(details));
                                } catch (Exception e) {
                                    getInstallReferrerError(e.getMessage());
                                } finally {
                                    referrerClient.endConnection();
                                }
                                break;
                            case InstallReferrerClient.InstallReferrerResponse.FEATURE_NOT_SUPPORTED:
                                featureNotSupported();
                                break;
                            case InstallReferrerClient.InstallReferrerResponse.SERVICE_UNAVAILABLE:
                                serviceUnavailable();
                                break;
                        }
                    } catch (Exception e) {
                        onInstallReferrerSetupError(e.getMessage());
                    }
                }

                @Override
                public void onInstallReferrerServiceDisconnected() {
                    referrerClient.endConnection();
                }
            });
            return referrerDetailsHolder.poll(waitTime, TimeUnit.MILLISECONDS);
        } catch (Exception e) {
            LogUtils.e(TAG, TAG + " unPredict exception: " + e.getMessage());
            return null;
        }
    }

    private static ReferrerInfo getSamsungReferrer(ReferrerDetails details) {
        return new ReferrerInfo(new SamsungReferrer(details.getInstallReferrer(),
                details.getInstallBeginTimestampSeconds(), details.getReferrerClickTimestampSeconds()));
    }

    @Override
    public ReferrerInfo getReferrerInfo(Context context) {
        return checkReferrer(SamsungPlatform.getInstance().getReferrer(context));
    }
}
