/*
 * Copyright (C) 2023 ThinkingData
 */
package cn.thinkingdata.strategy.utils;

import cn.thinkingdata.core.utils.LogUtil;
import cn.thinkingdata.core.utils.TDCommonUtil;

/**
 * @author liulongbing
 * @since 2023/12/8
 */
public class TDStrategyLog {

    private static final String TAG = "TDStrategySDK";

    public static boolean mEnableLog = false;

    public static void setEnableLog(boolean enable) {
        mEnableLog = enable;
    }

    public static void i(String msg) {
        if (mEnableLog) {
            LogUtil.i(TAG, "[ThinkingData] Info: " + msg);
        }
    }

    public static void i(String msg, Throwable t) {
        if (mEnableLog) {
            LogUtil.i(TAG, msg, t);
        }
    }

    public static void e(String msg) {
        if (mEnableLog) {
            LogUtil.e(TAG, msg);
        }
    }

    public static void e(Throwable t) {
        if (mEnableLog) {
            LogUtil.e(TAG, "", t);
        }
    }

    public static void e(String msg, Throwable t) {
        if (mEnableLog) {
            LogUtil.e(TAG, msg, t);
        }
    }

    public static void initLogTag() {
        if (getPropLogTag()) {
            setEnableLog(true);
        }
    }

    public static boolean getPropLogTag() {
        String tag = TDCommonUtil.getProp("debug.ta.strategy.log", "false");
        return "true".equals(tag);
    }

}
